/*
 * Decompiled with CFR 0.152.
 */
package org.forester.pccx;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.pccx.BranchCountingBasedScoringMethod;
import org.forester.pccx.CoverageCalculationOptions;
import org.forester.pccx.CoverageExtender;
import org.forester.pccx.ExternalNodeBasedCoverageMethodOptions;
import org.forester.pccx.ModelingUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicExternalNodeBasedCoverageExtender
implements CoverageExtender {
    private String find(CoverageCalculationOptions coverageCalculationOptions, BranchCountingBasedScoringMethod branchCountingBasedScoringMethod, List<SortedMap<PhylogenyNode, Double>> list, List<SortedMap<PhylogenyNode, Double>> list2, List<Phylogeny> list3, Set<String> set, PrintStream printStream, int n, double d) {
        Phylogeny phylogeny = list3.get(0);
        String string = null;
        double d2 = -1.7976931348623157E308;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            double d3;
            String string2 = phylogenyNodeIterator.next().getNodeName();
            if (set.contains(string2) || !((d3 = BasicExternalNodeBasedCoverageExtender.calculateCoverage(list3, string2, coverageCalculationOptions, branchCountingBasedScoringMethod, list2, false)) > d2)) continue;
            d2 = d3;
            string = string2;
        }
        BasicExternalNodeBasedCoverageExtender.calculateCoverage(list3, string, coverageCalculationOptions, branchCountingBasedScoringMethod, list2, true);
        if (printStream != null) {
            printStream.println(n + "\t" + string + "\t" + d2 * d);
        }
        return string;
    }

    @Override
    public List<String> find(List<Phylogeny> list, List<String> list2, int n, CoverageCalculationOptions coverageCalculationOptions, PrintStream printStream) {
        BranchCountingBasedScoringMethod branchCountingBasedScoringMethod;
        ExternalNodeBasedCoverageMethodOptions externalNodeBasedCoverageMethodOptions = (ExternalNodeBasedCoverageMethodOptions)coverageCalculationOptions;
        if (externalNodeBasedCoverageMethodOptions == null || ForesterUtil.isEmpty(externalNodeBasedCoverageMethodOptions.getScoringMethod())) {
            throw new IllegalArgumentException("options for external node based coverage method appear to not have been set");
        }
        try {
            branchCountingBasedScoringMethod = (BranchCountingBasedScoringMethod)Class.forName(externalNodeBasedCoverageMethodOptions.getScoringMethod()).newInstance();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("could not create scoring method class \"" + externalNodeBasedCoverageMethodOptions.getScoringMethod() + "\"");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<SortedMap<PhylogenyNode, Double>> arrayList2 = new ArrayList<SortedMap<PhylogenyNode, Double>>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList2.add(ModelingUtils.setUpExternalCoverageHashMap(list.get(i)));
        }
        if (list2 != null) {
            for (String string : list2) {
                hashSet.add(string);
                BasicExternalNodeBasedCoverageExtender.calculateCoverage(list, string, coverageCalculationOptions, branchCountingBasedScoringMethod, arrayList2, true);
            }
        }
        if (n < 1) {
            n = list.get(0).getNumberOfExternalNodes() - hashSet.size();
        }
        double d = branchCountingBasedScoringMethod.getNormalizationFactor(list.get(0));
        for (int i = 0; i < n; ++i) {
            String string = this.find(externalNodeBasedCoverageMethodOptions, branchCountingBasedScoringMethod, arrayList2, arrayList2, list, hashSet, printStream, i, d);
            hashSet.add(string);
            arrayList.add(string);
        }
        return arrayList;
    }

    private static double calculateCoverage(List<Phylogeny> list, String string, CoverageCalculationOptions coverageCalculationOptions, BranchCountingBasedScoringMethod branchCountingBasedScoringMethod, List<SortedMap<PhylogenyNode, Double>> list2, boolean bl) {
        int n = 0;
        double d = 0.0;
        for (Phylogeny phylogeny : list) {
            SortedMap<PhylogenyNode, Double> sortedMap = bl ? list2.get(n++) : new TreeMap<PhylogenyNode, Double>(list2.get(n++));
            Phylogeny phylogeny2 = phylogeny;
            branchCountingBasedScoringMethod.calculateScoreForExternalNode(sortedMap, phylogeny2, phylogeny2.getNode(string), coverageCalculationOptions);
            for (Double d2 : sortedMap.values()) {
                d += d2.doubleValue();
            }
        }
        return d / (double)n;
    }
}

