/*
 * Decompiled with CFR 0.152.
 */
package org.forester.pccx;

import java.util.SortedMap;
import org.forester.pccx.CoverageCalculationOptions;
import org.forester.pccx.ModelingUtils;
import org.forester.pccx.ScoringMethodForExternalNode;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchCountingBasedScoringMethod
implements ScoringMethodForExternalNode {
    double calculateScoreContributionPerExternalNode(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        double d = 0.0;
        d = phylogenyNode2 == phylogenyNode ? 1.0 : 1.0 / (double)ModelingUtils.calculateBranchSum(phylogenyNode, phylogenyNode2);
        return d;
    }

    @Override
    public void calculateScoreForExternalNode(SortedMap<PhylogenyNode, Double> sortedMap, Phylogeny phylogeny, PhylogenyNode phylogenyNode, CoverageCalculationOptions coverageCalculationOptions) {
        for (PhylogenyNode phylogenyNode2 : sortedMap.keySet()) {
            double d;
            PhylogenyNode phylogenyNode3 = phylogenyNode2;
            double d2 = this.calculateScoreContributionPerExternalNode(phylogenyNode, phylogenyNode3);
            if (!(d2 > (d = ((Double)sortedMap.get(phylogenyNode3)).doubleValue()))) continue;
            sortedMap.put(phylogenyNode3, d2);
        }
    }

    @Override
    public String getDesciption() {
        return "sum of 1/branch-segment-sum";
    }

    @Override
    public double getNormalizationFactor(Phylogeny phylogeny) {
        return 1.0 / (double)phylogeny.getNumberOfExternalNodes();
    }
}

