/*
 * Decompiled with CFR 0.152.
 */
package org.forester.pccx;

import org.forester.pccx.BranchCountingBasedScoringMethod;
import org.forester.pccx.ModelingUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public class BranchLengthBasedScoringMethod
extends BranchCountingBasedScoringMethod {
    public static final double MIN_ALLOWED_BL_VALUE = 0.001;

    double calculateScoreContributionPerExternalNode(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        double d = 0.0;
        d = phylogenyNode2 == phylogenyNode ? phylogenyNode.getDistanceToParent() : ModelingUtils.calculateBranchLengthSum(phylogenyNode, phylogenyNode2);
        return 1.0 / (d > 0.001 ? d : 0.001);
    }

    public String getDesciption() {
        return "sum of 1/branch-length-sum [for self: 1/branch-length] [min branch length: 0.0010]";
    }

    public double getNormalizationFactor(Phylogeny phylogeny) {
        double d = 0.0;
        double d2 = 0.0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            d2 = phylogenyNodeIterator.next().getDistanceToParent();
            d += 1.0 / (d2 > 0.001 ? d2 : 0.001);
        }
        return 1.0 / d;
    }
}

