/*
 * Decompiled with CFR 0.152.
 */
package org.forester.pccx;

import org.forester.pccx.Coverage;
import org.forester.pccx.CoverageCalculationOptions;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class ExternalNodeBasedCoverage
implements Coverage {
    private final double _av_normalized_score;
    private final double _av_raw_score;
    private final int _n;
    private final double _sd;
    private final double _max;
    private final double _min;

    public ExternalNodeBasedCoverage(DescriptiveStatistics descriptiveStatistics, double d, CoverageCalculationOptions coverageCalculationOptions) {
        this._av_normalized_score = descriptiveStatistics.arithmeticMean();
        this._av_raw_score = d;
        this._n = descriptiveStatistics.getN();
        this._sd = this._n > 1 ? descriptiveStatistics.sampleStandardDeviation() : 0.0;
        this._max = descriptiveStatistics.getMax();
        this._min = descriptiveStatistics.getMin();
    }

    public String asString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getN() == 1) {
            stringBuffer.append("Normalized score: " + this.getScore() + ForesterUtil.getLineSeparator());
            stringBuffer.append("Raw score       : " + this.getAvarageRawScore());
        } else {
            stringBuffer.append("Avarage normalized score: " + this.getScore() + " [sd=" + this.getSD() + " min=" + this.getMin() + " max=" + this.getMax() + " n=" + this.getN() + "]" + ForesterUtil.getLineSeparator());
            stringBuffer.append("Avarage raw score       : " + this.getAvarageRawScore());
        }
        return stringBuffer.toString();
    }

    public double getAvarageNormalizedScore() {
        return this._av_normalized_score;
    }

    public double getAvarageRawScore() {
        return this._av_raw_score;
    }

    public double getMax() {
        return this._max;
    }

    public double getMin() {
        return this._min;
    }

    public int getN() {
        return this._n;
    }

    public double getScore() {
        return this.getAvarageNormalizedScore();
    }

    public double getSD() {
        return this._sd;
    }
}

