/*
 * Decompiled with CFR 0.152.
 */
package org.forester.pccx;

import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.forester.pccx.BranchCountingBasedScoringMethod;
import org.forester.pccx.Coverage;
import org.forester.pccx.CoverageCalculationMethod;
import org.forester.pccx.CoverageCalculationOptions;
import org.forester.pccx.ExternalNodeBasedCoverage;
import org.forester.pccx.ExternalNodeBasedCoverageMethodOptions;
import org.forester.pccx.ModelingUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalNodeBasedCoverageMethod
implements CoverageCalculationMethod {
    private static final Color MEAN_COVERAGE_COLOR = new Color(0, 0, 0);
    private static final Color MAXIMAL_COV_COLOR = new Color(0, 255, 0);
    private static final Color MINIMAL_COV_COLOR = new Color(255, 0, 0);

    @Override
    public Coverage calculateCoverage(List<Phylogeny> list, List<String> list2, CoverageCalculationOptions coverageCalculationOptions, boolean bl) {
        BranchCountingBasedScoringMethod branchCountingBasedScoringMethod;
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        BasicDescriptiveStatistics basicDescriptiveStatistics2 = new BasicDescriptiveStatistics();
        ExternalNodeBasedCoverageMethodOptions externalNodeBasedCoverageMethodOptions = (ExternalNodeBasedCoverageMethodOptions)coverageCalculationOptions;
        if (externalNodeBasedCoverageMethodOptions == null || ForesterUtil.isEmpty(externalNodeBasedCoverageMethodOptions.getScoringMethod())) {
            throw new IllegalArgumentException("options for external node based coverage method appear to not have been set");
        }
        try {
            branchCountingBasedScoringMethod = (BranchCountingBasedScoringMethod)Class.forName(externalNodeBasedCoverageMethodOptions.getScoringMethod()).newInstance();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("could not create scoring method class \"" + externalNodeBasedCoverageMethodOptions.getScoringMethod() + "\"");
        }
        double d = branchCountingBasedScoringMethod.getNormalizationFactor(list.get(0));
        for (Phylogeny phylogeny : list) {
            double d2 = this.calculateCoverage(phylogeny, list2, coverageCalculationOptions, branchCountingBasedScoringMethod, bl, d);
            basicDescriptiveStatistics.addValue(d2 * d);
            basicDescriptiveStatistics2.addValue(d2);
        }
        return new ExternalNodeBasedCoverage(basicDescriptiveStatistics, basicDescriptiveStatistics2.arithmeticMean(), coverageCalculationOptions);
    }

    private double calculateCoverage(Phylogeny phylogeny, List<String> list, CoverageCalculationOptions coverageCalculationOptions, BranchCountingBasedScoringMethod branchCountingBasedScoringMethod, boolean bl, double d) {
        SortedMap<PhylogenyNode, Double> sortedMap = ModelingUtils.setUpExternalCoverageHashMap(phylogeny);
        for (String string : list) {
            branchCountingBasedScoringMethod.calculateScoreForExternalNode(sortedMap, phylogeny, phylogeny.getNode(string), coverageCalculationOptions);
        }
        if (bl) {
            this.colorizePhylogenyAccordingToCoverage(sortedMap, phylogeny, d);
        }
        double d2 = 0.0;
        for (Double d3 : sortedMap.values()) {
            d2 += d3.doubleValue();
        }
        return d2;
    }

    private void colorizePhylogenyAccordingToCoverage(SortedMap<PhylogenyNode, Double> sortedMap, Phylogeny phylogeny, double d) {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (Map.Entry<PhylogenyNode, Double> entry : sortedMap.entrySet()) {
            basicDescriptiveStatistics.addValue(entry.getValue() * d);
        }
        double d2 = basicDescriptiveStatistics.getMin();
        double d3 = basicDescriptiveStatistics.getMax();
        double d4 = basicDescriptiveStatistics.median();
        Iterator<Map.Entry<PhylogenyNode, Double>> iterator = sortedMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PhylogenyNode, Double> entry;
            Map.Entry<PhylogenyNode, Double> entry2 = entry = iterator.next();
            PhylogenyNode phylogenyNode = entry2.getKey();
            double d5 = entry2.getValue() * d;
            PhylogenyMethods.setBranchColorValue(phylogenyNode, ForesterUtil.calcColor(d5, d2, d3, d4, MINIMAL_COV_COLOR, MAXIMAL_COV_COLOR, MEAN_COVERAGE_COLOR));
        }
        PhylogenyMethods.postorderBranchColorAveragingExternalNodeBased(phylogeny);
    }
}

