/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny;

import java.util.ArrayList;
import java.util.List;
import org.forester.io.parsers.nhx.NHXFormatException;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.PhylogenyNodeI;
import org.forester.phylogeny.data.BranchData;
import org.forester.phylogeny.data.NodeData;
import org.forester.phylogeny.iterators.ChildNodeIteratorForward;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhylogenyNode
implements PhylogenyNodeI,
Comparable<PhylogenyNode> {
    public static final double DISTANCE_DEFAULT = -1024.0;
    private static int _node_count = 0;
    private byte _indicator;
    private int _id;
    private int _sum_ext_nodes;
    private float _x;
    private float _y;
    private String _node_name;
    private double _distance_parent;
    private boolean _collapse;
    private PhylogenyNode _parent;
    private PhylogenyNode _link;
    private ArrayList<PhylogenyNode> _descendants;
    private NodeData _node_data;
    private BranchData _branch_data;
    private float _x_secondary;
    private float _y_secondary;

    public PhylogenyNode() {
        this.init();
        this.setNodeId(PhylogenyNode.getNodeCount());
        PhylogenyNode.increaseNodeCount();
        this.setSumExtNodes(1);
    }

    public PhylogenyNode(String string) throws NHXFormatException {
        this(string, ForesterUtil.TAXONOMY_EXTRACTION.NO);
    }

    public PhylogenyNode(String string, ForesterUtil.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION) throws NHXFormatException {
        this.init();
        NHXParser.parseNHX(string, this, tAXONOMY_EXTRACTION, false);
        this.setNodeId(PhylogenyNode.getNodeCount());
        PhylogenyNode.increaseNodeCount();
        this.setSumExtNodes(1);
    }

    public PhylogenyNode(String string, ForesterUtil.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION, boolean bl) throws NHXFormatException {
        this.init();
        NHXParser.parseNHX(string, this, tAXONOMY_EXTRACTION, bl);
        this.setNodeId(PhylogenyNode.getNodeCount());
        PhylogenyNode.increaseNodeCount();
        this.setSumExtNodes(1);
    }

    @Override
    public final void addAsChild(PhylogenyNodeI phylogenyNodeI) {
        PhylogenyNode phylogenyNode = (PhylogenyNode)phylogenyNodeI;
        this.addChildNode(phylogenyNode);
        phylogenyNode.setParent(this);
    }

    private final void addChildNode(PhylogenyNode phylogenyNode) {
        this.getDescendants().add(phylogenyNode);
    }

    @Override
    public final int compareTo(PhylogenyNode phylogenyNode) {
        PhylogenyNode phylogenyNode2 = phylogenyNode;
        if (this.getNodeName() == null || phylogenyNode2.getNodeName() == null) {
            return 0;
        }
        return this.getNodeName().compareTo(phylogenyNode2.getNodeName());
    }

    public final PhylogenyNode copyNodeData() {
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        PhylogenyNode.decreaseNodeCount();
        phylogenyNode._id = this._id;
        phylogenyNode._sum_ext_nodes = this._sum_ext_nodes;
        phylogenyNode._indicator = this._indicator;
        phylogenyNode._x = this._x;
        phylogenyNode._y = this._y;
        if (this._node_name != null) {
            phylogenyNode._node_name = new String(this._node_name);
        }
        phylogenyNode._distance_parent = this._distance_parent;
        phylogenyNode._collapse = this._collapse;
        phylogenyNode._link = this._link;
        if (this._node_data != null) {
            phylogenyNode._node_data = (NodeData)this._node_data.copy();
        }
        if (this._branch_data != null) {
            phylogenyNode._branch_data = (BranchData)this._branch_data.copy();
        }
        return phylogenyNode;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + object + " [" + object.getClass() + "]");
        }
        PhylogenyNode phylogenyNode = (PhylogenyNode)object;
        if (!this.getNodeName().equals(phylogenyNode.getNodeName())) {
            return false;
        }
        NodeData nodeData = this.getNodeData();
        NodeData nodeData2 = phylogenyNode.getNodeData();
        if (nodeData.isHasSequence() && nodeData2.isHasSequence() && nodeData.isHasTaxonomy() && nodeData2.isHasTaxonomy()) {
            return nodeData.getTaxonomy().isEqual(nodeData2.getTaxonomy()) && nodeData.getSequence().isEqual(nodeData2.getSequence());
        }
        if (nodeData.isHasSequence() && nodeData2.isHasSequence()) {
            return nodeData.getSequence().isEqual(nodeData2.getSequence());
        }
        if (nodeData.isHasTaxonomy() && nodeData2.isHasTaxonomy()) {
            return nodeData.getTaxonomy().isEqual(nodeData2.getTaxonomy());
        }
        return this.getNodeName().length() > 0;
    }

    public final List<PhylogenyNode> getAllExternalDescendants() {
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        if (this.isExternal()) {
            arrayList.add(this);
            return arrayList;
        }
        PhylogenyNode phylogenyNode = this;
        while (!phylogenyNode.isExternal()) {
            phylogenyNode = phylogenyNode.getFirstChildNode();
        }
        PhylogenyNode phylogenyNode2 = this;
        while (!phylogenyNode2.isExternal()) {
            phylogenyNode2 = phylogenyNode2.getLastChildNode();
        }
        while (phylogenyNode != phylogenyNode2) {
            arrayList.add(phylogenyNode);
            phylogenyNode = phylogenyNode.getNextExternalNode();
        }
        arrayList.add(phylogenyNode2);
        return arrayList;
    }

    public final List<String> getAllExternalDescendantsNames() {
        List<PhylogenyNode> list = this.getAllExternalDescendants();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (PhylogenyNode phylogenyNode : list) {
            arrayList.add(phylogenyNode.getNodeName());
        }
        return arrayList;
    }

    public final BranchData getBranchData() {
        if (this._branch_data == null) {
            this._branch_data = new BranchData();
        }
        return this._branch_data;
    }

    final BranchData getBranchDataDirectly() {
        return this._branch_data;
    }

    @Override
    public final PhylogenyNode getChildNode(int n) {
        if (this.isExternal()) {
            throw new UnsupportedOperationException("attempt to get the child node of an external node.");
        }
        if (n >= this.getNumberOfDescendants() || n < 0) {
            throw new IllegalArgumentException("attempt to get child node " + n + " of a node with " + this.getNumberOfDescendants() + " child nodes");
        }
        return this.getDescendants().get(n);
    }

    public final PhylogenyNode getChildNode1() {
        return this.getChildNode(0);
    }

    public final PhylogenyNode getChildNode2() {
        return this.getChildNode(1);
    }

    public final int getChildNodeIndex() {
        return this.getChildNodeIndex(this.getParent());
    }

    public final int getChildNodeIndex(PhylogenyNode phylogenyNode) {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot get the child index for a root node.");
        }
        for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
            if (phylogenyNode.getChildNode(i) != this) continue;
            return i;
        }
        throw new RuntimeException("Unexpected exception: Could not determine the child index for node: " + this);
    }

    public final List<PhylogenyNode> getDescendants() {
        return this._descendants;
    }

    @Override
    public final double getDistanceToParent() {
        return this._distance_parent;
    }

    public final PhylogenyNode getFirstChildNode() {
        return this.getChildNode(0);
    }

    public final byte getIndicator() {
        return this._indicator;
    }

    public final PhylogenyNode getLastChildNode() {
        return this.getChildNode(this.getNumberOfDescendants() - 1);
    }

    public final PhylogenyNode getLink() {
        return this._link;
    }

    public final PhylogenyNode getNextExternalNode() {
        if (this.isInternal()) {
            throw new UnsupportedOperationException("attempt to get next external node of an internal node");
        }
        if (this.isLastExternalNode()) {
            return null;
        }
        int n = this.getChildNodeIndex();
        PhylogenyNode phylogenyNode = this;
        PhylogenyNode phylogenyNode2 = this.getParent();
        while (!phylogenyNode2.isRoot() && (phylogenyNode2.getNumberOfDescendants() == 1 || phylogenyNode.isLastChildNode())) {
            n = phylogenyNode2.getChildNodeIndex();
            phylogenyNode = phylogenyNode2;
            phylogenyNode2 = phylogenyNode2.getParent();
        }
        phylogenyNode2 = phylogenyNode2.getChildNode(n + 1);
        while (phylogenyNode2.isInternal()) {
            phylogenyNode2 = phylogenyNode2.getFirstChildNode();
        }
        return phylogenyNode2;
    }

    public final NodeData getNodeData() {
        if (this._node_data == null) {
            this._node_data = new NodeData();
        }
        return this._node_data;
    }

    final NodeData getNodeDataDirectly() {
        return this._node_data;
    }

    @Override
    public final int getNodeId() {
        return this._id;
    }

    @Override
    public final String getNodeName() {
        return this._node_name;
    }

    public final int getNumberOfDescendants() {
        return this._descendants.size();
    }

    public final int getNumberOfExternalNodes() {
        return this._sum_ext_nodes;
    }

    public final int getNumberOfParents() {
        return 1;
    }

    public final PhylogenyNode getParent() {
        return this._parent;
    }

    public final PhylogenyNode getPreviousExternalNode() {
        if (this.isInternal()) {
            throw new UnsupportedOperationException("Cannot get the previous external node for an internal node.");
        }
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot get the previous external node for a root node.");
        }
        if (this.isFirstExternalNode()) {
            throw new UnsupportedOperationException("Attempt to get previous external node of the first external node.");
        }
        int n = this.getChildNodeIndex();
        PhylogenyNode phylogenyNode = this;
        PhylogenyNode phylogenyNode2 = this.getParent();
        while (!phylogenyNode2.isRoot() && (phylogenyNode2.getNumberOfDescendants() == 1 || phylogenyNode.isFirstChildNode())) {
            n = phylogenyNode2.getChildNodeIndex();
            phylogenyNode = phylogenyNode2;
            phylogenyNode2 = phylogenyNode2.getParent();
        }
        phylogenyNode2 = phylogenyNode2.getChildNode(n - 1);
        while (phylogenyNode2.isInternal()) {
            phylogenyNode2 = phylogenyNode2.getLastChildNode();
        }
        return phylogenyNode2;
    }

    public final float getXcoord() {
        return this._x;
    }

    public final float getXSecondary() {
        return this._x_secondary;
    }

    public final float getYcoord() {
        return this._y;
    }

    public final float getYSecondary() {
        return this._y_secondary;
    }

    public final int hashCode() {
        NodeData nodeData = this.getNodeData();
        if (this.getNodeName().length() < 1 && !nodeData.isHasSequence() && !nodeData.isHasTaxonomy()) {
            return super.hashCode();
        }
        int n = this.getNodeName().hashCode();
        if (nodeData.isHasSequence()) {
            n ^= nodeData.getSequence().hashCode();
        }
        if (nodeData.isHasTaxonomy()) {
            n ^= nodeData.getTaxonomy().hashCode();
        }
        return n;
    }

    private final void init() {
        this._descendants = new ArrayList();
        this._parent = null;
        this._id = 0;
        this.initializeData();
    }

    public final void initializeData() {
        this._indicator = 0;
        this._x = 0.0f;
        this._y = 0.0f;
        this._node_name = "";
        this._distance_parent = -1024.0;
        this._collapse = false;
        this._link = null;
        this._branch_data = null;
        this._node_data = null;
    }

    public final boolean isCollapse() {
        return this._collapse;
    }

    public final boolean isDuplication() {
        return this.getNodeData().isHasEvent() && this.getNodeData().getEvent().isDuplication();
    }

    public final boolean isExternal() {
        return this.getNumberOfDescendants() < 1;
    }

    public final boolean isFirstChildNode() {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot determine whether the root is the first child node of its _parent.");
        }
        return this.getChildNodeIndex() == 0;
    }

    public final boolean isFirstExternalNode() {
        if (this.isInternal()) {
            return false;
        }
        PhylogenyNode phylogenyNode = this;
        while (!phylogenyNode.isRoot()) {
            if (!phylogenyNode.isFirstChildNode()) {
                return false;
            }
            phylogenyNode = phylogenyNode.getParent();
        }
        return true;
    }

    public final boolean isHasAssignedEvent() {
        if (!this.getNodeData().isHasEvent()) {
            return false;
        }
        return !this.getNodeData().getEvent().isUnassigned();
    }

    public final boolean isInternal() {
        return !this.isExternal();
    }

    public final boolean isLastChildNode() {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot determine whether the root is the last child node of its _parent.");
        }
        return this.getChildNodeIndex() == this.getParent().getNumberOfDescendants() - 1;
    }

    public final boolean isLastExternalNode() {
        if (this.isInternal()) {
            return false;
        }
        PhylogenyNode phylogenyNode = this;
        while (!phylogenyNode.isRoot()) {
            if (!phylogenyNode.isLastChildNode()) {
                return false;
            }
            phylogenyNode = phylogenyNode.getParent();
        }
        return true;
    }

    public final boolean isRoot() {
        return this._parent == null;
    }

    public final boolean isSpeciation() {
        return this.getNodeData().isHasEvent() && this.getNodeData().getEvent().isSpeciation();
    }

    public final PhylogenyNodeIterator iterateChildNodesForward() {
        return new ChildNodeIteratorForward(this);
    }

    public void preorderPrint() {
        System.out.println(this + "\n");
        if (this.isInternal()) {
            for (int i = 0; i < this.getNumberOfDescendants(); ++i) {
                this.getChildNode(i).preorderPrint();
            }
        }
    }

    public final void removeChildNode(int n) {
        if (this.isExternal()) {
            throw new UnsupportedOperationException("cannot get the child node for a external node.");
        }
        if (n >= this.getNumberOfDescendants() || n < 0) {
            throw new IllegalArgumentException("attempt to get child node " + n + " of a node with " + this.getNumberOfDescendants() + " child nodes.");
        }
        this.getDescendants().remove(n);
    }

    public final void removeChildNode(PhylogenyNode phylogenyNode) {
        this.removeChildNode(phylogenyNode.getChildNodeIndex());
    }

    public final void setBranchData(BranchData branchData) {
        this._branch_data = branchData;
    }

    public final void setChild1(PhylogenyNode phylogenyNode) {
        this.setChildNode(0, phylogenyNode);
    }

    public final void setChild2(PhylogenyNode phylogenyNode) {
        this.setChildNode(1, phylogenyNode);
    }

    public final void setChildNode(int n, PhylogenyNode phylogenyNode) {
        phylogenyNode.setParent(this);
        if (this.getNumberOfDescendants() <= n) {
            this.addChildNode(phylogenyNode);
        } else {
            this.getDescendants().set(n, phylogenyNode);
        }
    }

    final void setChildNodeOnly(int n, PhylogenyNode phylogenyNode) {
        if (this.getNumberOfDescendants() <= n) {
            this.addChildNode(phylogenyNode);
        } else {
            this.getDescendants().set(n, phylogenyNode);
        }
    }

    public final void setCollapse(boolean bl) {
        this._collapse = bl;
    }

    @Override
    public final void setDistanceToParent(double d) {
        this._distance_parent = d;
    }

    public final void setIndicator(byte by) {
        this._indicator = by;
    }

    final void setIndicatorsToZero() {
        PreorderTreeIterator preorderTreeIterator = new PreorderTreeIterator(this);
        while (preorderTreeIterator.hasNext()) {
            preorderTreeIterator.next().setIndicator((byte)0);
        }
    }

    public final void setLink(PhylogenyNode phylogenyNode) {
        this._link = phylogenyNode;
    }

    @Override
    public final void setName(String string) {
        this._node_name = string;
    }

    protected final void setNodeId(int n) {
        this._id = n;
    }

    @Override
    public final void setParent(PhylogenyNode phylogenyNode) {
        this._parent = phylogenyNode;
    }

    public final void setSumExtNodes(int n) {
        this._sum_ext_nodes = n;
    }

    public final void setXcoord(float f) {
        this._x = f;
    }

    public final void setXSecondary(float f) {
        this._x_secondary = f;
    }

    public final void setYcoord(float f) {
        this._y = f;
    }

    public final void setYSecondary(float f) {
        this._y_secondary = f;
    }

    public final String toNewHampshire(boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        if (!ForesterUtil.isEmpty(this.getNodeName())) {
            string = this.getNodeName();
        } else if (this.getNodeData().isHasTaxonomy()) {
            if (!ForesterUtil.isEmpty(this.getNodeData().getTaxonomy().getTaxonomyCode())) {
                string = this.getNodeData().getTaxonomy().getTaxonomyCode();
            } else if (!ForesterUtil.isEmpty(this.getNodeData().getTaxonomy().getScientificName())) {
                string = this.getNodeData().getTaxonomy().getScientificName();
            } else if (!ForesterUtil.isEmpty(this.getNodeData().getTaxonomy().getCommonName())) {
                string = this.getNodeData().getTaxonomy().getCommonName();
            } else if (this.getNodeData().getTaxonomy().getTaxonomyCode() != null) {
                string = this.getNodeData().getTaxonomy().getTaxonomyCode();
            }
        } else if (this.getNodeData().isHasSequence() && !ForesterUtil.isEmpty(this.getNodeData().getSequence().getName())) {
            string = this.getNodeData().getSequence().getName();
        }
        if (string.length() > 0) {
            string = ForesterUtil.replaceIllegalNhCharacters(string);
            if (bl) {
                if (string.length() > 10) {
                    string = string.substring(0, 11);
                }
                if (string.indexOf(47) > 0) {
                    string = string.substring(0, string.indexOf(47));
                }
                stringBuilder.append(string);
            } else {
                stringBuilder.append(string);
            }
        }
        if (this.getDistanceToParent() != -1024.0 && bl2) {
            stringBuilder.append(":");
            stringBuilder.append(this.getDistanceToParent());
        }
        return stringBuilder.toString();
    }

    public final String toNewHampshireX() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (!this.getNodeName().equals("")) {
            stringBuffer.append(ForesterUtil.replaceIllegalNhxCharacters(this.getNodeName()));
        }
        if (this.getDistanceToParent() != -1024.0) {
            stringBuffer.append(":");
            stringBuffer.append(this.getDistanceToParent());
        }
        if (this.getNodeDataDirectly() != null) {
            stringBuffer2.append(this.getNodeDataDirectly().toNHX());
        }
        if (this.getBranchDataDirectly() != null) {
            stringBuffer2.append(this.getBranchDataDirectly().toNHX());
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("[&&NHX");
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!ForesterUtil.isEmpty(this.getNodeName())) {
            stringBuilder.append(this.getNodeName());
            stringBuilder.append(" ");
        }
        stringBuilder.append("[");
        stringBuilder.append(this.getNodeId());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static final synchronized void decreaseNodeCount() {
        --_node_count;
    }

    public static final int getNodeCount() {
        return _node_count;
    }

    private static final synchronized void increaseNodeCount() {
        ++_node_count;
    }

    public static final synchronized void setNodeCount(int n) {
        _node_count = n;
    }
}

