/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Accession
implements PhylogenyData {
    final String _value;
    final String _source;

    public Accession(String string, String string2) {
        this._value = string;
        this._source = string2;
    }

    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getValue());
    }

    public StringBuffer asText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getSource())) {
            stringBuffer.append("[");
            stringBuffer.append(this.getSource());
            stringBuffer.append("] ");
        }
        stringBuffer.append(this.getValue());
        return stringBuffer;
    }

    public PhylogenyData copy() {
        return new Accession(new String(this.getValue()), new String(this.getSource()));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + object + " [" + object.getClass() + "]");
        }
        return this.isEqual((Accession)object);
    }

    public String getSource() {
        return this._source;
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        if (this.getSource() != null) {
            return (this.getSource() + this.getValue()).hashCode();
        }
        return this.getValue().hashCode();
    }

    public boolean isEqual(PhylogenyData phylogenyData) {
        if (this == phylogenyData) {
            return true;
        }
        if (phylogenyData == null || this.getValue() == null) {
            return false;
        }
        Accession accession = (Accession)phylogenyData;
        if (this.getSource() != null && accession.getSource() != null) {
            return accession.getValue().equals(this.getValue()) && accession.getSource().equals(this.getSource());
        }
        return accession.getValue().equals(this.getValue());
    }

    public StringBuffer toNHX() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(":");
        stringBuffer.append("AC=");
        stringBuffer.append(ForesterUtil.replaceIllegalNhxCharacters(this.getValue()));
        return stringBuffer;
    }

    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        if (ForesterUtil.isEmpty(this.getSource())) {
            PhylogenyDataUtil.appendElement(writer, "accession", this.getValue(), "source", "unknown", string);
        } else {
            PhylogenyDataUtil.appendElement(writer, "accession", this.getValue(), "source", this.getSource(), string);
        }
    }

    public String toString() {
        return this.asText().toString();
    }
}

