/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.PropertiesMap;
import org.forester.phylogeny.data.Uri;
import org.forester.util.ForesterUtil;

public class Annotation
implements PhylogenyData {
    private String _desc;
    private String _type;
    private String _source;
    private String _ref;
    private String _evidence;
    private Confidence _confidence;
    private PropertiesMap _properties;
    private Uri _uri;

    public Annotation() {
        this.init();
    }

    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getDesc());
    }

    public StringBuffer asText() {
        return new StringBuffer(this.getDesc());
    }

    public PhylogenyData copy() {
        Annotation annotation = new Annotation();
        if (this.getConfidence() != null) {
            annotation.setConfidence((Confidence)this.getConfidence().copy());
        } else {
            annotation.setConfidence(null);
        }
        annotation.setType(new String(this.getType()));
        annotation.setDesc(new String(this.getDesc()));
        annotation.setEvidence(new String(this.getEvidence()));
        annotation.setRef(new String(this.getRef()));
        annotation.setSource(new String(this.getSource()));
        if (this.getProperties() != null) {
            annotation.setProperties((PropertiesMap)this.getProperties().copy());
        } else {
            annotation.setProperties(null);
        }
        return annotation;
    }

    public Confidence getConfidence() {
        return this._confidence;
    }

    public String getDesc() {
        return this._desc;
    }

    public String getEvidence() {
        return this._evidence;
    }

    public PropertiesMap getProperties() {
        return this._properties;
    }

    public String getRef() {
        return this._ref;
    }

    public String getSource() {
        return this._source;
    }

    public String getType() {
        return this._type;
    }

    public Uri getUri() {
        return this._uri;
    }

    private void init() {
        this._desc = "";
        this._type = "";
        this._source = "";
        this._ref = "";
        this._evidence = "";
        this._confidence = null;
        this._properties = null;
        this._uri = null;
    }

    public boolean isEqual(PhylogenyData phylogenyData) {
        if (ForesterUtil.isEmpty(this.getDesc())) {
            return false;
        }
        return this.getDesc().equals(((Annotation)phylogenyData).getDesc());
    }

    public void setConfidence(Confidence confidence) {
        this._confidence = confidence;
    }

    public void setDesc(String string) {
        this._desc = string;
    }

    public void setEvidence(String string) {
        this._evidence = string;
    }

    public void setProperties(PropertiesMap propertiesMap) {
        this._properties = propertiesMap;
    }

    public void setRef(String string) {
        this._ref = string;
    }

    public void setSource(String string) {
        this._source = string;
    }

    public void setType(String string) {
        this._type = string;
    }

    public void setUri(Uri uri) {
        this._uri = uri;
    }

    public StringBuffer toNHX() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AN=");
        stringBuffer.append(ForesterUtil.replaceIllegalNhxCharacters(this.getDesc().toString()));
        return stringBuffer;
    }

    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        if (this.getConfidence() != null || this.getProperties() != null || this.getUri() != null || !ForesterUtil.isEmpty(this.getDesc())) {
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(string);
            PhylogenyDataUtil.appendOpen(writer, "annotation", "ref", this.getRef(), "evidence", this.getEvidence(), "type", this.getType(), "source", this.getSource());
            if (!ForesterUtil.isEmpty(this.getDesc())) {
                PhylogenyDataUtil.appendElement(writer, "desc", this.getDesc(), string);
            }
            if (this.getConfidence() != null) {
                this.getConfidence().toPhyloXML(writer, n, string + "  ");
            }
            if (this.getProperties() != null) {
                this.getProperties().toPhyloXML(writer, n, string);
            }
            if (this.getUri() != null) {
                this.getUri().toPhyloXML(writer, n, string);
            }
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(string);
            PhylogenyDataUtil.appendClose(writer, "annotation");
        } else {
            PhylogenyDataUtil.appendElement(writer, "annotation", "ref", this.getRef(), "evidence", this.getEvidence(), "type", this.getType(), "source", this.getSource(), string);
        }
    }

    public String toString() {
        return this.asText().toString();
    }
}

