/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryCharacters
implements PhylogenyData {
    public static final int COUNT_DEFAULT = -1;
    private final SortedSet<String> _present;
    private final SortedSet<String> _gained;
    private final SortedSet<String> _lost;
    private final int _present_count;
    private final int _gained_count;
    private final int _lost_count;
    private String _type;

    public BinaryCharacters() {
        this._present = new TreeSet<String>();
        this._gained = new TreeSet<String>();
        this._lost = new TreeSet<String>();
        this._present_count = -1;
        this._gained_count = -1;
        this._lost_count = -1;
    }

    public BinaryCharacters(SortedSet<String> sortedSet, SortedSet<String> sortedSet2, SortedSet<String> sortedSet3, String string) {
        this._present = sortedSet;
        this._gained = sortedSet2;
        this._lost = sortedSet3;
        this._type = string;
        this._present_count = -1;
        this._gained_count = -1;
        this._lost_count = -1;
    }

    public BinaryCharacters(SortedSet<String> sortedSet, SortedSet<String> sortedSet2, SortedSet<String> sortedSet3, String string, int n, int n2, int n3) {
        this._present = sortedSet;
        this._gained = sortedSet2;
        this._lost = sortedSet3;
        this._type = string;
        this._present_count = n;
        this._gained_count = n2;
        this._lost_count = n3;
        this.validate();
    }

    private void addCharacters(String string, Writer writer, String[] stringArray) throws IOException {
        for (String string2 : stringArray) {
            PhylogenyDataUtil.appendElement(writer, "bc", string2, string);
        }
    }

    public void addGainedCharacter(String string) {
        if (this.getLostCharacters().contains(string)) {
            throw new IllegalArgumentException("attempt to add binary character [" + string + "] to gained characters but is already listed as lost");
        }
        this.getGainedCharacters().add(string);
    }

    public void addLostCharacter(String string) {
        if (this.getPresentCharacters().contains(string)) {
            throw new IllegalArgumentException("attempt to add binary character [" + string + "] to lost characters but is already listed as present");
        }
        if (this.getGainedCharacters().contains(string)) {
            throw new IllegalArgumentException("attempt to add binary character [" + string + "] to lost characters but is already listed as gained");
        }
        this.getLostCharacters().add(string);
    }

    public void addPresentCharacter(String string) {
        if (this.getLostCharacters().contains(string)) {
            throw new IllegalArgumentException("attempt to add binary character [" + string + "] to present characters but is already listed as lost");
        }
        this.getPresentCharacters().add(string);
    }

    @Override
    public StringBuffer asSimpleText() {
        return this.asText();
    }

    @Override
    public StringBuffer asText() {
        this.validate();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("present [");
        stringBuffer.append(this.getPresentCount());
        stringBuffer.append("]: ");
        stringBuffer.append(this.getPresentCharactersAsStringBuffer());
        stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append("gained  [ ");
        stringBuffer.append(this.getGainedCount());
        stringBuffer.append("]: ");
        stringBuffer.append(this.getGainedCharactersAsStringBuffer());
        stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append("lost    [");
        stringBuffer.append(this.getLostCount());
        stringBuffer.append("]: ");
        stringBuffer.append(this.getLostCharactersAsStringBuffer());
        return stringBuffer;
    }

    @Override
    public PhylogenyData copy() {
        this.validate();
        return new BinaryCharacters(this.getPresentCharacters(), this.getGainedCharacters(), this.getLostCharacters(), this.getType(), this.getPresentCount(), this.getGainedCount(), this.getLostCount());
    }

    public SortedSet<String> getGainedCharacters() {
        return this._gained;
    }

    public String[] getGainedCharactersAsStringArray() {
        return BinaryCharacters.sortedSetToStringArray(this.getGainedCharacters());
    }

    public StringBuffer getGainedCharactersAsStringBuffer() {
        return BinaryCharacters.sortedSetToStringBuffer(this.getGainedCharacters(), " ");
    }

    public int getGainedCount() {
        return this._gained_count;
    }

    public SortedSet<String> getLostCharacters() {
        return this._lost;
    }

    public String[] getLostCharactersAsStringArray() {
        return BinaryCharacters.sortedSetToStringArray(this.getLostCharacters());
    }

    public StringBuffer getLostCharactersAsStringBuffer() {
        return BinaryCharacters.sortedSetToStringBuffer(this.getLostCharacters(), " ");
    }

    public int getLostCount() {
        return this._lost_count;
    }

    public SortedSet<String> getPresentCharacters() {
        return this._present;
    }

    public String[] getPresentCharactersAsStringArray() {
        return BinaryCharacters.sortedSetToStringArray(this.getPresentCharacters());
    }

    public StringBuffer getPresentCharactersAsStringBuffer() {
        return BinaryCharacters.sortedSetToStringBuffer(this.getPresentCharacters(), " ");
    }

    public int getPresentCount() {
        return this._present_count;
    }

    public String getType() {
        return this._type;
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        throw new UnsupportedOperationException();
    }

    public void setType(String string) {
        this._type = string;
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        this.validate();
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendOpen(writer, "binary_characters", "type", this.getType(), "gained_count", this.getGainedCount() != -1 ? String.valueOf(this.getGainedCount()) : "", "lost_count", this.getLostCount() != -1 ? String.valueOf(this.getLostCount()) : "", "present_count", this.getPresentCount() != -1 ? String.valueOf(this.getPresentCount()) : "");
        String string2 = string + "  ";
        if (this.getGainedCharacters().size() > 0) {
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(string2);
            PhylogenyDataUtil.appendOpen(writer, "gained");
            this.addCharacters(string2, writer, this.getGainedCharactersAsStringArray());
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(string2);
            PhylogenyDataUtil.appendClose(writer, "gained");
        }
        if (this.getLostCharacters().size() > 0) {
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(string2);
            PhylogenyDataUtil.appendOpen(writer, "lost");
            this.addCharacters(string2, writer, this.getLostCharactersAsStringArray());
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(string2);
            PhylogenyDataUtil.appendClose(writer, "lost");
        }
        if (this.getPresentCharacters().size() > 0) {
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(string2);
            PhylogenyDataUtil.appendOpen(writer, "present");
            this.addCharacters(string2, writer, this.getPresentCharactersAsStringArray());
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(string2);
            PhylogenyDataUtil.appendClose(writer, "present");
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendClose(writer, "binary_characters");
    }

    public String toString() {
        return this.asText().toString();
    }

    private void validate() {
        if (this.getPresentCount() != -1 && this.getPresentCharacters().size() > 0 && this.getPresentCount() != this.getPresentCharacters().size()) {
            throw new IllegalStateException("present characters size and count are unequal");
        }
        if (this.getGainedCount() != -1 && this.getGainedCharacters().size() > 0 && this.getGainedCount() != this.getGainedCharacters().size()) {
            throw new IllegalStateException("gained characters size and count are unequal");
        }
        if (this.getLostCount() != -1 && this.getLostCharacters().size() > 0 && this.getLostCount() != this.getLostCharacters().size()) {
            throw new IllegalStateException("lost characters size and count are unequal");
        }
    }

    private static String[] sortedSetToStringArray(SortedSet<String> sortedSet) {
        String[] stringArray = new String[sortedSet.size()];
        Iterator iterator = sortedSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n++] = (String)iterator.next();
        }
        return stringArray;
    }

    private static StringBuffer sortedSetToStringBuffer(SortedSet<String> sortedSet, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string);
        }
        return stringBuffer;
    }
}

