/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.BranchWidth;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.PhylogenyData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchData
implements PhylogenyData {
    private BranchColor _branch_color;
    private List<Confidence> _confidences;
    private BranchWidth _branch_width;

    public void addConfidence(Confidence confidence) {
        this.getConfidences().add(confidence);
    }

    @Override
    public StringBuffer asSimpleText() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuffer asText() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PhylogenyData copy() {
        BranchData branchData = new BranchData();
        if (this.isHasBranchColor()) {
            branchData.setBranchColor((BranchColor)this.getBranchColor().copy());
        }
        if (this.isHasBranchWidth()) {
            branchData.setBranchWidth((BranchWidth)this.getBranchWidth().copy());
        }
        if (this.isHasConfidences()) {
            for (Confidence confidence : this.getConfidences()) {
                branchData.addConfidence((Confidence)confidence.copy());
            }
        }
        return branchData;
    }

    public BranchColor getBranchColor() {
        return this._branch_color;
    }

    public BranchWidth getBranchWidth() {
        return this._branch_width;
    }

    public Confidence getConfidence(int n) {
        return this.getConfidences().get(n);
    }

    public List<Confidence> getConfidences() {
        if (this._confidences == null) {
            this._confidences = new ArrayList<Confidence>();
        }
        return this._confidences;
    }

    public int getNumberOfConfidences() {
        return this.getConfidences().size();
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        throw new UnsupportedOperationException();
    }

    public boolean isHasBranchColor() {
        return this.getBranchColor() != null;
    }

    public boolean isHasBranchWidth() {
        return this.getBranchWidth() != null;
    }

    public boolean isHasConfidences() {
        return this.getNumberOfConfidences() > 0;
    }

    public void setBranchColor(BranchColor branchColor) {
        this._branch_color = branchColor;
    }

    public void setBranchWidth(BranchWidth branchWidth) {
        this._branch_width = branchWidth;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isHasConfidences() && this.getConfidence(0).getValue() != -9999.0) {
            stringBuffer.append(":");
            stringBuffer.append(this.getConfidence(0).toNHX());
        }
        if (this.isHasBranchWidth() && this.getBranchWidth().getValue() != 1.0) {
            stringBuffer.append(":");
            stringBuffer.append(this.getBranchWidth().toNHX());
        }
        if (this.isHasBranchColor() && this.getBranchColor().getValue() != null) {
            stringBuffer.append(":");
            stringBuffer.append(this.getBranchColor().toNHX());
        }
        return stringBuffer;
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        if (this.isHasConfidences()) {
            for (Confidence confidence : this.getConfidences()) {
                confidence.toPhyloXML(writer, n, string);
            }
        }
        if (this.isHasBranchWidth()) {
            this.getBranchWidth().toPhyloXML(writer, n, string);
        }
        if (this.isHasBranchColor()) {
            this.getBranchColor().toPhyloXML(writer, n, string);
        }
    }
}

