/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Date
implements PhylogenyData {
    private String _desc;
    private BigDecimal _value;
    private BigDecimal _min;
    private BigDecimal _max;
    private String _unit;

    public Date() {
        this._desc = "";
        this._value = null;
        this._min = null;
        this._max = null;
        this._unit = "";
    }

    public Date(String string) {
        if (string == null) {
            throw new IllegalArgumentException("illegaly empty of null fields in constructor");
        }
        this._desc = string;
        this._value = null;
        this._min = null;
        this._max = null;
        this._unit = "";
    }

    public Date(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("illegaly empty of null fields in constructor");
        }
        this._desc = string;
        this._value = bigDecimal;
        this._min = bigDecimal2;
        this._max = bigDecimal3;
        this._unit = string2;
    }

    public StringBuffer asSimpleText() {
        if (this.getValue() != null) {
            return new StringBuffer(this.getDesc() + " [" + this.getValue().toPlainString() + " " + this.getUnit() + "]");
        }
        return new StringBuffer(this.getDesc());
    }

    public StringBuffer asText() {
        return this.asSimpleText();
    }

    public PhylogenyData copy() {
        return new Date(new String(this.getDesc()), this.getValue() == null ? null : new BigDecimal(this.getValue().toPlainString()), this.getMin() == null ? null : new BigDecimal(this.getMin().toPlainString()), this.getMax() == null ? null : new BigDecimal(this.getMax().toPlainString()), new String(this.getUnit()));
    }

    public String getDesc() {
        return this._desc;
    }

    public BigDecimal getMax() {
        return this._max;
    }

    public BigDecimal getMin() {
        return this._min;
    }

    public String getUnit() {
        return this._unit;
    }

    public BigDecimal getValue() {
        return this._value;
    }

    public boolean isEqual(PhylogenyData phylogenyData) {
        throw new UnsupportedOperationException();
    }

    public void setDesc(String string) {
        this._desc = string;
    }

    public void setMax(BigDecimal bigDecimal) {
        this._max = bigDecimal;
    }

    public void setMin(BigDecimal bigDecimal) {
        this._min = bigDecimal;
    }

    public void setUnit(String string) {
        this._unit = string;
    }

    public void setValue(BigDecimal bigDecimal) {
        this._value = bigDecimal;
    }

    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendOpen(writer, "date", "unit", this.getUnit());
        if (!ForesterUtil.isEmpty(this.getDesc())) {
            PhylogenyDataUtil.appendElement(writer, "desc", this.getDesc(), string);
        }
        if (this.getValue() != null) {
            PhylogenyDataUtil.appendElement(writer, "value", this.getValue().toPlainString(), string);
        }
        if (this.getMin() != null) {
            PhylogenyDataUtil.appendElement(writer, "minimum", this.getMin().toPlainString(), string);
        }
        if (this.getMax() != null) {
            PhylogenyDataUtil.appendElement(writer, "maximum", this.getMax().toPlainString(), string);
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendClose(writer, "date");
    }

    public String toString() {
        return this.asSimpleText().toString();
    }
}

