/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.Point;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polygon
implements PhylogenyData {
    private final List<Point> _points;

    public Polygon(List<Point> list) {
        this._points = list;
    }

    @Override
    public StringBuffer asSimpleText() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (Point point : this.getPoints()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
            }
            stringBuffer.append(point.asSimpleText());
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    @Override
    public PhylogenyData copy() {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (Point point : this.getPoints()) {
            arrayList.add((Point)point.copy());
        }
        return new Polygon(arrayList);
    }

    public List<Point> getPoints() {
        return this._points;
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendOpen(writer, "polygon");
        for (Point point : this.getPoints()) {
            point.toPhyloXML(writer, n, string + "  ");
            writer.write(string);
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendClose(writer, "polygon");
    }
}

