/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Property;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesMap
implements PhylogenyData {
    private final SortedMap<String, Property> _properties = new TreeMap<String, Property>();

    public void addProperty(Property property) throws IllegalArgumentException {
        if (this.getProperties().containsKey(property.getRef())) {
            throw new IllegalArgumentException("ref [" + property.getRef() + "] is already present");
        }
        this.getProperties().put(property.getRef(), property);
    }

    @Override
    public StringBuffer asSimpleText() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string : this.getPropertyRefs()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.getProperty(string).asText());
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    @Override
    public PhylogenyData copy() {
        PropertiesMap propertiesMap = new PropertiesMap();
        for (String string : this.getProperties().keySet()) {
            propertiesMap.addProperty((Property)this.getProperties().get(string));
        }
        return propertiesMap;
    }

    public SortedMap<String, Property> getProperties() {
        return this._properties;
    }

    public Property[] getPropertiesArray() {
        Property[] propertyArray = new Property[this.getProperties().size()];
        int n = 0;
        for (String string : this.getProperties().keySet()) {
            propertyArray[n++] = (Property)this.getProperties().get(string);
        }
        return propertyArray;
    }

    public List<Property> getPropertiesWithGivenReferencePrefix(String string) throws IllegalArgumentException {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("reference prefix is null or empty");
        }
        String string2 = new String(string.trim());
        if (!string2.endsWith(":")) {
            string2 = string2 + ":";
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (String string3 : this.getProperties().keySet()) {
            if (!string3.startsWith(string2)) continue;
            arrayList.add(this.getProperty(string3));
        }
        return arrayList;
    }

    public Property getProperty(String string) throws IllegalArgumentException {
        if (this.getProperties().containsKey(string)) {
            return (Property)this.getProperties().get(string);
        }
        throw new IllegalArgumentException("reference [" + string + "] is not present");
    }

    public String[] getPropertyRefs() {
        if (this.getProperties() == null) {
            return new String[0];
        }
        Property[] propertyArray = this.getPropertiesArray();
        String[] stringArray = new String[propertyArray.length];
        for (int i = 0; i < propertyArray.length; ++i) {
            stringArray[i] = propertyArray[i].getRef();
        }
        return stringArray;
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        throw new UnsupportedOperationException();
    }

    public boolean refExists(String string) {
        if (this.getProperties() != null) {
            for (String string2 : this.getProperties().keySet()) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    public Property removeProperty(String string) throws IllegalArgumentException {
        if (this.getProperties().containsKey(string)) {
            return (Property)this.getProperties().remove(string);
        }
        throw new IllegalArgumentException("reference [" + string + "] is not present");
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getProperties() != null) {
            for (String string : this.getProperties().keySet()) {
                stringBuffer.append(((Property)this.getProperties().get(string)).toNHX());
            }
        }
        return stringBuffer;
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        if (this.getProperties() != null) {
            for (String string2 : this.getProperties().keySet()) {
                ((Property)this.getProperties().get(string2)).toPhyloXML(writer, n, string);
            }
        }
    }

    public String toString() {
        return this.asSimpleText().toString();
    }
}

