/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlUtil;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.SequenceRelation;
import org.forester.phylogeny.data.Uri;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sequence
implements PhylogenyData {
    private String _mol_sequence;
    private String _name;
    private String _source_id;
    private Accession _accession;
    private String _symbol;
    private String _location;
    private String _type;
    private List<PhylogenyData> _annotations;
    private DomainArchitecture _da;
    private Uri _uri;
    private final List<SequenceRelation> _seq_relations = new ArrayList<SequenceRelation>();

    public Sequence() {
        this.init();
    }

    public void addAnnotation(Annotation annotation) {
        this.getAnnotations().add(annotation);
    }

    public void addSequenceRelation(SequenceRelation sequenceRelation) {
        this._seq_relations.add(sequenceRelation);
    }

    @Override
    public StringBuffer asSimpleText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getAccession() != null) {
            stringBuffer.append("[");
            stringBuffer.append(this.getAccession());
            stringBuffer.append("] ");
        }
        if (!ForesterUtil.isEmpty(this.getName())) {
            stringBuffer.append(this.getName());
            stringBuffer.append(" ");
        }
        if (!ForesterUtil.isEmpty(this.getLocation())) {
            stringBuffer.append(this.getLocation());
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    @Override
    public PhylogenyData copy() {
        Sequence sequence = new Sequence();
        sequence.setAnnotations(this.getAnnotations());
        sequence.setName(new String(this.getName()));
        sequence.setSymbol(new String(this.getSymbol()));
        sequence.setMolecularSequence(new String(this.getMolecularSequence()));
        sequence.setLocation(new String(this.getLocation()));
        if (this.getAccession() != null) {
            sequence.setAccession((Accession)this.getAccession().copy());
        } else {
            sequence.setAccession(null);
        }
        sequence.setType(new String(this.getType()));
        if (this.getUri() != null) {
            sequence.setUri((Uri)this.getUri().copy());
        } else {
            sequence.setUri(null);
        }
        if (this.getDomainArchitecture() != null) {
            sequence.setDomainArchitecture((DomainArchitecture)this.getDomainArchitecture().copy());
        } else {
            sequence.setDomainArchitecture(null);
        }
        return sequence;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + object + " [" + object.getClass() + "]");
        }
        return this.isEqual((Sequence)object);
    }

    public Accession getAccession() {
        return this._accession;
    }

    public PhylogenyData getAnnotation(int n) {
        return this.getAnnotations().get(n);
    }

    public List<PhylogenyData> getAnnotations() {
        return this._annotations;
    }

    public DomainArchitecture getDomainArchitecture() {
        return this._da;
    }

    public String getLocation() {
        return this._location;
    }

    public String getMolecularSequence() {
        return this._mol_sequence;
    }

    public String getName() {
        return this._name;
    }

    public List<SequenceRelation> getSequenceRelations() {
        return this._seq_relations;
    }

    public String getSourceId() {
        return this._source_id;
    }

    public String getSymbol() {
        return this._symbol;
    }

    public String getType() {
        return this._type;
    }

    public Uri getUri() {
        return this._uri;
    }

    public int hashCode() {
        if (this.getAccession() != null) {
            return this.getAccession().hashCode();
        }
        int n = this.getSymbol().hashCode();
        if (this.getName().length() > 0) {
            n ^= this.getName().hashCode();
        }
        if (this.getMolecularSequence().length() > 0) {
            n ^= this.getMolecularSequence().hashCode();
        }
        return n;
    }

    public boolean hasSequenceRelations() {
        return this._seq_relations.size() > 0;
    }

    public void init() {
        this.setAnnotations(new ArrayList<PhylogenyData>());
        this.setName("");
        this.setMolecularSequence("");
        this.setLocation("");
        this.setAccession(null);
        this.setSymbol("");
        this.setType("");
        this.setDomainArchitecture(null);
        this.setUri(null);
    }

    public boolean isEmpty() {
        return this.getAccession() == null && ForesterUtil.isEmpty(this.getName()) && ForesterUtil.isEmpty(this.getSymbol()) && ForesterUtil.isEmpty(this.getType()) && ForesterUtil.isEmpty(this.getLocation()) && ForesterUtil.isEmpty(this.getMolecularSequence()) && this.getDomainArchitecture() == null && this.getAnnotations().isEmpty() && this.getUri() == null;
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        if (this == phylogenyData) {
            return true;
        }
        Sequence sequence = (Sequence)phylogenyData;
        if (this.getAccession() != null && sequence.getAccession() != null) {
            return this.getAccession().isEqual(sequence.getAccession());
        }
        return sequence.getMolecularSequence().equals(this.getMolecularSequence()) && sequence.getName().equals(this.getName()) && sequence.getSymbol().equals(this.getSymbol());
    }

    public void setAccession(Accession accession) {
        this._accession = accession;
    }

    private void setAnnotations(List<PhylogenyData> list) {
        this._annotations = list;
    }

    public void setDomainArchitecture(DomainArchitecture domainArchitecture) {
        this._da = domainArchitecture;
    }

    public void setLocation(String string) {
        this._location = string;
    }

    public void setMolecularSequence(String string) {
        this._mol_sequence = string;
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setSourceId(String string) {
        this._source_id = string;
    }

    public void setSymbol(String string) {
        if (!ForesterUtil.isEmpty(string) && !PhyloXmlUtil.SEQUENCE_SYMBOL_PATTERN.matcher(string).matches()) {
            throw new PhyloXmlDataFormatException("illegal sequence symbol: [" + string + "]");
        }
        this._symbol = string;
    }

    public void setType(String string) {
        if (!ForesterUtil.isEmpty(string) && !PhyloXmlUtil.SEQUENCE_TYPES.contains(string)) {
            throw new PhyloXmlDataFormatException("illegal sequence type: [" + string + "]");
        }
        this._type = string;
    }

    public void setUri(Uri uri) {
        this._uri = uri;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getName().length() > 0) {
            stringBuffer.append(":");
            stringBuffer.append("GN=");
            stringBuffer.append(ForesterUtil.replaceIllegalNhxCharacters(this.getName()));
        }
        if (this.getAccession() != null) {
            this.getAccession().toNHX();
        }
        if (this.getDomainArchitecture() != null) {
            stringBuffer.append(this.getDomainArchitecture().toNHX());
        }
        return stringBuffer;
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        String string2 = string + "  ";
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendOpen(writer, "sequence", "type", this.getType());
        if (!ForesterUtil.isEmpty(this.getSymbol())) {
            PhylogenyDataUtil.appendElement(writer, "symbol", this.getSymbol(), string);
        }
        if (this.getAccession() != null && !ForesterUtil.isEmpty(this.getAccession().getValue())) {
            this.getAccession().toPhyloXML(writer, n, string);
        }
        if (!ForesterUtil.isEmpty(this.getName())) {
            PhylogenyDataUtil.appendElement(writer, "name", this.getName(), string);
        }
        if (!ForesterUtil.isEmpty(this.getLocation())) {
            PhylogenyDataUtil.appendElement(writer, "location", this.getLocation(), string);
        }
        if (!ForesterUtil.isEmpty(this.getMolecularSequence())) {
            PhylogenyDataUtil.appendElement(writer, "mol_seq", this.getMolecularSequence(), string);
        }
        if (this.getUri() != null) {
            this.getUri().toPhyloXML(writer, n, string);
        }
        if (!this.getAnnotations().isEmpty()) {
            for (PhylogenyData phylogenyData : this.getAnnotations()) {
                phylogenyData.toPhyloXML(writer, n, string2);
            }
        }
        if (this.getDomainArchitecture() != null) {
            this.getDomainArchitecture().toPhyloXML(writer, n, string2);
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendClose(writer, "sequence");
    }

    public String toString() {
        return this.asText().toString();
    }
}

