/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.iterators;

import java.util.NoSuchElementException;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public class ChildNodeIteratorForward
implements PhylogenyNodeIterator {
    private int _i;
    private final PhylogenyNode _node;

    public ChildNodeIteratorForward(PhylogenyNode phylogenyNode) throws IllegalArgumentException {
        if (phylogenyNode.getNumberOfDescendants() < 1) {
            throw new IllegalArgumentException("Attempt to use ChildNodeIteratorForward on node with no child nodes.");
        }
        this._node = phylogenyNode;
        this.reset();
    }

    private int getI() {
        return this._i;
    }

    private PhylogenyNode getNode() {
        return this._node;
    }

    public boolean hasNext() {
        return this.getI() < this.getNode().getNumberOfDescendants();
    }

    private void increaseI() {
        ++this._i;
    }

    public PhylogenyNode next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Attempt to call \"next()\" on iterator which has no more next elements.");
        }
        PhylogenyNode phylogenyNode = this.getNode().getChildNode(this.getI());
        this.increaseI();
        return phylogenyNode;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        this.setI(0);
    }

    private void setI(int n) {
        this._i = n;
    }
}

