/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogenyinference;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Random;
import java.util.StringTokenizer;
import org.forester.phylogenyinference.DistanceMatrix;
import org.forester.util.ForesterUtil;

public class BasicSymmetricalDistanceMatrix
implements DistanceMatrix {
    NumberFormat nf1 = NumberFormat.getInstance();
    private static final NumberFormat PHYLIP_FORMATTER = new DecimalFormat("0.000000");
    final double[][] _values;
    final String[] _identifiers;

    public BasicSymmetricalDistanceMatrix(int n) {
        this._values = new double[n][n];
        this._identifiers = new String[n];
    }

    public String getIdentifier(int n) {
        return this._identifiers[n];
    }

    public int getIndex(String string) {
        for (int i = 0; i < this._identifiers.length; ++i) {
            if (!this.getIdentifier(i).equals(string)) continue;
            return i;
        }
        throw new IllegalArgumentException("identifier [" + string + "] not found in distance matrix");
    }

    public int getSize() {
        return this._values.length;
    }

    public double getValue(int n, int n2) {
        if (n == n2) {
            if (n >= this.getSize()) {
                throw new IndexOutOfBoundsException("");
            }
            return 0.0;
        }
        if (n > n2) {
            return this._values[n2][n];
        }
        return this._values[n][n2];
    }

    public void randomize(long l) {
        Random random = new Random(l);
        for (int i = 0; i < this.getSize(); ++i) {
            for (int j = 0; j < i; ++j) {
                this.setValue(j, i, random.nextDouble());
            }
        }
    }

    public void setIdentifier(int n, String string) {
        this._identifiers[n] = string;
    }

    public void setRow(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = 0;
        while (stringTokenizer.hasMoreElements()) {
            this.setValue(n2, n, new Double(stringTokenizer.nextToken()));
            ++n2;
        }
    }

    public void setValue(int n, int n2, double d) {
        if (n == n2 && d != 0.0) {
            throw new IllegalArgumentException("attempt to set a non-zero value on the diagonal of a symmetrical distance matrix");
        }
        if (n > n2) {
            this._values[n2][n] = d;
        }
        this._values[n][n2] = d;
    }

    private StringBuffer toPhylip() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(' ');
        stringBuffer.append(' ');
        stringBuffer.append(' ');
        stringBuffer.append(' ');
        stringBuffer.append(this.getSize());
        stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        for (int i = 0; i < this.getSize(); ++i) {
            if (ForesterUtil.isEmpty(this.getIdentifier(i))) {
                throw new IllegalStateException("PHYLIP format does not allow empty identifiers");
            }
            stringBuffer.append(ForesterUtil.pad(this.getIdentifier(i), 10, ' ', false));
            stringBuffer.append(' ');
            stringBuffer.append(' ');
            stringBuffer.append("");
            for (int j = 0; j < this.getSize(); ++j) {
                stringBuffer.append(PHYLIP_FORMATTER.format(this.getValue(j, i)));
                if (j >= this.getSize() - 1) continue;
                stringBuffer.append(' ');
                stringBuffer.append(' ');
            }
            if (i >= this.getSize() - 1) continue;
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        }
        return stringBuffer;
    }

    public String toString() {
        return this.toPhylip().toString();
    }

    public StringBuffer toStringBuffer(DistanceMatrix.Format format) {
        switch (format) {
            case PHYLIP: {
                return this.toPhylip();
            }
        }
        throw new IllegalArgumentException("Unknown format:" + (Object)((Object)format));
    }
}

