/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogenyinference;

import java.util.ArrayList;
import java.util.List;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.PhylogenyNodeI;
import org.forester.phylogenyinference.BasicSymmetricalDistanceMatrix;
import org.forester.phylogenyinference.DistanceMatrix;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeighborJoining {
    private static final boolean VERBOSE_DEFAULT = false;
    private DistanceMatrix _d;
    private DistanceMatrix _m;
    private double[] _r;
    private int _n;
    private PhylogenyNodeI[] _external_nodes;
    private int[] _mappings;
    private boolean _verbose;

    private NeighborJoining() {
        this.init();
    }

    private void calculateDistancesFromNewNode(int n, int n2, double d) {
        for (int i = 0; i < this._n; ++i) {
            if (i == n || i == n2) continue;
            double d2 = (this.getValueFromD(n, i) + this.getValueFromD(i, n2) - d) / 2.0;
            this.setValueInD(d2, n, i);
        }
    }

    private double calculateM(int n, int n2) {
        return this.getValueFromD(n, n2) - (this._r[n] + this._r[n2]) / (double)(this._n - 2);
    }

    private void calculateNetDivergences() {
        for (int i = 0; i < this._n; ++i) {
            double d = 0.0;
            for (int j = 0; j < this._n; ++j) {
                d += this.getValueFromD(i, j);
            }
            this._r[i] = d;
        }
    }

    public Phylogeny execute(DistanceMatrix distanceMatrix) {
        this.reset(distanceMatrix);
        Phylogeny phylogeny = new Phylogeny();
        while (this._n > 2) {
            this.updateM();
            int[] nArray = this.findMinimalDistance();
            int n = nArray[0];
            int n2 = nArray[1];
            if (n > n2) {
                throw new AssertionError((Object)"NJ code is faulty: otu1 > otu2");
            }
            PhylogenyNode phylogenyNode = new PhylogenyNode();
            double d = this.getValueFromD(n, n2);
            double d2 = d / 2.0 + (this._r[n] - this._r[n2]) / (double)(2 * (this._n - 2));
            double d3 = d - d2;
            this.getExternalPhylogenyNode(n).setDistanceToParent(d2);
            this.getExternalPhylogenyNode(n2).setDistanceToParent(d3);
            phylogenyNode.addAsChild(this.getExternalPhylogenyNode(n));
            phylogenyNode.addAsChild(this.getExternalPhylogenyNode(n2));
            if (this.isVerbose()) {
                this.printProgress(n, n2);
            }
            this.calculateDistancesFromNewNode(n, n2, d);
            this.setExternalPhylogenyNode(phylogenyNode, n);
            this.updateMappings(n2);
            --this._n;
        }
        double d = this.getValueFromD(0, 1) / 2.0;
        this.getExternalPhylogenyNode(0).setDistanceToParent(d);
        this.getExternalPhylogenyNode(1).setDistanceToParent(d);
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        phylogenyNode.addAsChild(this.getExternalPhylogenyNode(0));
        phylogenyNode.addAsChild(this.getExternalPhylogenyNode(1));
        if (this.isVerbose()) {
            this.printProgress(0, 1);
        }
        phylogeny.setRoot(phylogenyNode);
        phylogeny.setRooted(false);
        return phylogeny;
    }

    public List<Phylogeny> execute(List<DistanceMatrix> list) {
        ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>();
        for (DistanceMatrix distanceMatrix : list) {
            arrayList.add(this.execute(distanceMatrix));
        }
        return arrayList;
    }

    private int[] findMinimalDistance() {
        double d = Double.MAX_VALUE;
        int n = -1;
        int n2 = -1;
        for (int i = 1; i < this._n; ++i) {
            for (int j = 0; j < i; ++j) {
                if (!(this._m.getValue(j, i) < d)) continue;
                d = this._m.getValue(j, i);
                n = j;
                n2 = i;
            }
        }
        return new int[]{n, n2};
    }

    private PhylogenyNodeI getExternalPhylogenyNode(int n) {
        return this._external_nodes[this._mappings[n]];
    }

    private double getValueFromD(int n, int n2) {
        return this._d.getValue(this._mappings[n], this._mappings[n2]);
    }

    private void init() {
        this.setVerbose(false);
    }

    private void initExternalNodes() {
        this._external_nodes = new PhylogenyNodeI[this._n];
        for (int i = 0; i < this._n; ++i) {
            this._external_nodes[i] = new PhylogenyNode();
            String string = this._d.getIdentifier(i);
            if (string != null) {
                this._external_nodes[i].setName(string);
            } else {
                this._external_nodes[i].setName("" + i);
            }
            this._mappings[i] = i;
        }
    }

    private boolean isVerbose() {
        return this._verbose;
    }

    private void printProgress(int n, int n2) {
        PhylogenyNodeI phylogenyNodeI = this.getExternalPhylogenyNode(n);
        PhylogenyNodeI phylogenyNodeI2 = this.getExternalPhylogenyNode(n2);
        System.out.println("Node " + (ForesterUtil.isEmpty(phylogenyNodeI.getNodeName()) ? Integer.valueOf(phylogenyNodeI.getNodeId()) : phylogenyNodeI.getNodeName()) + " joins " + (ForesterUtil.isEmpty(phylogenyNodeI2.getNodeName()) ? Integer.valueOf(phylogenyNodeI2.getNodeId()) : phylogenyNodeI2.getNodeName()));
    }

    private void reset(DistanceMatrix distanceMatrix) {
        this._n = distanceMatrix.getSize();
        this._d = distanceMatrix;
        this._m = new BasicSymmetricalDistanceMatrix(this._n);
        this._r = new double[this._n];
        this._mappings = new int[this._n];
        this.initExternalNodes();
    }

    private void setExternalPhylogenyNode(PhylogenyNodeI phylogenyNodeI, int n) {
        this._external_nodes[this._mappings[n]] = phylogenyNodeI;
    }

    private void setValueInD(double d, int n, int n2) {
        this._d.setValue(this._mappings[n], this._mappings[n2], d);
    }

    public void setVerbose(boolean bl) {
        this._verbose = bl;
    }

    private void updateM() {
        this.calculateNetDivergences();
        for (int i = 1; i < this._n; ++i) {
            for (int j = 0; j < i; ++j) {
                this._m.setValue(j, i, this.calculateM(j, i));
            }
        }
    }

    private void updateMappings(int n) {
        for (int i = n; i < this._mappings.length - 1; ++i) {
            this._mappings[i] = this._mappings[i + 1];
        }
    }

    public static NeighborJoining createInstance() {
        return new NeighborJoining();
    }
}

