/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.util.HashMap;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.SDI;
import org.forester.util.ForesterUtil;

public class GSDI
extends SDI {
    private final HashMap<PhylogenyNode, Integer> _transversal_counts;
    private final boolean _most_parsimonious_duplication_model;
    private int _speciation_or_duplication_events_sum = 0;
    private int _speciations_sum = 0;

    public GSDI(Phylogeny phylogeny, Phylogeny phylogeny2, boolean bl) {
        super(phylogeny, phylogeny2);
        this._most_parsimonious_duplication_model = bl;
        this._transversal_counts = new HashMap();
        this._duplications_sum = 0;
        this.getSpeciesTree().preOrderReId(0);
        this.linkNodesOfG();
        this.geneTreePostOrderTraversal(this.getGeneTree().getRoot());
    }

    private Event createDuplicationEvent() {
        Event event = Event.createSingleDuplicationEvent();
        ++this._duplications_sum;
        return event;
    }

    private Event createSingleSpeciationOrDuplicationEvent() {
        Event event = Event.createSingleSpeciationOrDuplicationEvent();
        ++this._speciation_or_duplication_events_sum;
        return event;
    }

    private Event createSpeciationEvent() {
        Event event = Event.createSingleSpeciationEvent();
        ++this._speciations_sum;
        return event;
    }

    private void determineEvent(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        Event event = null;
        int n = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogenyNode2.iterateChildNodesForward();
        while (phylogenyNodeIterator.hasNext()) {
            if (phylogenyNodeIterator.next().getLink() != phylogenyNode) continue;
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        PhylogenyNode phylogenyNode3 = null;
        if (!phylogenyNode.isExternal()) {
            PhylogenyNodeIterator phylogenyNodeIterator2 = phylogenyNode.iterateChildNodesForward();
            while (phylogenyNodeIterator2.hasNext()) {
                PhylogenyNode phylogenyNode4 = phylogenyNodeIterator2.next();
                int n4 = this.getTraversalCount(phylogenyNode4);
                n2 += n4;
                if (n4 <= n3) continue;
                n3 = n4;
                phylogenyNode3 = phylogenyNode4;
            }
        }
        if (n > 0) {
            if (n2 == 2) {
                event = this.createDuplicationEvent();
            } else if (n2 > 2) {
                if (n3 <= 1) {
                    event = this._most_parsimonious_duplication_model ? this.createSpeciationEvent() : this.createSingleSpeciationOrDuplicationEvent();
                } else {
                    event = this.createDuplicationEvent();
                    this._transversal_counts.put(phylogenyNode3, 1);
                }
            } else {
                event = this.createDuplicationEvent();
            }
        } else {
            event = this.createSpeciationEvent();
        }
        phylogenyNode2.getNodeData().setEvent(event);
    }

    void geneTreePostOrderTraversal(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.isExternal()) {
            Object object;
            PhylogenyNode[] phylogenyNodeArray = phylogenyNode.iterateChildNodesForward();
            while (phylogenyNodeArray.hasNext()) {
                this.geneTreePostOrderTraversal(phylogenyNodeArray.next());
            }
            phylogenyNodeArray = new PhylogenyNode[phylogenyNode.getNumberOfDescendants()];
            for (int i = 0; i < phylogenyNodeArray.length; ++i) {
                phylogenyNodeArray[i] = phylogenyNode.getChildNode(i).getLink();
            }
            int[] nArray = GSDI.obtainMinMaxIdIndices(phylogenyNodeArray);
            Object object2 = nArray[0];
            Object object3 = nArray[1];
            while (phylogenyNodeArray[object2] != phylogenyNodeArray[object3]) {
                this.increaseTraversalCount(phylogenyNodeArray[object3]);
                phylogenyNodeArray[object3] = phylogenyNodeArray[object3].getParent();
                object = GSDI.obtainMinMaxIdIndices(phylogenyNodeArray);
                object2 = object[0];
                object3 = object[1];
            }
            object = phylogenyNodeArray[object3];
            phylogenyNode.setLink((PhylogenyNode)object);
            this.determineEvent((PhylogenyNode)object, phylogenyNode);
        }
    }

    public int getSpeciationOrDuplicationEventsSum() {
        return this._speciation_or_duplication_events_sum;
    }

    public int getSpeciationsSum() {
        return this._speciations_sum;
    }

    private int getTraversalCount(PhylogenyNode phylogenyNode) {
        if (this._transversal_counts.containsKey(phylogenyNode)) {
            return this._transversal_counts.get(phylogenyNode);
        }
        return 0;
    }

    private void increaseTraversalCount(PhylogenyNode phylogenyNode) {
        if (this._transversal_counts.containsKey(phylogenyNode)) {
            this._transversal_counts.put(phylogenyNode, this._transversal_counts.get(phylogenyNode) + 1);
        } else {
            this._transversal_counts.put(phylogenyNode, 1);
        }
    }

    void linkNodesOfG() {
        PhylogenyNode phylogenyNode;
        HashMap<Taxonomy, PhylogenyNode> hashMap = new HashMap<Taxonomy, PhylogenyNode>();
        PhylogenyNodeIterator phylogenyNodeIterator = this._species_tree.iteratorLevelOrder();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasTaxonomy()) continue;
            if (hashMap.containsKey(phylogenyNode.getNodeData().getTaxonomy())) {
                throw new IllegalArgumentException("taxonomy [" + phylogenyNode.getNodeData().getTaxonomy() + "] is not unique in species phylogeny");
            }
            hashMap.put(phylogenyNode.getNodeData().getTaxonomy(), phylogenyNode);
        }
        phylogenyNodeIterator = this._gene_tree.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                throw new IllegalArgumentException("gene tree node " + phylogenyNode + " has no taxonomic data");
            }
            PhylogenyNode phylogenyNode2 = (PhylogenyNode)hashMap.get(phylogenyNode.getNodeData().getTaxonomy());
            if (phylogenyNode2 == null) {
                throw new IllegalArgumentException("species " + phylogenyNode.getNodeData().getTaxonomy() + " not present in species tree.");
            }
            phylogenyNode.setLink(phylogenyNode2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Most parsimonious duplication model: " + this._most_parsimonious_duplication_model);
        stringBuffer.append(ForesterUtil.getLineSeparator());
        stringBuffer.append("Speciations sum                    : " + this.getSpeciationsSum());
        stringBuffer.append(ForesterUtil.getLineSeparator());
        stringBuffer.append("Duplications sum                   : " + this.getDuplicationsSum());
        stringBuffer.append(ForesterUtil.getLineSeparator());
        if (!this._most_parsimonious_duplication_model) {
            stringBuffer.append("Speciation or duplications sum     : " + this.getSpeciationOrDuplicationEventsSum());
            stringBuffer.append(ForesterUtil.getLineSeparator());
        }
        stringBuffer.append("mapping cost L                     : " + this.computeMappingCostL());
        return stringBuffer.toString();
    }

    static int[] obtainMinMaxIdIndices(PhylogenyNode[] phylogenyNodeArray) {
        int n = 0;
        int n2 = 0;
        int n3 = -2147483647;
        int n4 = Integer.MAX_VALUE;
        for (int i = 0; i < phylogenyNodeArray.length; ++i) {
            int n5 = phylogenyNodeArray[i].getNodeId();
            if (n5 > n3) {
                n = i;
                n3 = phylogenyNodeArray[n].getNodeId();
            }
            if (n5 >= n4) continue;
            n2 = i;
            n4 = phylogenyNodeArray[n2].getNodeId();
        }
        return new int[]{n2, n};
    }
}

