/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.util.ArrayList;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Event;
import org.forester.sdi.SDIR;
import org.forester.util.GeneralTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RIOn {
    private static final boolean ROOT_BY_MINIMIZING_MAPPING_COST = false;
    private static final boolean ROOT_BY_MINIMIZING_SUM_OF_DUPS = true;
    private static final boolean ROOT_BY_MINIMIZING_TREE_HEIGHT = true;
    GeneralTable<String, Integer> _orthologs = null;
    GeneralTable<String, Integer> _paralogs = null;
    GeneralTable<String, Integer> _super_orthologs = null;
    GeneralTable<String, Integer> _ultra_paralogs = null;

    private void doInferOrthologs(Phylogeny phylogeny, Phylogeny phylogeny2) {
        SDIR sDIR = new SDIR();
        Phylogeny phylogeny3 = sDIR.infer(phylogeny, phylogeny2, false, true, true, true, 1)[0];
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        Object object = phylogeny3.iteratorExternalForward();
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        object = PhylogenyMethods.getInstance();
        for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = 0; j < arrayList.size(); ++j) {
                if (i == j) continue;
                PhylogenyNode phylogenyNode = (PhylogenyNode)arrayList.get(i);
                PhylogenyNode phylogenyNode2 = (PhylogenyNode)arrayList.get(j);
                PhylogenyNode phylogenyNode3 = ((PhylogenyMethods)object).obtainLCA(phylogenyNode, phylogenyNode2);
                Event event = phylogenyNode3.getNodeData().getEvent();
                String string = phylogenyNode.getNodeData().getSequence().getName();
                String string2 = phylogenyNode2.getNodeData().getSequence().getName();
                if (event.isDuplication()) {
                    this.increaseCounter(this.getOrthologs(), string, string2);
                    continue;
                }
                this.increaseCounter(this.getParalogs(), string, string2);
            }
        }
    }

    public GeneralTable<String, Integer> getOrthologs() {
        return this._orthologs;
    }

    public GeneralTable<String, Integer> getParalogs() {
        return this._paralogs;
    }

    public GeneralTable<String, Integer> getSuperOrthologs() {
        return this._super_orthologs;
    }

    public GeneralTable<String, Integer> getUltraParalogs() {
        return this._ultra_paralogs;
    }

    private void increaseCounter(GeneralTable<String, Integer> generalTable, String string, String string2) {
        Integer n = generalTable.getValue(string, string2);
        if (n == null) {
            generalTable.setValue(string, string2, 1);
        } else {
            generalTable.setValue(string, string2, n + 1);
        }
    }

    private void init() {
        this._orthologs = new GeneralTable();
        this._paralogs = new GeneralTable();
        this._super_orthologs = new GeneralTable();
        this._ultra_paralogs = new GeneralTable();
    }

    private void setOrthologs(GeneralTable<String, Integer> generalTable) {
        this._orthologs = generalTable;
    }

    private void setParalogs(GeneralTable<String, Integer> generalTable) {
        this._paralogs = generalTable;
    }

    private void setSuperOrthologs(GeneralTable<String, Integer> generalTable) {
        this._super_orthologs = generalTable;
    }

    private void setUltraParalogs(GeneralTable<String, Integer> generalTable) {
        this._ultra_paralogs = generalTable;
    }
}

