/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.sdi.GSDI;
import org.forester.sdi.SDI;

public class TaxonomyAssigner
extends SDI {
    public TaxonomyAssigner(Phylogeny phylogeny, Phylogeny phylogeny2) {
        super(phylogeny, phylogeny2);
        this.getSpeciesTree().preOrderReId(0);
        this.linkNodesOfG();
        this.geneTreePostOrderTraversal(this.getGeneTree().getRoot());
    }

    void geneTreePostOrderTraversal(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.isExternal()) {
            Object object;
            PhylogenyNode[] phylogenyNodeArray = phylogenyNode.iterateChildNodesForward();
            while (phylogenyNodeArray.hasNext()) {
                this.geneTreePostOrderTraversal(phylogenyNodeArray.next());
            }
            phylogenyNodeArray = new PhylogenyNode[phylogenyNode.getNumberOfDescendants()];
            for (int i = 0; i < phylogenyNodeArray.length; ++i) {
                phylogenyNodeArray[i] = phylogenyNode.getChildNode(i).getLink();
            }
            int[] nArray = GSDI.obtainMinMaxIdIndices(phylogenyNodeArray);
            Object object2 = nArray[0];
            Object object3 = nArray[1];
            while (phylogenyNodeArray[object2] != phylogenyNodeArray[object3]) {
                phylogenyNodeArray[object3] = phylogenyNodeArray[object3].getParent();
                object = GSDI.obtainMinMaxIdIndices(phylogenyNodeArray);
                object2 = object[0];
                object3 = object[1];
            }
            object = phylogenyNodeArray[object3];
            phylogenyNode.setLink((PhylogenyNode)object);
            if (((PhylogenyNode)object).getNodeData().isHasTaxonomy()) {
                phylogenyNode.getNodeData().setTaxonomy((Taxonomy)((PhylogenyNode)object).getNodeData().getTaxonomy().copy());
            }
        }
    }

    public static void execute(Phylogeny phylogeny, Phylogeny phylogeny2) {
        new TaxonomyAssigner(phylogeny, phylogeny2);
    }
}

