/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.io.IOException;
import org.forester.development.DevelopmentTools;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.sdi.GSDI;

public final class TestGSDI {
    private static final Phylogeny createPhylogeny(String string) throws IOException {
        Phylogeny phylogeny = ParserBasedPhylogenyFactory.getInstance().create(string, new NHXParser())[0];
        phylogeny.setRooted(true);
        return phylogeny;
    }

    private static final Event getEvent(Phylogeny phylogeny, String string, String string2) {
        return PhylogenyMethods.getInstance().obtainLCA(phylogeny.getNode(string), phylogeny.getNode(string2)).getNodeData().getEvent();
    }

    public static boolean test() {
        if (!TestGSDI.testGSDI_general()) {
            return false;
        }
        return TestGSDI.testGSDI_against_binary_gene_tree();
    }

    private static boolean testGSDI_against_binary_gene_tree() {
        try {
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny = phylogenyFactory.create("(((((([&&NHX:S=1],[&&NHX:S=2]),([&&NHX:S=3],[&&NHX:S=4],[&&NHX:S=5])),([&&NHX:S=6],[&&NHX:S=7],[&&NHX:S=8],[&&NHX:S=9])),([&&NHX:S=10],[&&NHX:S=11])),([&&NHX:S=12],[&&NHX:S=13],[&&NHX:S=14])),([&&NHX:S=15],([&&NHX:S=16],[&&NHX:S=17]),([&&NHX:S=18],[&&NHX:S=19],[&&NHX:S=20]),([&&NHX:S=21],[&&NHX:S=22],[&&NHX:S=23],[&&NHX:S=24])));", new NHXParser())[0];
            Phylogeny phylogeny2 = phylogenyFactory.create("(((((([&&NHX:S=1],[&&NHX:S=2])1_2,([&&NHX:S=3],[&&NHX:S=4])),([&&NHX:S=6],[&&NHX:S=7])6_7_8_9)1_9,([&&NHX:S=10],[&&NHX:S=11])),([&&NHX:S=12],[&&NHX:S=13])12_13_14)1_14,([&&NHX:S=15],([&&NHX:S=21],[&&NHX:S=24])21_22_23_24)15_24);", new NHXParser())[0];
            phylogeny.setRooted(true);
            phylogeny2.setRooted(true);
            GSDI gSDI = new GSDI(phylogeny2, phylogeny, false);
            if (gSDI.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI.getDuplicationsSum() != 0) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testGSDI_general() {
        try {
            PhylogenyMethods phylogenyMethods = PhylogenyMethods.getInstance();
            Phylogeny phylogeny = ParserBasedPhylogenyFactory.getInstance().create("((([&&NHX:S=A2],[&&NHX:S=A1]),[&&NHX:S=B],[&&NHX:S=C]),[&&NHX:S=D])", new NHXParser())[0];
            phylogeny.setRooted(true);
            Phylogeny phylogeny2 = TestGSDI.createPhylogeny("((((B[&&NHX:S=B],A1[&&NHX:S=A1]),C[&&NHX:S=C]),A2[&&NHX:S=A2]),D[&&NHX:S=D])");
            GSDI gSDI = new GSDI(phylogeny2, phylogeny, false);
            if (gSDI.getDuplicationsSum() != 1) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny2.getNode("B"), phylogeny2.getNode("A1")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny2.getNode("C"), phylogeny2.getNode("A1")).getNodeData().getEvent().isSpeciationOrDuplication()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny2.getNode("A2"), phylogeny2.getNode("A1")).getNodeData().getEvent().isDuplication()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny2.getNode("D"), phylogeny2.getNode("A1")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            Phylogeny phylogeny3 = TestGSDI.createPhylogeny("((((A2[&&NHX:S=A2],A1[&&NHX:S=A1]),B[&&NHX:S=B]),C[&&NHX:S=C]),D[&&NHX:S=D])");
            GSDI gSDI2 = new GSDI(phylogeny3, phylogeny, false);
            if (gSDI2.getDuplicationsSum() != 0) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny3.getNode("A1"), phylogeny3.getNode("A2")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny3.getNode("A1"), phylogeny3.getNode("B")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny3.getNode("A1"), phylogeny3.getNode("C")).getNodeData().getEvent().isSpeciationOrDuplication()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny3.getNode("A1"), phylogeny3.getNode("D")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            Phylogeny phylogeny4 = TestGSDI.createPhylogeny("((((A2[&&NHX:S=A2],A1[&&NHX:S=A1]),C[&&NHX:S=C]),B[&&NHX:S=B]),D[&&NHX:S=D])");
            GSDI gSDI3 = new GSDI(phylogeny4, phylogeny, false);
            if (gSDI3.getDuplicationsSum() != 0) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny4.getNode("A1"), phylogeny4.getNode("A2")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny4.getNode("A1"), phylogeny4.getNode("C")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny4.getNode("A1"), phylogeny4.getNode("B")).getNodeData().getEvent().isSpeciationOrDuplication()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny4.getNode("A1"), phylogeny4.getNode("D")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            Phylogeny phylogeny5 = TestGSDI.createPhylogeny("(((B[&&NHX:S=B],C1[&&NHX:S=C]),C2[&&NHX:S=C]),D[&&NHX:S=D])");
            GSDI gSDI4 = new GSDI(phylogeny5, phylogeny, false);
            if (gSDI4.getDuplicationsSum() != 1) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny5.getNode("B"), phylogeny5.getNode("C1")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny5.getNode("B"), phylogeny5.getNode("C2")).getNodeData().getEvent().isDuplication()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny5.getNode("B"), phylogeny5.getNode("D")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            Phylogeny phylogeny6 = TestGSDI.createPhylogeny("(((D1[&&NHX:S=D],A1[&&NHX:S=A1]),B[&&NHX:S=B]),((D2[&&NHX:S=D],D3[&&NHX:S=D]),C[&&NHX:S=C]))");
            GSDI gSDI5 = new GSDI(phylogeny6, phylogeny, false);
            if (gSDI5.getDuplicationsSum() != 3) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny6.getNode("D1"), phylogeny6.getNode("A1")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny6.getNode("D1"), phylogeny6.getNode("B")).getNodeData().getEvent().isDuplication()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny6.getNode("D1"), phylogeny6.getNode("D2")).getNodeData().getEvent().isDuplication()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny6.getNode("D2"), phylogeny6.getNode("D3")).getNodeData().getEvent().isDuplication()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny6.getNode("C"), phylogeny6.getNode("D3")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            Phylogeny phylogeny7 = TestGSDI.createPhylogeny("(((((((([&&NHX:S=a1],[&&NHX:S=a2]),([&&NHX:S=b1],[&&NHX:S=b2])),[&&NHX:S=x]),(([&&NHX:S=m1],[&&NHX:S=m2]),([&&NHX:S=n1],[&&NHX:S=n2]))),(([&&NHX:S=i1],[&&NHX:S=i2]),([&&NHX:S=j1],[&&NHX:S=j2]))),(([&&NHX:S=e1],[&&NHX:S=e2]),([&&NHX:S=f1],[&&NHX:S=f2]))),[&&NHX:S=y]),[&&NHX:S=z])");
            Phylogeny phylogeny8 = TestGSDI.createPhylogeny("(((((((((a1[&&NHX:S=a1],a2[&&NHX:S=a2]),b1[&&NHX:S=b1]),x[&&NHX:S=x]),m1[&&NHX:S=m1]),i1[&&NHX:S=i1]),j2[&&NHX:S=j2]),e1[&&NHX:S=e1]),y[&&NHX:S=y]),z[&&NHX:S=z])");
            phylogeny8.setRooted(true);
            GSDI gSDI6 = new GSDI(phylogeny8, phylogeny7, false);
            if (gSDI6.getDuplicationsSum() != 1) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny8, "a1", "a2").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny8, "a1", "b1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny8, "a1", "x").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny8, "a1", "m1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny8, "a1", "i1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny8, "a1", "j2").isDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny8, "a1", "e1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny8, "a1", "y").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny8, "a1", "z").isSpeciation()) {
                return false;
            }
            Phylogeny phylogeny9 = ParserBasedPhylogenyFactory.getInstance().create("((([&&NHX:S=a1],[&&NHX:S=a2],[&&NHX:S=a3],[&&NHX:S=a4]),([&&NHX:S=b1],[&&NHX:S=b2],[&&NHX:S=b3],[&&NHX:S=b4]),([&&NHX:S=c1],[&&NHX:S=c2],[&&NHX:S=c3],[&&NHX:S=c4]),([&&NHX:S=d1],[&&NHX:S=d2],[&&NHX:S=d3],[&&NHX:S=d4])),(([&&NHX:S=e1],[&&NHX:S=e2],[&&NHX:S=e3],[&&NHX:S=e4]),([&&NHX:S=f1],[&&NHX:S=f2],[&&NHX:S=f3],[&&NHX:S=f4]),([&&NHX:S=g1],[&&NHX:S=g2],[&&NHX:S=g3],[&&NHX:S=g4]),([&&NHX:S=h1],[&&NHX:S=h2],[&&NHX:S=h3],[&&NHX:S=h4])),(([&&NHX:S=i1],[&&NHX:S=i2],[&&NHX:S=i3],[&&NHX:S=i4]),([&&NHX:S=j1],[&&NHX:S=j2],[&&NHX:S=j3],[&&NHX:S=j4]),([&&NHX:S=k1],[&&NHX:S=k2],[&&NHX:S=k3],[&&NHX:S=k4]),([&&NHX:S=l1],[&&NHX:S=l2],[&&NHX:S=l3],[&&NHX:S=l4])),(([&&NHX:S=m1],[&&NHX:S=m2],[&&NHX:S=m3],[&&NHX:S=m4]),([&&NHX:S=n1],[&&NHX:S=n2],[&&NHX:S=n3],[&&NHX:S=n4]),([&&NHX:S=o1],[&&NHX:S=o2],[&&NHX:S=o3],[&&NHX:S=o4]),([&&NHX:S=p1],[&&NHX:S=p2],[&&NHX:S=p3],[&&NHX:S=p4])),[&&NHX:S=x],[&&NHX:S=y],[&&NHX:S=z])", new NHXParser())[0];
            phylogeny9.setRooted(true);
            Phylogeny phylogeny10 = TestGSDI.createPhylogeny("(m1[&&NHX:S=m1],m3[&&NHX:S=m3])");
            GSDI gSDI7 = new GSDI(phylogeny10, phylogeny9, false);
            if (gSDI7.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI7.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI7.getSpeciationsSum() != 1) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny10.getNode("m1"), phylogeny10.getNode("m3")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            Phylogeny phylogeny11 = TestGSDI.createPhylogeny("(e2[&&NHX:S=e2],h2[&&NHX:S=h2])");
            GSDI gSDI8 = new GSDI(phylogeny11, phylogeny9, false);
            if (gSDI8.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI8.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI8.getSpeciationsSum() != 1) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny11.getNode("e2"), phylogeny11.getNode("h2")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            Phylogeny phylogeny12 = TestGSDI.createPhylogeny("(e2[&&NHX:S=e2],p4[&&NHX:S=p4])");
            GSDI gSDI9 = new GSDI(phylogeny12, phylogeny9, false);
            if (gSDI9.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI9.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI9.getSpeciationsSum() != 1) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny12.getNode("e2"), phylogeny12.getNode("p4")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            Phylogeny phylogeny13 = TestGSDI.createPhylogeny("(e2a[&&NHX:S=e2],e2b[&&NHX:S=e2])");
            GSDI gSDI10 = new GSDI(phylogeny13, phylogeny9, false);
            if (gSDI10.getDuplicationsSum() != 1) {
                return false;
            }
            if (gSDI10.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI10.getSpeciationsSum() != 0) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny13.getNode("e2a"), phylogeny13.getNode("e2b")).getNodeData().getEvent().isDuplication()) {
                return false;
            }
            Phylogeny phylogeny14 = TestGSDI.createPhylogeny("((j1[&&NHX:S=j1],j4[&&NHX:S=j4]),i3[&&NHX:S=i3])");
            GSDI gSDI11 = new GSDI(phylogeny14, phylogeny9, false);
            if (gSDI11.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI11.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI11.getSpeciationsSum() != 2) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny14.getNode("j1"), phylogeny14.getNode("j4")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny14.getNode("j1"), phylogeny14.getNode("i3")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            Phylogeny phylogeny15 = TestGSDI.createPhylogeny("((j1[&&NHX:S=j1],j4[&&NHX:S=j4]),f3[&&NHX:S=f3])");
            GSDI gSDI12 = new GSDI(phylogeny15, phylogeny9, false);
            if (gSDI12.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI12.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI12.getSpeciationsSum() != 2) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny15.getNode("j1"), phylogeny15.getNode("j4")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny15.getNode("j1"), phylogeny15.getNode("f3")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            Phylogeny phylogeny16 = TestGSDI.createPhylogeny("((j3[&&NHX:S=j3],i4[&&NHX:S=i4]),f3[&&NHX:S=f3])");
            GSDI gSDI13 = new GSDI(phylogeny16, phylogeny9, false);
            if (gSDI13.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI13.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI13.getSpeciationsSum() != 2) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny16.getNode("j3"), phylogeny16.getNode("i4")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny16.getNode("j3"), phylogeny16.getNode("f3")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            Phylogeny phylogeny17 = TestGSDI.createPhylogeny("((j1[&&NHX:S=j1],k1[&&NHX:S=k1]),i1[&&NHX:S=i1])");
            GSDI gSDI14 = new GSDI(phylogeny17, phylogeny9, false);
            if (gSDI14.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI14.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI14.getSpeciationsSum() != 1) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny17.getNode("j1"), phylogeny17.getNode("k1")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny17.getNode("j1"), phylogeny17.getNode("i1")).getNodeData().getEvent().isSpeciationOrDuplication()) {
                return false;
            }
            Phylogeny phylogeny18 = TestGSDI.createPhylogeny("(j1[&&NHX:S=j1],(k1[&&NHX:S=k1],i1[&&NHX:S=i1]))");
            GSDI gSDI15 = new GSDI(phylogeny18, phylogeny9, false);
            if (gSDI15.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI15.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI15.getSpeciationsSum() != 1) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny18.getNode("j1"), phylogeny18.getNode("k1")).getNodeData().getEvent().isSpeciationOrDuplication()) {
                return false;
            }
            if (!phylogenyMethods.obtainLCA(phylogeny18.getNode("k1"), phylogeny18.getNode("i1")).getNodeData().getEvent().isSpeciation()) {
                return false;
            }
            Phylogeny phylogeny19 = TestGSDI.createPhylogeny("((j1[&&NHX:S=j1],k4[&&NHX:S=k4]),f2[&&NHX:S=f2])");
            GSDI gSDI16 = new GSDI(phylogeny19, phylogeny9, false);
            if (gSDI16.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI16.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI16.getSpeciationsSum() != 2) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny19, "j1", "k4").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny19, "j1", "f2").isSpeciation()) {
                return false;
            }
            Phylogeny phylogeny20 = TestGSDI.createPhylogeny("((m1[&&NHX:S=m1],k4[&&NHX:S=k4]),f2[&&NHX:S=f2])");
            GSDI gSDI17 = new GSDI(phylogeny20, phylogeny9, false);
            if (gSDI17.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI17.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI17.getSpeciationsSum() != 1) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny20, "m1", "k4").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny20, "m1", "f2").isSpeciationOrDuplication()) {
                return false;
            }
            Phylogeny phylogeny21 = TestGSDI.createPhylogeny("((m1[&&NHX:S=m1],k4[&&NHX:S=k4]),x[&&NHX:S=x])");
            GSDI gSDI18 = new GSDI(phylogeny21, phylogeny9, false);
            if (gSDI18.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI18.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI18.getSpeciationsSum() != 1) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny21, "m1", "k4").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny21, "m1", "x").isSpeciationOrDuplication()) {
                return false;
            }
            Phylogeny phylogeny22 = TestGSDI.createPhylogeny("(m1[&&NHX:S=m1],(k4[&&NHX:S=k4],x[&&NHX:S=x]))");
            GSDI gSDI19 = new GSDI(phylogeny22, phylogeny9, false);
            if (gSDI19.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI19.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI19.getSpeciationsSum() != 1) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny22, "x", "k4").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny22, "m1", "x").isSpeciationOrDuplication()) {
                return false;
            }
            Phylogeny phylogeny23 = TestGSDI.createPhylogeny("(x[&&NHX:S=x],(y[&&NHX:S=y],z[&&NHX:S=z]))");
            GSDI gSDI20 = new GSDI(phylogeny23, phylogeny9, false);
            if (gSDI20.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI20.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI20.getSpeciationsSum() != 1) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny23, "y", "z").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny23, "x", "z").isSpeciationOrDuplication()) {
                return false;
            }
            Phylogeny phylogeny24 = TestGSDI.createPhylogeny("(a1_1[&&NHX:S=a1],(b1[&&NHX:S=b1],a1[&&NHX:S=a1]))");
            GSDI gSDI21 = new GSDI(phylogeny24, phylogeny9, false);
            if (gSDI21.getDuplicationsSum() != 1) {
                return false;
            }
            if (gSDI21.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI21.getSpeciationsSum() != 1) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny24, "b1", "a1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny24, "b1", "a1_1").isDuplication()) {
                return false;
            }
            Phylogeny phylogeny25 = TestGSDI.createPhylogeny("(a2[&&NHX:S=a2],(b1[&&NHX:S=b1],a1[&&NHX:S=a1]))");
            GSDI gSDI22 = new GSDI(phylogeny25, phylogeny9, false);
            if (gSDI22.getDuplicationsSum() != 1) {
                return false;
            }
            if (gSDI22.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI22.getSpeciationsSum() != 1) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny25, "b1", "a1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny25, "b1", "a2").isDuplication()) {
                return false;
            }
            Phylogeny phylogeny26 = TestGSDI.createPhylogeny("(n2[&&NHX:S=n2],(j3[&&NHX:S=j3],n1[&&NHX:S=n1]))");
            GSDI gSDI23 = new GSDI(phylogeny26, phylogeny9, false);
            if (gSDI23.getDuplicationsSum() != 1) {
                return false;
            }
            if (gSDI23.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI23.getSpeciationsSum() != 1) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny26, "j3", "n1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny26, "j3", "n2").isDuplication()) {
                return false;
            }
            Phylogeny phylogeny27 = TestGSDI.createPhylogeny("(p4[&&NHX:S=p4],(j3[&&NHX:S=j3],n1[&&NHX:S=n1]))");
            GSDI gSDI24 = new GSDI(phylogeny27, phylogeny9, false);
            if (gSDI24.getDuplicationsSum() != 1) {
                return false;
            }
            if (gSDI24.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI24.getSpeciationsSum() != 1) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny27, "j3", "n1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny27, "j3", "p4").isDuplication()) {
                return false;
            }
            Phylogeny phylogeny28 = TestGSDI.createPhylogeny("((n11[&&NHX:S=n1],n12[&&NHX:S=n1]),(n13[&&NHX:S=n1],n14[&&NHX:S=n1]))");
            GSDI gSDI25 = new GSDI(phylogeny28, phylogeny9, false);
            if (gSDI25.getDuplicationsSum() != 3) {
                return false;
            }
            if (gSDI25.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI25.getSpeciationsSum() != 0) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny28, "n11", "n12").isDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny28, "n13", "n14").isDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny28, "n11", "n13").isDuplication()) {
                return false;
            }
            Phylogeny phylogeny29 = TestGSDI.createPhylogeny("((n11[&&NHX:S=n1],n21[&&NHX:S=n2]),(n12[&&NHX:S=n1],n22[&&NHX:S=n2]))");
            GSDI gSDI26 = new GSDI(phylogeny29, phylogeny9, false);
            if (gSDI26.getDuplicationsSum() != 1) {
                return false;
            }
            if (gSDI26.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI26.getSpeciationsSum() != 2) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny29, "n11", "n21").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny29, "n12", "n22").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny29, "n11", "n12").isDuplication()) {
                return false;
            }
            Phylogeny phylogeny30 = TestGSDI.createPhylogeny("((n11[&&NHX:S=n1],n2[&&NHX:S=n2]),(n12[&&NHX:S=n1],n3[&&NHX:S=n3]))");
            GSDI gSDI27 = new GSDI(phylogeny30, phylogeny9, false);
            if (gSDI27.getDuplicationsSum() != 1) {
                return false;
            }
            if (gSDI27.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI27.getSpeciationsSum() != 2) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny30, "n11", "n2").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny30, "n12", "n3").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny30, "n11", "n12").isDuplication()) {
                return false;
            }
            Phylogeny phylogeny31 = TestGSDI.createPhylogeny("((n1[&&NHX:S=n1],n2[&&NHX:S=n2]),(n3[&&NHX:S=n3],a1[&&NHX:S=a1]))");
            GSDI gSDI28 = new GSDI(phylogeny31, phylogeny9, false);
            if (gSDI28.getDuplicationsSum() != 1) {
                return false;
            }
            if (gSDI28.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI28.getSpeciationsSum() != 2) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny31, "n1", "n2").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny31, "n3", "a1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny31, "n2", "a1").isDuplication()) {
                return false;
            }
            Phylogeny phylogeny32 = TestGSDI.createPhylogeny("((n1[&&NHX:S=n1],n2[&&NHX:S=n2]),(n3[&&NHX:S=n3],n4[&&NHX:S=n4]))");
            GSDI gSDI29 = new GSDI(phylogeny32, phylogeny9, false);
            if (gSDI29.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI29.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI29.getSpeciationsSum() != 2) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny32, "n1", "n2").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny32, "n3", "n4").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny32, "n1", "n3").isSpeciationOrDuplication()) {
                return false;
            }
            Phylogeny phylogeny33 = TestGSDI.createPhylogeny("((a1[&&NHX:S=a1],b1[&&NHX:S=b1]),(c1[&&NHX:S=c1],d1[&&NHX:S=d1]))");
            GSDI gSDI30 = new GSDI(phylogeny33, phylogeny9, false);
            if (gSDI30.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI30.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI30.getSpeciationsSum() != 2) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny33, "a1", "b1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny33, "c1", "d1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny33, "a1", "c1").isSpeciationOrDuplication()) {
                return false;
            }
            Phylogeny phylogeny34 = TestGSDI.createPhylogeny("((a1[&&NHX:S=a1],e1[&&NHX:S=e1]),(i1[&&NHX:S=i1],m1[&&NHX:S=m1]))");
            GSDI gSDI31 = new GSDI(phylogeny34, phylogeny9, false);
            if (gSDI31.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI31.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI31.getSpeciationsSum() != 2) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny34, "a1", "e1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny34, "i1", "m1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny34, "a1", "i1").isSpeciationOrDuplication()) {
                return false;
            }
            Phylogeny phylogeny35 = TestGSDI.createPhylogeny("((a1[&&NHX:S=a1],a4[&&NHX:S=a4]),(b1[&&NHX:S=b1],c1[&&NHX:S=c1]))");
            GSDI gSDI32 = new GSDI(phylogeny35, phylogeny9, false);
            if (gSDI32.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI32.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI32.getSpeciationsSum() != 2) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny35, "a1", "a4").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny35, "b1", "c1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny35, "a1", "b1").isSpeciationOrDuplication()) {
                return false;
            }
            Phylogeny phylogeny36 = TestGSDI.createPhylogeny("(((a1[&&NHX:S=a1],a4[&&NHX:S=a4]),b1[&&NHX:S=b1]),e1[&&NHX:S=e1])");
            GSDI gSDI33 = new GSDI(phylogeny36, phylogeny9, false);
            if (gSDI33.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI33.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI33.getSpeciationsSum() != 3) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny36, "a1", "a4").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny36, "a1", "b1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny36, "a1", "e1").isSpeciation()) {
                return false;
            }
            Phylogeny phylogeny37 = TestGSDI.createPhylogeny("(((a1[&&NHX:S=a1],a4[&&NHX:S=a4]),b1[&&NHX:S=b1]),c1[&&NHX:S=c1])");
            GSDI gSDI34 = new GSDI(phylogeny37, phylogeny9, false);
            if (gSDI34.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI34.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI34.getSpeciationsSum() != 2) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny37, "a1", "a4").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny37, "a1", "b1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny37, "a1", "c1").isSpeciationOrDuplication()) {
                return false;
            }
            Phylogeny phylogeny38 = TestGSDI.createPhylogeny("(((a1[&&NHX:S=a1],b1[&&NHX:S=b1]),c1[&&NHX:S=c1]),e1[&&NHX:S=e1])");
            GSDI gSDI35 = new GSDI(phylogeny38, phylogeny9, false);
            if (gSDI35.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI35.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI35.getSpeciationsSum() != 2) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny38, "a1", "b1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny38, "a1", "c1").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny38, "a1", "e1").isSpeciation()) {
                return false;
            }
            Phylogeny phylogeny39 = TestGSDI.createPhylogeny("(((a1[&&NHX:S=a1],b1[&&NHX:S=b1]),c1[&&NHX:S=c1]),d1[&&NHX:S=d1])");
            GSDI gSDI36 = new GSDI(phylogeny39, phylogeny9, false);
            if (gSDI36.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI36.getSpeciationOrDuplicationEventsSum() != 2) {
                return false;
            }
            if (gSDI36.getSpeciationsSum() != 1) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny39, "a1", "b1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny39, "a1", "c1").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny39, "a1", "d1").isSpeciationOrDuplication()) {
                return false;
            }
            Phylogeny phylogeny40 = TestGSDI.createPhylogeny("(((a1[&&NHX:S=a1],b1[&&NHX:S=b1]),c1[&&NHX:S=c1]),a2[&&NHX:S=a2])");
            GSDI gSDI37 = new GSDI(phylogeny40, phylogeny9, false);
            if (gSDI37.getDuplicationsSum() != 1) {
                return false;
            }
            if (gSDI37.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI37.getSpeciationsSum() != 1) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny40, "a1", "b1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny40, "a1", "c1").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny40, "a1", "a2").isDuplication()) {
                return false;
            }
            Phylogeny phylogeny41 = TestGSDI.createPhylogeny("(((a1[&&NHX:S=a1],b1[&&NHX:S=b1]),c1[&&NHX:S=c1]),c2[&&NHX:S=c2])");
            GSDI gSDI38 = new GSDI(phylogeny41, phylogeny9, false);
            if (gSDI38.getDuplicationsSum() != 1) {
                return false;
            }
            if (gSDI38.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI38.getSpeciationsSum() != 1) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny41, "a1", "b1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny41, "a1", "c1").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny41, "a1", "c2").isDuplication()) {
                return false;
            }
            Phylogeny phylogeny42 = TestGSDI.createPhylogeny("((((((((((a1[&&NHX:S=a1],a2[&&NHX:S=a2]),b1[&&NHX:S=b1]),c1[&&NHX:S=c1]),d1[&&NHX:S=d1]),x[&&NHX:S=x]),p1[&&NHX:S=p1]),i1[&&NHX:S=i1]),e1[&&NHX:S=e1]),y[&&NHX:S=y]),z[&&NHX:S=z])");
            GSDI gSDI39 = new GSDI(phylogeny42, phylogeny9, false);
            if (gSDI39.getDuplicationsSum() != 0) {
                return false;
            }
            if (gSDI39.getSpeciationOrDuplicationEventsSum() != 7) {
                return false;
            }
            if (gSDI39.getSpeciationsSum() != 3) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny42, "a1", "a2").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny42, "a1", "b1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny42, "a1", "c1").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny42, "a1", "d1").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny42, "a1", "x").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny42, "a1", "p1").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny42, "a1", "i1").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny42, "a1", "e1").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny42, "a1", "y").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny42, "a1", "z").isSpeciationOrDuplication()) {
                return false;
            }
            Phylogeny phylogeny43 = TestGSDI.createPhylogeny("(((((((((((a1[&&NHX:S=a1],a2[&&NHX:S=a2]),b1[&&NHX:S=b1]),c1[&&NHX:S=c1]),d1[&&NHX:S=d1]),x[&&NHX:S=x]),p1[&&NHX:S=p1]),i1[&&NHX:S=i1]),k2[&&NHX:S=k2]),e1[&&NHX:S=e1]),y[&&NHX:S=y]),z[&&NHX:S=z])");
            GSDI gSDI40 = new GSDI(phylogeny43, phylogeny9, false);
            if (gSDI40.getDuplicationsSum() != 1) {
                return false;
            }
            if (gSDI40.getSpeciationOrDuplicationEventsSum() != 7) {
                return false;
            }
            if (gSDI40.getSpeciationsSum() != 3) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny43, "a1", "a2").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny43, "a1", "b1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny43, "a1", "c1").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny43, "a1", "d1").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny43, "a1", "x").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny43, "a1", "p1").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny43, "a1", "i1").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny43, "a1", "k2").isDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny43, "a1", "e1").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny43, "a1", "y").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny43, "a1", "z").isSpeciationOrDuplication()) {
                return false;
            }
            Phylogeny phylogeny44 = TestGSDI.createPhylogeny("(((n1_0[&&NHX:S=n1],n2_0[&&NHX:S=n2]),(n1_1[&&NHX:S=n1],n3_0[&&NHX:S=n3])),n4_0[&&NHX:S=n4])");
            GSDI gSDI41 = new GSDI(phylogeny44, phylogeny9, false);
            if (gSDI41.getDuplicationsSum() != 1) {
                return false;
            }
            if (gSDI41.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI41.getSpeciationsSum() != 2) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny44, "n1_0", "n2_0").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny44, "n1_1", "n3_0").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny44, "n1_0", "n1_1").isDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny44, "n1_0", "n4_0").isSpeciationOrDuplication()) {
                return false;
            }
            Phylogeny phylogeny45 = TestGSDI.createPhylogeny("((((n1_0[&&NHX:S=n1],n2_0[&&NHX:S=n2]),(n1_1[&&NHX:S=n1],n3_0[&&NHX:S=n3])),n4_0[&&NHX:S=n4]),a1_0[&&NHX:S=a1])");
            GSDI gSDI42 = new GSDI(phylogeny45, phylogeny9, false);
            if (gSDI42.getDuplicationsSum() != 1) {
                return false;
            }
            if (gSDI42.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI42.getSpeciationsSum() != 3) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny45, "n1_0", "n2_0").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny45, "n1_1", "n3_0").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny45, "n1_0", "n1_1").isDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny45, "n1_0", "n4_0").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny45, "n1_0", "a1_0").isSpeciation()) {
                return false;
            }
            Phylogeny phylogeny46 = TestGSDI.createPhylogeny("(((a1_0[&&NHX:S=a1],b1_0[&&NHX:S=b1]),(a1_1[&&NHX:S=a1],c1_0[&&NHX:S=c1])),d1_0[&&NHX:S=d1])");
            GSDI gSDI43 = new GSDI(phylogeny46, phylogeny9, false);
            if (gSDI43.getDuplicationsSum() != 1) {
                return false;
            }
            if (gSDI43.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI43.getSpeciationsSum() != 2) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny46, "a1_0", "b1_0").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny46, "a1_1", "c1_0").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny46, "a1_0", "c1_0").isDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny46, "a1_0", "d1_0").isSpeciationOrDuplication()) {
                return false;
            }
            Phylogeny phylogeny47 = TestGSDI.createPhylogeny("(((a1_0[&&NHX:S=a1],b1_0[&&NHX:S=b1]),(a2_0[&&NHX:S=a2],c1_0[&&NHX:S=c1])),d1_0[&&NHX:S=d1])");
            GSDI gSDI44 = new GSDI(phylogeny47, phylogeny9, false);
            if (gSDI44.getDuplicationsSum() != 1) {
                return false;
            }
            if (gSDI44.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI44.getSpeciationsSum() != 2) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny47, "a1_0", "b1_0").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny47, "a2_0", "c1_0").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny47, "a1_0", "c1_0").isDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny47, "a1_0", "d1_0").isSpeciationOrDuplication()) {
                return false;
            }
            Phylogeny phylogeny48 = TestGSDI.createPhylogeny("(((([&&NHX:S=n1],[&&NHX:S=n1]),([&&NHX:S=n1],[&&NHX:S=n1])),[&&NHX:S=n1]),[&&NHX:S=n1])");
            GSDI gSDI45 = new GSDI(phylogeny48, phylogeny9, false);
            if (gSDI45.getDuplicationsSum() != 5) {
                return false;
            }
            if (gSDI45.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI45.getSpeciationsSum() != 0) {
                return false;
            }
            Phylogeny phylogeny49 = TestGSDI.createPhylogeny("(((e1[&&NHX:S=e1],f2[&&NHX:S=f2]),(d3[&&NHX:S=d3],g4[&&NHX:S=g4])),(((a1[&&NHX:S=a1],h2[&&NHX:S=h2]),c3[&&NHX:S=c3]),(i4[&&NHX:S=i4],b1[&&NHX:S=b1])))");
            GSDI gSDI46 = new GSDI(phylogeny49, phylogeny9, false);
            if (gSDI46.getDuplicationsSum() != 4) {
                return false;
            }
            if (gSDI46.getSpeciationOrDuplicationEventsSum() != 0) {
                return false;
            }
            if (gSDI46.getSpeciationsSum() != 4) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny49, "e1", "f2").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny49, "d3", "g4").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny49, "e1", "d3").isDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny49, "a1", "h2").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny49, "a1", "c3").isDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny49, "i4", "b1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny49, "a1", "i4").isDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny49, "e1", "a1").isDuplication()) {
                return false;
            }
            Phylogeny phylogeny50 = TestGSDI.createPhylogeny("(((e1[&&NHX:S=e1],f2[&&NHX:S=f2]),(d3[&&NHX:S=d3],g4[&&NHX:S=g4])),(((a1[&&NHX:S=a1],b2[&&NHX:S=b2]),c3[&&NHX:S=c3]),(i4[&&NHX:S=i4],j1[&&NHX:S=j1])))");
            GSDI gSDI47 = new GSDI(phylogeny50, phylogeny9, false);
            if (gSDI47.getDuplicationsSum() != 2) {
                return false;
            }
            if (gSDI47.getSpeciationOrDuplicationEventsSum() != 1) {
                return false;
            }
            if (gSDI47.getSpeciationsSum() != 5) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny50, "e1", "f2").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny50, "d3", "g4").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny50, "e1", "d3").isDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny50, "a1", "b2").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny50, "a1", "c3").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny50, "i4", "j1").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny50, "a1", "i4").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny50, "e1", "a1").isDuplication()) {
                return false;
            }
            Phylogeny phylogeny51 = DevelopmentTools.createBalancedPhylogeny(7, 4);
            DevelopmentTools.numberSpeciesInOrder(phylogeny51);
            Phylogeny phylogeny52 = TestGSDI.createPhylogeny("((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1[&&NHX:S=1],2[&&NHX:S=2]),3[&&NHX:S=3]),4[&&NHX:S=4]),5[&&NHX:S=5]),6[&&NHX:S=6]),7[&&NHX:S=7]),8[&&NHX:S=8]),9[&&NHX:S=9]),10[&&NHX:S=10]),11[&&NHX:S=11]),12[&&NHX:S=12]),13[&&NHX:S=13]),14[&&NHX:S=14]),15[&&NHX:S=15]),16[&&NHX:S=16]),17[&&NHX:S=17]),18[&&NHX:S=18]),19[&&NHX:S=19]),20[&&NHX:S=20]),21[&&NHX:S=21]),22[&&NHX:S=22]),23[&&NHX:S=23]),24[&&NHX:S=24]),25[&&NHX:S=25]),26[&&NHX:S=26]),27[&&NHX:S=27]),28[&&NHX:S=28]),29[&&NHX:S=29]),30[&&NHX:S=30]),31[&&NHX:S=31]),32[&&NHX:S=32]),33[&&NHX:S=33]),34[&&NHX:S=34]),35[&&NHX:S=35]),36[&&NHX:S=36]),37[&&NHX:S=37]),38[&&NHX:S=38]),39[&&NHX:S=39]),40[&&NHX:S=40]),41[&&NHX:S=41]),42[&&NHX:S=42]),43[&&NHX:S=43]),44[&&NHX:S=44]),45[&&NHX:S=45]),46[&&NHX:S=46]),47[&&NHX:S=47]),48[&&NHX:S=48]),49[&&NHX:S=49]),50[&&NHX:S=50]),51[&&NHX:S=51]),52[&&NHX:S=52]),53[&&NHX:S=53]),54[&&NHX:S=54]),55[&&NHX:S=55]),56[&&NHX:S=56]),57[&&NHX:S=57]),58[&&NHX:S=58]),59[&&NHX:S=59]),60[&&NHX:S=60]),61[&&NHX:S=61]),62[&&NHX:S=62]),63[&&NHX:S=63]),64[&&NHX:S=64]),65[&&NHX:S=65])");
            GSDI gSDI48 = new GSDI(phylogeny52, phylogeny51, false);
            if (gSDI48.getDuplicationsSum() != 54) {
                return false;
            }
            if (gSDI48.getSpeciationOrDuplicationEventsSum() != 6) {
                return false;
            }
            if (gSDI48.getSpeciationsSum() != 4) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny52, "1", "2").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny52, "1", "3").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny52, "1", "4").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny52, "1", "5").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny52, "1", "6").isDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny52, "1", "9").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny52, "1", "13").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny52, "1", "17").isSpeciation()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny52, "1", "33").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny52, "1", "49").isSpeciationOrDuplication()) {
                return false;
            }
            if (!TestGSDI.getEvent(phylogeny52, "1", "65").isSpeciation()) {
                return false;
            }
            Phylogeny phylogeny53 = TestGSDI.createPhylogeny("(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((1[&&NHX:S=1],2[&&NHX:S=2]),3[&&NHX:S=3]),4[&&NHX:S=4]),5[&&NHX:S=5]),6[&&NHX:S=6]),7[&&NHX:S=7]),8[&&NHX:S=8]),9[&&NHX:S=9]),10[&&NHX:S=10]),11[&&NHX:S=11]),12[&&NHX:S=12]),13[&&NHX:S=13]),14[&&NHX:S=14]),15[&&NHX:S=15]),16[&&NHX:S=16]),17[&&NHX:S=17]),18[&&NHX:S=18]),19[&&NHX:S=19]),20[&&NHX:S=20]),21[&&NHX:S=21]),22[&&NHX:S=22]),23[&&NHX:S=23]),24[&&NHX:S=24]),25[&&NHX:S=25]),26[&&NHX:S=26]),27[&&NHX:S=27]),28[&&NHX:S=28]),29[&&NHX:S=29]),30[&&NHX:S=30]),31[&&NHX:S=31]),32[&&NHX:S=32]),33[&&NHX:S=33]),34[&&NHX:S=34]),35[&&NHX:S=35]),36[&&NHX:S=36]),37[&&NHX:S=37]),38[&&NHX:S=38]),39[&&NHX:S=39]),40[&&NHX:S=40]),41[&&NHX:S=41]),42[&&NHX:S=42]),43[&&NHX:S=43]),44[&&NHX:S=44]),45[&&NHX:S=45]),46[&&NHX:S=46]),47[&&NHX:S=47]),48[&&NHX:S=48]),49[&&NHX:S=49]),50[&&NHX:S=50]),51[&&NHX:S=51]),52[&&NHX:S=52]),53[&&NHX:S=53]),54[&&NHX:S=54]),55[&&NHX:S=55]),56[&&NHX:S=56]),57[&&NHX:S=57]),58[&&NHX:S=58]),59[&&NHX:S=59]),60[&&NHX:S=60]),61[&&NHX:S=61]),62[&&NHX:S=62]),63[&&NHX:S=63]),64[&&NHX:S=64]),65[&&NHX:S=65]),66[&&NHX:S=66]),257[&&NHX:S=257]),258[&&NHX:S=258]),513[&&NHX:S=513]),514[&&NHX:S=514]),769[&&NHX:S=769]),770[&&NHX:S=770])");
            GSDI gSDI49 = new GSDI(phylogeny53, phylogeny51, false);
            if (gSDI49.getDuplicationsSum() != 58) {
                return false;
            }
            if (gSDI49.getSpeciationOrDuplicationEventsSum() != 8) {
                return false;
            }
            if (gSDI49.getSpeciationsSum() != 5) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }
}

