/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import org.forester.surfacing.BinaryDomainCombination;
import org.forester.surfacing.DomainId;
import org.forester.util.ForesterUtil;

public class BasicBinaryDomainCombination
implements BinaryDomainCombination {
    DomainId _id_0;
    DomainId _id_1;

    BasicBinaryDomainCombination() {
        this._id_0 = null;
        this._id_1 = null;
    }

    public BasicBinaryDomainCombination(DomainId domainId, DomainId domainId2) {
        if (domainId == null || domainId2 == null) {
            throw new IllegalArgumentException("attempt to create binary domain combination using null");
        }
        if (domainId.compareTo(domainId2) < 0) {
            this._id_0 = domainId;
            this._id_1 = domainId2;
        } else {
            this._id_0 = domainId2;
            this._id_1 = domainId;
        }
    }

    public BasicBinaryDomainCombination(String string, String string2) {
        this(new DomainId(string), new DomainId(string2));
    }

    public int compareTo(BinaryDomainCombination binaryDomainCombination) {
        if (binaryDomainCombination.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to compare [" + binaryDomainCombination.getClass() + "] to " + "[" + this.getClass() + "]");
        }
        if (this.equals(binaryDomainCombination)) {
            return 0;
        }
        int n = this.getId0().compareTo(binaryDomainCombination.getId0());
        if (n != 0) {
            return n;
        }
        return this.getId1().compareTo(binaryDomainCombination.getId1());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to null");
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to [" + object.getClass() + "]");
        }
        return this.getId0().equals(((BinaryDomainCombination)object).getId0()) && this.getId1().equals(((BinaryDomainCombination)object).getId1());
    }

    public DomainId getId0() {
        return this._id_0;
    }

    public DomainId getId1() {
        return this._id_1;
    }

    public int hashCode() {
        return this.getId0().hashCode() + 19 * this.getId1().hashCode();
    }

    public StringBuffer toGraphDescribingLanguage(BinaryDomainCombination.OutputFormat outputFormat, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (outputFormat) {
            case DOT: {
                if (ForesterUtil.isEmpty(string)) {
                    stringBuffer.append(this.getId0());
                    stringBuffer.append(" -- ");
                    stringBuffer.append(this.getId1());
                    if (!ForesterUtil.isEmpty(string2)) {
                        stringBuffer.append(" ");
                        stringBuffer.append(string2);
                    }
                    stringBuffer.append(";");
                    break;
                }
                stringBuffer.append(this.getId0());
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append(";");
                stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
                stringBuffer.append(this.getId1());
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append(";");
                stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
                stringBuffer.append(this.getId0());
                stringBuffer.append(" -- ");
                stringBuffer.append(this.getId1());
                if (!ForesterUtil.isEmpty(string2)) {
                    stringBuffer.append(" ");
                    stringBuffer.append(string2);
                }
                stringBuffer.append(";");
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown format:" + (Object)((Object)outputFormat)));
            }
        }
        return stringBuffer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getId0());
        stringBuffer.append("=");
        stringBuffer.append(this.getId1());
        return stringBuffer.toString();
    }

    public static BinaryDomainCombination createInstance(String string) {
        if (string.indexOf("=") < 1) {
            throw new IllegalArgumentException("Unexpected format for binary domain combination [" + string + "]");
        }
        String[] stringArray = string.split("=");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Unexpected format for binary domain combination [" + string + "]");
        }
        return new BasicBinaryDomainCombination(stringArray[0], stringArray[1]);
    }
}

