/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarity;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.PairwiseDomainSimilarity;
import org.forester.surfacing.PairwiseDomainSimilarityCalculator;
import org.forester.surfacing.PrintableDomainSimilarity;
import org.forester.surfacing.PrintableSpeciesSpecificDomainSimilariyData;
import org.forester.surfacing.Species;
import org.forester.surfacing.SpeciesSpecificDomainSimilariyData;
import org.forester.util.BasicDescriptiveStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDomainSimilarityCalculator
implements DomainSimilarityCalculator {
    final DomainSimilarity.DomainSimilaritySortField _sort;
    private final boolean _sort_by_species_count_first;
    private final boolean _treat_as_binary_comparison;

    public BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField domainSimilaritySortField, boolean bl, boolean bl2) {
        this._sort = domainSimilaritySortField;
        this._sort_by_species_count_first = bl;
        this._treat_as_binary_comparison = bl2;
    }

    @Override
    public SortedSet<DomainSimilarity> calculateSimilarities(PairwiseDomainSimilarityCalculator pairwiseDomainSimilarityCalculator, List<GenomeWideCombinableDomains> list, boolean bl, boolean bl2) {
        if (list.size() < 2) {
            throw new IllegalArgumentException("attempt to calculate multiple combinable domains similarity for less than two combinale domains collections");
        }
        TreeSet<DomainSimilarity> treeSet = new TreeSet<DomainSimilarity>();
        TreeSet<DomainId> treeSet2 = new TreeSet<DomainId>();
        for (GenomeWideCombinableDomains object : list) {
            treeSet2.addAll(object.getAllCombinableDomainsIds().keySet());
        }
        for (DomainId domainId : treeSet2) {
            ArrayList<CombinableDomains> arrayList = new ArrayList<CombinableDomains>(list.size());
            ArrayList<Species> arrayList2 = new ArrayList<Species>();
            for (GenomeWideCombinableDomains genomeWideCombinableDomains : list) {
                if (!genomeWideCombinableDomains.contains(domainId)) continue;
                arrayList.add(genomeWideCombinableDomains.get(domainId));
                arrayList2.add(genomeWideCombinableDomains.getSpecies());
            }
            if (bl) {
                boolean bl3 = true;
                for (CombinableDomains combinableDomains : arrayList) {
                    if (combinableDomains.getNumberOfCombinableDomains() <= 0) continue;
                    bl3 = false;
                    break;
                }
                if (bl3) continue;
            }
            if (arrayList.size() > 0) {
                if (bl2 && arrayList.size() <= 1) continue;
                DomainSimilarity domainSimilarity = this.calculateSimilarity(pairwiseDomainSimilarityCalculator, arrayList);
                if (domainSimilarity != null) {
                    treeSet.add(domainSimilarity);
                    continue;
                }
                throw new IllegalStateException("similarity is null: this should not have happened");
            }
            throw new IllegalStateException("this should not have happened");
        }
        return treeSet;
    }

    private DomainSimilarity calculateSimilarity(PairwiseDomainSimilarityCalculator pairwiseDomainSimilarityCalculator, List<CombinableDomains> list) {
        if (list.size() == 1) {
            TreeMap<Species, SpeciesSpecificDomainSimilariyData> treeMap = new TreeMap<Species, SpeciesSpecificDomainSimilariyData>();
            treeMap.put(list.get(0).getSpecies(), BasicDomainSimilarityCalculator.createSpeciesSpecificDomainSimilariyData(list.get(0)));
            return new PrintableDomainSimilarity(list.get(0), 1.0, 1.0, 1.0, 1.0, 0.0, 0, 0, 0, treeMap, this.getSort(), this.isSortBySpeciesCountFirst(), this.isTreatAsBinaryComparison());
        }
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        TreeMap<Species, SpeciesSpecificDomainSimilariyData> treeMap = new TreeMap<Species, SpeciesSpecificDomainSimilariyData>();
        treeMap.put(list.get(0).getSpecies(), BasicDomainSimilarityCalculator.createSpeciesSpecificDomainSimilariyData(list.get(0)));
        int n = 0;
        int n2 = 0;
        boolean bl = pairwiseDomainSimilarityCalculator instanceof CombinationsBasedPairwiseDomainSimilarityCalculator;
        for (int i = 1; i < list.size(); ++i) {
            treeMap.put(list.get(i).getSpecies(), BasicDomainSimilarityCalculator.createSpeciesSpecificDomainSimilariyData(list.get(i)));
            CombinableDomains combinableDomains = list.get(i);
            for (int j = 0; j < i; ++j) {
                PairwiseDomainSimilarity pairwiseDomainSimilarity = pairwiseDomainSimilarityCalculator.calculateSimilarity(combinableDomains, list.get(j));
                int n3 = pairwiseDomainSimilarity.getDifferenceInCounts();
                int n4 = 0;
                n4 = bl ? ((CombinationsBasedPairwiseDomainSimilarity)pairwiseDomainSimilarity).getNumberOfDifferentDomains() : n3;
                if (Math.abs(n3) > Math.abs(n)) {
                    n = n3;
                }
                if (Math.abs(n4) > Math.abs(n2)) {
                    n2 = n4;
                }
                basicDescriptiveStatistics.addValue(pairwiseDomainSimilarity.getSimilarityScore());
            }
        }
        if (basicDescriptiveStatistics.getN() < 1) {
            throw new AssertionError((Object)"empty descriptive statistics: this should not have happened");
        }
        if (basicDescriptiveStatistics.getN() != 1 && this.isTreatAsBinaryComparison()) {
            throw new IllegalArgumentException("attmpt to treat similarity with N not equal to one as binary comparison");
        }
        if (!this.isTreatAsBinaryComparison() && n < 0) {
            n = Math.abs(n);
            if (!bl) {
                n2 = Math.abs(n2);
            }
        }
        PrintableDomainSimilarity printableDomainSimilarity = null;
        printableDomainSimilarity = basicDescriptiveStatistics.getN() == 1 ? new PrintableDomainSimilarity(list.get(0), basicDescriptiveStatistics.getMin(), basicDescriptiveStatistics.getMax(), basicDescriptiveStatistics.arithmeticMean(), basicDescriptiveStatistics.median(), 0.0, basicDescriptiveStatistics.getN(), n, n2, treeMap, this.getSort(), this.isSortBySpeciesCountFirst(), this.isTreatAsBinaryComparison()) : new PrintableDomainSimilarity(list.get(0), basicDescriptiveStatistics.getMin(), basicDescriptiveStatistics.getMax(), basicDescriptiveStatistics.arithmeticMean(), basicDescriptiveStatistics.median(), basicDescriptiveStatistics.sampleStandardDeviation(), basicDescriptiveStatistics.getN(), n, n2, treeMap, this.getSort(), this.isSortBySpeciesCountFirst(), this.isTreatAsBinaryComparison());
        return printableDomainSimilarity;
    }

    private DomainSimilarity.DomainSimilaritySortField getSort() {
        return this._sort;
    }

    private boolean isSortBySpeciesCountFirst() {
        return this._sort_by_species_count_first;
    }

    private boolean isTreatAsBinaryComparison() {
        return this._treat_as_binary_comparison;
    }

    private static SpeciesSpecificDomainSimilariyData createSpeciesSpecificDomainSimilariyData(CombinableDomains combinableDomains) {
        PrintableSpeciesSpecificDomainSimilariyData printableSpeciesSpecificDomainSimilariyData = new PrintableSpeciesSpecificDomainSimilariyData(combinableDomains.getKeyDomainProteinsCount(), combinableDomains.getKeyDomainCount(), combinableDomains.getNumberOfCombinableDomains(), combinableDomains.getKeyDomainConfidenceDescriptiveStatistics());
        for (DomainId domainId : combinableDomains.getCombinableDomains()) {
            printableSpeciesSpecificDomainSimilariyData.addProteinsExhibitingCombinationCount(domainId, combinableDomains.getNumberOfProteinsExhibitingCombination(domainId));
        }
        return printableSpeciesSpecificDomainSimilariyData;
    }
}

