/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.go.GoId;
import org.forester.surfacing.AdjactantDirectedCombinableDomains;
import org.forester.surfacing.BasicCombinableDomains;
import org.forester.surfacing.BinaryDomainCombination;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.DirectedCombinableDomains;
import org.forester.surfacing.Domain;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.Protein;
import org.forester.surfacing.Species;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicGenomeWideCombinableDomains
implements GenomeWideCombinableDomains {
    private static final NumberFormat FORMATTER = new DecimalFormat("0.0E0");
    private static final Comparator<CombinableDomains> DESCENDING_KEY_DOMAIN_COUNT_ORDER = new Comparator<CombinableDomains>(){

        @Override
        public int compare(CombinableDomains combinableDomains, CombinableDomains combinableDomains2) {
            if (combinableDomains.getKeyDomainCount() < combinableDomains2.getKeyDomainCount()) {
                return 1;
            }
            if (combinableDomains.getKeyDomainCount() > combinableDomains2.getKeyDomainCount()) {
                return -1;
            }
            return combinableDomains.getKeyDomain().getId().compareTo(combinableDomains2.getKeyDomain().getId());
        }
    };
    private static final Comparator<CombinableDomains> DESCENDING_KEY_DOMAIN_PROTEINS_COUNT_ORDER = new Comparator<CombinableDomains>(){

        @Override
        public int compare(CombinableDomains combinableDomains, CombinableDomains combinableDomains2) {
            if (combinableDomains.getKeyDomainProteinsCount() < combinableDomains2.getKeyDomainProteinsCount()) {
                return 1;
            }
            if (combinableDomains.getKeyDomainProteinsCount() > combinableDomains2.getKeyDomainProteinsCount()) {
                return -1;
            }
            return combinableDomains.getKeyDomain().getId().compareTo(combinableDomains2.getKeyDomain().getId());
        }
    };
    private static final Comparator<CombinableDomains> DESCENDING_COMBINATIONS_COUNT_ORDER = new Comparator<CombinableDomains>(){

        @Override
        public int compare(CombinableDomains combinableDomains, CombinableDomains combinableDomains2) {
            if (combinableDomains.getNumberOfCombinableDomains() < combinableDomains2.getNumberOfCombinableDomains()) {
                return 1;
            }
            if (combinableDomains.getNumberOfCombinableDomains() > combinableDomains2.getNumberOfCombinableDomains()) {
                return -1;
            }
            return combinableDomains.getKeyDomain().getId().compareTo(combinableDomains2.getKeyDomain().getId());
        }
    };
    private final SortedMap<DomainId, CombinableDomains> _combinable_domains_map = new TreeMap<DomainId, CombinableDomains>();
    private final Species _species;
    private final BinaryDomainCombination.DomainCombinationType _dc_type;

    private BasicGenomeWideCombinableDomains(Species species, BinaryDomainCombination.DomainCombinationType domainCombinationType) {
        this._species = species;
        this._dc_type = domainCombinationType;
    }

    private void add(DomainId domainId, CombinableDomains combinableDomains) {
        this._combinable_domains_map.put(domainId, combinableDomains);
    }

    @Override
    public boolean contains(DomainId domainId) {
        return this._combinable_domains_map.containsKey(domainId);
    }

    @Override
    public CombinableDomains get(DomainId domainId) {
        return (CombinableDomains)this._combinable_domains_map.get(domainId);
    }

    @Override
    public SortedMap<DomainId, CombinableDomains> getAllCombinableDomainsIds() {
        return this._combinable_domains_map;
    }

    @Override
    public SortedSet<DomainId> getAllDomainIds() {
        TreeSet<DomainId> treeSet = new TreeSet<DomainId>();
        for (DomainId domainId : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains combinableDomains = (CombinableDomains)this.getAllCombinableDomainsIds().get(domainId);
            List<DomainId> list = combinableDomains.getAllDomains();
            for (DomainId domainId2 : list) {
                treeSet.add(domainId2);
            }
        }
        return treeSet;
    }

    @Override
    public BinaryDomainCombination.DomainCombinationType getDomainCombinationType() {
        return this._dc_type;
    }

    @Override
    public SortedSet<DomainId> getMostPromiscuosDomain() {
        TreeSet<DomainId> treeSet = new TreeSet<DomainId>();
        int n = (int)this.getPerGenomeDomainPromiscuityStatistics().getMax();
        for (DomainId domainId : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains combinableDomains = (CombinableDomains)this.getAllCombinableDomainsIds().get(domainId);
            if (combinableDomains.getNumberOfCombinableDomains() != n) continue;
            treeSet.add(domainId);
        }
        return treeSet;
    }

    @Override
    public DescriptiveStatistics getPerGenomeDomainPromiscuityStatistics() {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (DomainId domainId : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains combinableDomains = (CombinableDomains)this.getAllCombinableDomainsIds().get(domainId);
            basicDescriptiveStatistics.addValue(combinableDomains.getNumberOfCombinableDomains());
        }
        return basicDescriptiveStatistics;
    }

    @Override
    public int getSize() {
        return this._combinable_domains_map.size();
    }

    @Override
    public Species getSpecies() {
        return this._species;
    }

    @Override
    public SortedSet<BinaryDomainCombination> toBinaryDomainCombinations() {
        TreeSet<BinaryDomainCombination> treeSet = new TreeSet<BinaryDomainCombination>();
        for (DomainId domainId : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains combinableDomains = (CombinableDomains)this.getAllCombinableDomainsIds().get(domainId);
            for (BinaryDomainCombination binaryDomainCombination : combinableDomains.toBinaryDomainCombinations()) {
                treeSet.add(binaryDomainCombination);
            }
        }
        return treeSet;
    }

    public String toString() {
        return this.toStringBuilder(GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.ALPHABETICAL_KEY_ID).toString();
    }

    @Override
    public StringBuilder toStringBuilder(GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder genomeWideCombinableDomainsSortOrder) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<CombinableDomains> arrayList = new ArrayList<CombinableDomains>();
        for (DomainId object : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains combinableDomains = (CombinableDomains)this.getAllCombinableDomainsIds().get(object);
            arrayList.add(combinableDomains);
        }
        if (genomeWideCombinableDomainsSortOrder == GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.KEY_DOMAIN_COUNT) {
            Collections.sort(arrayList, DESCENDING_KEY_DOMAIN_COUNT_ORDER);
        } else if (genomeWideCombinableDomainsSortOrder == GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.KEY_DOMAIN_PROTEINS_COUNT) {
            Collections.sort(arrayList, DESCENDING_KEY_DOMAIN_PROTEINS_COUNT_ORDER);
        } else if (genomeWideCombinableDomainsSortOrder == GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.COMBINATIONS_COUNT) {
            Collections.sort(arrayList, DESCENDING_COMBINATIONS_COUNT_ORDER);
        }
        for (CombinableDomains combinableDomains : arrayList) {
            stringBuilder.append(ForesterUtil.pad(new StringBuffer(combinableDomains.getKeyDomain().toString()), 18, ' ', false));
            stringBuilder.append(ForesterUtil.pad(new StringBuffer("" + combinableDomains.getKeyDomainCount()), 8, ' ', false));
            stringBuilder.append(ForesterUtil.pad(new StringBuffer("" + combinableDomains.getKeyDomainProteinsCount()), 8, ' ', false));
            stringBuilder.append(ForesterUtil.pad(new StringBuffer("" + combinableDomains.getNumberOfCombinableDomains()), 8, ' ', false));
            stringBuilder.append(ForesterUtil.pad(new StringBuffer("" + FORMATTER.format(combinableDomains.getKeyDomainConfidenceDescriptiveStatistics().median())), 10, ' ', false));
            stringBuilder.append((CharSequence)combinableDomains.getCombiningDomainIdsAsStringBuilder());
            stringBuilder.append(ForesterUtil.getLineSeparator());
        }
        return stringBuilder;
    }

    private static void countDomains(Map<DomainId, Integer> map, Map<DomainId, Integer> map2, Map<DomainId, DescriptiveStatistics> map3, Set<DomainId> set, DomainId domainId, double d) {
        if (map.containsKey(domainId)) {
            map.put(domainId, 1 + map.get(domainId));
            if (!set.contains(domainId)) {
                map2.put(domainId, 1 + map2.get(domainId));
            }
        } else {
            map3.put(domainId, new BasicDescriptiveStatistics());
            map.put(domainId, 1);
            map2.put(domainId, 1);
        }
        map3.get(domainId).addValue(d);
        set.add(domainId);
    }

    public static BasicGenomeWideCombinableDomains createInstance(List<Protein> list, boolean bl, Species species) {
        return BasicGenomeWideCombinableDomains.createInstance(list, bl, species, null, BinaryDomainCombination.DomainCombinationType.BASIC);
    }

    public static BasicGenomeWideCombinableDomains createInstance(List<Protein> list, boolean bl, Species species, BinaryDomainCombination.DomainCombinationType domainCombinationType) {
        return BasicGenomeWideCombinableDomains.createInstance(list, bl, species, null, domainCombinationType);
    }

    /*
     * WARNING - void declaration
     */
    public static BasicGenomeWideCombinableDomains createInstance(List<Protein> list, boolean bl, Species species, Map<DomainId, List<GoId>> map, BinaryDomainCombination.DomainCombinationType domainCombinationType) {
        BasicGenomeWideCombinableDomains basicGenomeWideCombinableDomains = new BasicGenomeWideCombinableDomains(species, domainCombinationType);
        HashMap<DomainId, Integer> hashMap = new HashMap<DomainId, Integer>();
        HashMap<DomainId, Integer> hashMap2 = new HashMap<DomainId, Integer>();
        HashMap<DomainId, DescriptiveStatistics> hashMap3 = new HashMap<DomainId, DescriptiveStatistics>();
        for (Protein object : list) {
            if (!object.getSpecies().equals(species)) {
                throw new IllegalArgumentException("species (" + object.getSpecies() + ") does not match species of combinable domains collection (" + species + ")");
            }
            HashSet<DomainId> hashSet = new HashSet<DomainId>();
            HashSet<DomainId> hashSet2 = new HashSet<DomainId>();
            for (int i = 0; i < object.getProteinDomains().size(); ++i) {
                void var20_22;
                Collection<Object> collection;
                Domain domain = object.getProteinDomain(i);
                DomainId domainId = domain.getDomainId();
                int n = domain.getFrom();
                BasicGenomeWideCombinableDomains.countDomains(hashMap, hashMap2, hashMap3, hashSet2, domainId, domain.getPerSequenceEvalue());
                if (hashSet.contains(domainId)) continue;
                if (domainCombinationType == BinaryDomainCombination.DomainCombinationType.BASIC) {
                    hashSet.add(domainId);
                }
                CombinableDomains combinableDomains = null;
                if (basicGenomeWideCombinableDomains.contains(domainId)) {
                    combinableDomains = basicGenomeWideCombinableDomains.get(domainId);
                } else {
                    combinableDomains = domainCombinationType == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT ? new AdjactantDirectedCombinableDomains(domain.getDomainId(), species) : (domainCombinationType == BinaryDomainCombination.DomainCombinationType.DIRECTED ? new DirectedCombinableDomains(domain.getDomainId(), species) : new BasicCombinableDomains(domain.getDomainId(), species));
                    if (map != null && map.containsKey(domain.getDomainId())) {
                        collection = map.get(domain.getDomainId());
                        for (GoId goId : collection) {
                            combinableDomains.getKeyDomain().addGoId(goId);
                        }
                    }
                    basicGenomeWideCombinableDomains.add(domainId, combinableDomains);
                }
                collection = new HashSet<DomainId>();
                if (bl) {
                    collection.add(domainId);
                }
                Object object2 = null;
                boolean bl2 = false;
                while (var20_22 < object.getNumberOfProteinDomains()) {
                    DomainId domainId2;
                    if (!(domainCombinationType != BinaryDomainCombination.DomainCombinationType.BASIC && n >= object.getProteinDomain((int)var20_22).getFrom() || i == var20_22 || collection.contains(domainId2 = object.getProteinDomain((int)var20_22).getDomainId()))) {
                        collection.add(domainId2);
                        if (domainCombinationType != BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT) {
                            combinableDomains.addCombinableDomain(object.getProteinDomain((int)var20_22).getDomainId());
                        } else if (object2 == null) {
                            object2 = object.getProteinDomain((int)var20_22);
                        } else if (object.getProteinDomain((int)var20_22).getFrom() < object2.getFrom()) {
                            object2 = object.getProteinDomain((int)var20_22);
                        }
                    }
                    ++var20_22;
                }
                if (domainCombinationType != BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT || object2 == null) continue;
                combinableDomains.addCombinableDomain(object2.getDomainId());
            }
        }
        for (DomainId domainId : hashMap.keySet()) {
            basicGenomeWideCombinableDomains.get(domainId).setKeyDomainCount((Integer)hashMap.get(domainId));
            basicGenomeWideCombinableDomains.get(domainId).setKeyDomainProteinsCount((Integer)hashMap2.get(domainId));
            basicGenomeWideCombinableDomains.get(domainId).setKeyDomainConfidenceDescriptiveStatistics((DescriptiveStatistics)hashMap3.get(domainId));
        }
        return basicGenomeWideCombinableDomains;
    }
}

