/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.forester.surfacing.BasicSpecies;
import org.forester.surfacing.Domain;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.Protein;
import org.forester.surfacing.ProteinId;
import org.forester.surfacing.Species;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicProtein
implements Protein {
    private final ProteinId _id;
    private final Species _species;
    private String _name;
    private String _desc;
    private String _accession;
    private final List<Domain> _protein_domains;

    public BasicProtein(String string, String string2) {
        this._id = new ProteinId(string);
        this._species = new BasicSpecies(string2);
        this._protein_domains = new ArrayList<Domain>();
        this.init();
    }

    @Override
    public void addProteinDomain(Domain domain) {
        this.getProteinDomains().add(domain);
    }

    @Override
    public boolean contains(List<DomainId> list, boolean bl) {
        if (!bl) {
            for (DomainId domainId : list) {
                if (this.getProteinDomainIds().contains(domainId)) continue;
                return false;
            }
            return true;
        }
        int n = -1;
        block1: for (DomainId domainId : list) {
            if (this.getProteinDomainIds().contains(domainId)) {
                List<Domain> list2 = this.getProteinDomains(domainId);
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                for (Domain domain : list2) {
                    treeSet.add(domain.getFrom());
                }
                Iterator<Domain> iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)((Object)iterator.next());
                    if (n2 <= n) continue;
                    n = n2;
                    continue block1;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public String getAccession() {
        return this._accession;
    }

    @Override
    public String getDescription() {
        return this._desc;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public int getNumberOfProteinDomains() {
        return this.getProteinDomains().size();
    }

    @Override
    public Domain getProteinDomain(int n) {
        return this._protein_domains.get(n);
    }

    @Override
    public int getProteinDomainCount(DomainId domainId) {
        return this.getProteinDomains(domainId).size();
    }

    private List<DomainId> getProteinDomainIds() {
        ArrayList<DomainId> arrayList = new ArrayList<DomainId>(this.getProteinDomains().size());
        for (Domain domain : this.getProteinDomains()) {
            arrayList.add(domain.getDomainId());
        }
        return arrayList;
    }

    @Override
    public List<Domain> getProteinDomains() {
        return this._protein_domains;
    }

    @Override
    public List<Domain> getProteinDomains(DomainId domainId) {
        ArrayList<Domain> arrayList = new ArrayList<Domain>();
        for (Domain domain : this.getProteinDomains()) {
            if (!domain.getDomainId().equals(domainId)) continue;
            arrayList.add(domain);
        }
        return arrayList;
    }

    @Override
    public ProteinId getProteinId() {
        return this._id;
    }

    @Override
    public Species getSpecies() {
        return this._species;
    }

    private void init() {
        this._desc = "";
        this._accession = "";
        this._name = "";
    }

    public void setAccession(String string) {
        this._accession = string;
    }

    public void setDescription(String string) {
        this._desc = string;
    }

    public void setName(String string) {
        this._name = string;
    }
}

