/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import org.forester.surfacing.Species;
import org.forester.util.ForesterUtil;

public class BasicSpecies
implements Species {
    private final String _species_id;

    public BasicSpecies(String string) {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("attempt to create new species from empty or null string");
        }
        this._species_id = string.trim();
    }

    public int compareTo(Species species) {
        if (this == species) {
            return 0;
        }
        return this.getSpeciesId().toLowerCase().compareTo(species.getSpeciesId().toLowerCase());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to null");
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + object + " [" + object.getClass() + "]");
        }
        return this.getSpeciesId().equals(((Species)object).getSpeciesId());
    }

    public String getSpeciesId() {
        return this._species_id;
    }

    public int hashCode() {
        return this.getSpeciesId().hashCode();
    }

    public String toString() {
        return this.getSpeciesId();
    }
}

