/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import org.forester.surfacing.PairwiseDomainSimilarity;

public class CountsBasedPairwiseDomainSimilarity
implements PairwiseDomainSimilarity {
    private final double _score;
    private final int _copy_number_difference;

    public CountsBasedPairwiseDomainSimilarity(int n, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("attempt to use copy sum of less than or equal to 0: " + n2);
        }
        this._copy_number_difference = n;
        int n3 = Math.abs(n);
        if (n3 > n2) {
            throw new IllegalArgumentException("attempt to use absolute copy number difference larger than copy number sum");
        }
        this._score = 1.0 - (double)n3 / (double)n2;
    }

    public int getDifferenceInCounts() {
        return this._copy_number_difference;
    }

    public double getSimilarityScore() {
        return this._score;
    }
}

