/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import org.forester.surfacing.BinaryDomainCombination;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.GenomeWideCombinableDomains;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainArchitectureBasedGenomeSimilarityCalculator {
    public static final double MAX_SIMILARITY_SCORE = 1.0;
    public static final double MIN_SIMILARITY_SCORE = 0.0;
    private final GenomeWideCombinableDomains _combinable_domains_genome_0;
    private final GenomeWideCombinableDomains _combinable_domains_genome_1;
    private Set<DomainId> _domain_ids_to_ignore;
    private boolean _allow_domains_to_be_ignored;
    private Set<DomainId> _all_domains;
    private Set<DomainId> _shared_domains;
    private Set<DomainId> _domains_specific_to_0;
    private Set<DomainId> _domains_specific_to_1;
    private Set<BinaryDomainCombination> _all_binary_domain_combinations;
    private Set<BinaryDomainCombination> _shared_binary_domain_combinations;
    private Set<BinaryDomainCombination> _binary_domain_combinations_specific_to_0;
    private Set<BinaryDomainCombination> _binary_domain_combinations_specific_to_1;

    public DomainArchitectureBasedGenomeSimilarityCalculator(GenomeWideCombinableDomains genomeWideCombinableDomains, GenomeWideCombinableDomains genomeWideCombinableDomains2) {
        if (genomeWideCombinableDomains == null || genomeWideCombinableDomains.getSize() < 1 || genomeWideCombinableDomains2 == null || genomeWideCombinableDomains2.getSize() < 1) {
            throw new IllegalArgumentException("attempt to compare null or empty combinable domains collection");
        }
        if (genomeWideCombinableDomains.getSpecies().equals(genomeWideCombinableDomains2.getSpecies())) {
            throw new IllegalArgumentException("attempt to compare combinable domains collection from the same species");
        }
        this._combinable_domains_genome_0 = genomeWideCombinableDomains;
        this._combinable_domains_genome_1 = genomeWideCombinableDomains2;
        this.init();
        this.forceRecalculation();
    }

    public void addDomainIdToIgnore(DomainId domainId) {
        this.forceRecalculation();
        this.getDomainIdsToIgnore().add(domainId);
    }

    public double calculateSharedBinaryDomainCombinationBasedGenomeSimilarityScore() {
        double d = this.getAllBinaryDomainCombinations().size();
        double d2 = this.getSharedBinaryDomainCombinations().size();
        if (d == 0.0) {
            return 0.0;
        }
        return 1.0 - (d - d2) / d;
    }

    public double calculateSharedDomainsBasedGenomeSimilarityScore() {
        double d = this.getAllDomains().size();
        double d2 = this.getSharedDomains().size();
        if (d == 0.0) {
            return 0.0;
        }
        return 1.0 - (d - d2) / d;
    }

    public void deleteAllDomainIdsToIgnore() {
        this.forceRecalculation();
        this.setDomainIdsToIgnore(new HashSet<DomainId>());
    }

    private void forceRecalculation() {
        this._all_domains = null;
        this._shared_domains = null;
        this._domains_specific_to_0 = null;
        this._domains_specific_to_1 = null;
        this._all_binary_domain_combinations = null;
        this._shared_binary_domain_combinations = null;
        this._binary_domain_combinations_specific_to_0 = null;
        this._binary_domain_combinations_specific_to_1 = null;
    }

    public Set<BinaryDomainCombination> getAllBinaryDomainCombinations() {
        if (this._all_binary_domain_combinations == null) {
            HashSet<BinaryDomainCombination> hashSet = new HashSet<BinaryDomainCombination>();
            hashSet.addAll(this.getCombinableDomainsGenome0().toBinaryDomainCombinations());
            hashSet.addAll(this.getCombinableDomainsGenome1().toBinaryDomainCombinations());
            this._all_binary_domain_combinations = this.isAllowDomainsToBeIgnored() && !this.getDomainIdsToIgnore().isEmpty() ? this.pruneBinaryCombinations(hashSet) : hashSet;
        }
        return this._all_binary_domain_combinations;
    }

    public Set<DomainId> getAllDomains() {
        if (this._all_domains == null) {
            HashSet<DomainId> hashSet = new HashSet<DomainId>();
            hashSet.addAll(this.getCombinableDomainsGenome0().getAllDomainIds());
            hashSet.addAll(this.getCombinableDomainsGenome1().getAllDomainIds());
            this._all_domains = this.isAllowDomainsToBeIgnored() && !this.getDomainIdsToIgnore().isEmpty() ? this.pruneDomains(hashSet) : hashSet;
        }
        return this._all_domains;
    }

    private Set<BinaryDomainCombination> getBinaryDomainCombinationsSpecificToGenome(boolean bl) {
        HashSet<BinaryDomainCombination> hashSet = new HashSet<BinaryDomainCombination>();
        SortedSet<BinaryDomainCombination> sortedSet = this.getCombinableDomainsGenome0().toBinaryDomainCombinations();
        SortedSet<BinaryDomainCombination> sortedSet2 = this.getCombinableDomainsGenome1().toBinaryDomainCombinations();
        if (bl) {
            for (BinaryDomainCombination binaryDomainCombination : sortedSet) {
                if (sortedSet2.contains(binaryDomainCombination)) continue;
                hashSet.add(binaryDomainCombination);
            }
        } else {
            for (BinaryDomainCombination binaryDomainCombination : sortedSet2) {
                if (sortedSet.contains(binaryDomainCombination)) continue;
                hashSet.add(binaryDomainCombination);
            }
        }
        if (this.isAllowDomainsToBeIgnored() && !this.getDomainIdsToIgnore().isEmpty()) {
            return this.pruneBinaryCombinations(hashSet);
        }
        return hashSet;
    }

    public Set<BinaryDomainCombination> getBinaryDomainCombinationsSpecificToGenome0() {
        if (this._binary_domain_combinations_specific_to_0 == null) {
            this._binary_domain_combinations_specific_to_0 = this.getBinaryDomainCombinationsSpecificToGenome(true);
        }
        return this._binary_domain_combinations_specific_to_0;
    }

    public Set<BinaryDomainCombination> getBinaryDomainCombinationsSpecificToGenome1() {
        if (this._binary_domain_combinations_specific_to_1 == null) {
            this._binary_domain_combinations_specific_to_1 = this.getBinaryDomainCombinationsSpecificToGenome(false);
        }
        return this._binary_domain_combinations_specific_to_1;
    }

    private GenomeWideCombinableDomains getCombinableDomainsGenome0() {
        return this._combinable_domains_genome_0;
    }

    private GenomeWideCombinableDomains getCombinableDomainsGenome1() {
        return this._combinable_domains_genome_1;
    }

    private Set<DomainId> getDomainIdsToIgnore() {
        return this._domain_ids_to_ignore;
    }

    private Set<DomainId> getDomainsSpecificToGenome(boolean bl) {
        HashSet<DomainId> hashSet = new HashSet<DomainId>();
        SortedSet<DomainId> sortedSet = this.getCombinableDomainsGenome0().getAllDomainIds();
        SortedSet<DomainId> sortedSet2 = this.getCombinableDomainsGenome1().getAllDomainIds();
        if (bl) {
            for (DomainId domainId : sortedSet) {
                if (sortedSet2.contains(domainId)) continue;
                hashSet.add(domainId);
            }
        } else {
            for (DomainId domainId : sortedSet2) {
                if (sortedSet.contains(domainId)) continue;
                hashSet.add(domainId);
            }
        }
        if (this.isAllowDomainsToBeIgnored() && !this.getDomainIdsToIgnore().isEmpty()) {
            return this.pruneDomains(hashSet);
        }
        return hashSet;
    }

    public Set<DomainId> getDomainsSpecificToGenome0() {
        if (this._domains_specific_to_0 == null) {
            this._domains_specific_to_0 = this.getDomainsSpecificToGenome(true);
        }
        return this._domains_specific_to_0;
    }

    public Set<DomainId> getDomainsSpecificToGenome1() {
        if (this._domains_specific_to_1 == null) {
            this._domains_specific_to_1 = this.getDomainsSpecificToGenome(false);
        }
        return this._domains_specific_to_1;
    }

    public Set<BinaryDomainCombination> getSharedBinaryDomainCombinations() {
        if (this._shared_binary_domain_combinations == null) {
            HashSet<BinaryDomainCombination> hashSet = new HashSet<BinaryDomainCombination>();
            SortedSet<BinaryDomainCombination> sortedSet = this.getCombinableDomainsGenome0().toBinaryDomainCombinations();
            SortedSet<BinaryDomainCombination> sortedSet2 = this.getCombinableDomainsGenome1().toBinaryDomainCombinations();
            for (BinaryDomainCombination binaryDomainCombination : sortedSet) {
                if (!sortedSet2.contains(binaryDomainCombination)) continue;
                hashSet.add(binaryDomainCombination);
            }
            this._shared_binary_domain_combinations = hashSet;
            if (this.isAllowDomainsToBeIgnored() && !this.getDomainIdsToIgnore().isEmpty()) {
                this._shared_binary_domain_combinations = this.pruneBinaryCombinations(hashSet);
            }
        }
        return this._shared_binary_domain_combinations;
    }

    public Set<DomainId> getSharedDomains() {
        if (this._shared_domains == null) {
            HashSet<DomainId> hashSet = new HashSet<DomainId>();
            SortedSet<DomainId> sortedSet = this.getCombinableDomainsGenome0().getAllDomainIds();
            SortedSet<DomainId> sortedSet2 = this.getCombinableDomainsGenome1().getAllDomainIds();
            for (DomainId domainId : sortedSet) {
                if (!sortedSet2.contains(domainId)) continue;
                hashSet.add(domainId);
            }
            this._shared_domains = hashSet;
            if (this.isAllowDomainsToBeIgnored() && !this.getDomainIdsToIgnore().isEmpty()) {
                this._shared_domains = this.pruneDomains(hashSet);
            }
        }
        return this._shared_domains;
    }

    private void init() {
        this.deleteAllDomainIdsToIgnore();
        this.setAllowDomainsToBeIgnored(false);
    }

    private boolean isAllowDomainsToBeIgnored() {
        return this._allow_domains_to_be_ignored;
    }

    private Set<BinaryDomainCombination> pruneBinaryCombinations(Set<BinaryDomainCombination> set) {
        HashSet<BinaryDomainCombination> hashSet = new HashSet<BinaryDomainCombination>();
        for (BinaryDomainCombination binaryDomainCombination : set) {
            if (this.getDomainIdsToIgnore().contains(binaryDomainCombination.getId0()) || this.getDomainIdsToIgnore().contains(binaryDomainCombination.getId1())) continue;
            hashSet.add(binaryDomainCombination);
        }
        return hashSet;
    }

    private Set<DomainId> pruneDomains(Set<DomainId> set) {
        HashSet<DomainId> hashSet = new HashSet<DomainId>();
        for (DomainId domainId : set) {
            if (this.getDomainIdsToIgnore().contains(domainId)) continue;
            hashSet.add(domainId);
        }
        return hashSet;
    }

    public void setAllowDomainsToBeIgnored(boolean bl) {
        this.forceRecalculation();
        this._allow_domains_to_be_ignored = bl;
    }

    void setDomainIdsToIgnore(Set<DomainId> set) {
        this.forceRecalculation();
        this._domain_ids_to_ignore = set;
    }
}

