/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.surfacing.Domain;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.DomainLengths;
import org.forester.surfacing.Protein;
import org.forester.surfacing.Species;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainLengthsTable {
    private static final DecimalFormat DF = new DecimalFormat("#.0");
    final SortedMap<DomainId, DomainLengths> _domain_lengths = new TreeMap<DomainId, DomainLengths>();
    final List<Species> _species = new ArrayList<Species>();

    private void addDomainLengths(DomainLengths domainLengths) {
        if (this.getDomainLengths().containsKey(domainLengths.getDomainId())) {
            throw new IllegalArgumentException("domain lengths for [" + domainLengths.getDomainId() + "] already added");
        }
        this.getDomainLengths().put(domainLengths.getDomainId(), domainLengths);
    }

    private void addLength(DomainId domainId, Species species, int n) {
        if (!this.getDomainLengths().containsKey(domainId)) {
            this.addDomainLengths(new DomainLengths(domainId));
        }
        ((DomainLengths)this.getDomainLengths().get(domainId)).addLength(species, n);
    }

    public void addLengths(List<Protein> list) {
        for (Protein protein : list) {
            Species species = protein.getSpecies();
            if (!this._species.contains(species)) {
                this._species.add(species);
            }
            for (Domain domain : protein.getProteinDomains()) {
                this.addLength(domain.getDomainId(), species, domain.getTo() - domain.getFrom() + 1);
            }
        }
    }

    public DescriptiveStatistics calculateMeanBasedStatisticsForAllSpecies() {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (Species species : this.getSpecies()) {
            DescriptiveStatistics descriptiveStatistics = this.calculateMeanBasedStatisticsForSpecies(species);
            basicDescriptiveStatistics.addValue(descriptiveStatistics.arithmeticMean());
        }
        return basicDescriptiveStatistics;
    }

    public DescriptiveStatistics calculateMeanBasedStatisticsForDomain(DomainId domainId) {
        return this.getDomainLengths(domainId).calculateMeanBasedStatistics();
    }

    public DescriptiveStatistics calculateMeanBasedStatisticsForSpecies(Species species) {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (DomainLengths domainLengths : this.getDomainLengths().values()) {
            if (!domainLengths.isHasLengthStatistic(species)) continue;
            basicDescriptiveStatistics.addValue(domainLengths.getLengthStatistic(species).arithmeticMean());
        }
        return basicDescriptiveStatistics;
    }

    public StringBuilder createMeanBasedStatisticsPerSpeciesTable() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SPECIES");
        stringBuilder.append("\t");
        stringBuilder.append("MEAN");
        stringBuilder.append("\t");
        stringBuilder.append("SD");
        stringBuilder.append("\t");
        stringBuilder.append("MIN");
        stringBuilder.append("\t");
        stringBuilder.append("MAX");
        stringBuilder.append("\t");
        stringBuilder.append("MEDIAN");
        stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
        for (Species species : this.getSpecies()) {
            DescriptiveStatistics descriptiveStatistics = this.calculateMeanBasedStatisticsForSpecies(species);
            stringBuilder.append(species);
            stringBuilder.append("\t");
            stringBuilder.append(DF.format(descriptiveStatistics.arithmeticMean()));
            stringBuilder.append("\t");
            try {
                stringBuilder.append(DF.format(descriptiveStatistics.sampleStandardDeviation()));
            }
            catch (ArithmeticException arithmeticException) {
                stringBuilder.append("");
            }
            stringBuilder.append("\t");
            stringBuilder.append(DF.format(descriptiveStatistics.getMin()));
            stringBuilder.append("\t");
            stringBuilder.append(DF.format(descriptiveStatistics.getMax()));
            stringBuilder.append("\t");
            try {
                stringBuilder.append(DF.format(descriptiveStatistics.median()));
            }
            catch (ArithmeticException arithmeticException) {
                stringBuilder.append("");
            }
            stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
        }
        return stringBuilder;
    }

    private SortedMap<DomainId, DomainLengths> getDomainLengths() {
        return this._domain_lengths;
    }

    public DomainLengths getDomainLengths(DomainId domainId) {
        return (DomainLengths)this.getDomainLengths().get(domainId);
    }

    public List<DomainLengths> getDomainLengthsList() {
        ArrayList<DomainLengths> arrayList = new ArrayList<DomainLengths>();
        for (DomainLengths domainLengths : this.getDomainLengths().values()) {
            arrayList.add(domainLengths);
        }
        return arrayList;
    }

    public DescriptiveStatistics getLengthStatistic(DomainId domainId, Species species) {
        return this.getDomainLengths(domainId).getLengthStatistic(species);
    }

    public List<Species> getSpecies() {
        return this._species;
    }
}

