/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogenyinference.BasicCharacterStateMatrix;
import org.forester.phylogenyinference.CharacterStateMatrix;
import org.forester.phylogenyinference.DolloParsimony;
import org.forester.phylogenyinference.FitchParsimony;
import org.forester.surfacing.AdjactantDirectedBinaryDomainCombination;
import org.forester.surfacing.BasicBinaryDomainCombination;
import org.forester.surfacing.BinaryDomainCombination;
import org.forester.surfacing.DirectedBinaryDomainCombination;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.MappingResults;
import org.forester.surfacing.Species;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DomainParsimonyCalculator {
    private static final String TYPE_FORBINARY_CHARACTERS = "parsimony inferred";
    private CharacterStateMatrix<CharacterStateMatrix.GainLossStates> _gain_loss_matrix;
    private CharacterStateMatrix<CharacterStateMatrix.BinaryStates> _binary_internal_states_matrix;
    private final List<GenomeWideCombinableDomains> _gwcd_list;
    private final Phylogeny _phylogeny;
    private int _total_losses;
    private int _total_gains;
    private int _total_unchanged;
    private int _cost;
    private Map<DomainId, Set<String>> _domain_id_to_secondary_features_map;
    private SortedSet<DomainId> _positive_filter;

    private DomainParsimonyCalculator(Phylogeny phylogeny) {
        this.init();
        this._phylogeny = phylogeny;
        this._gwcd_list = null;
    }

    private DomainParsimonyCalculator(Phylogeny phylogeny, List<GenomeWideCombinableDomains> list) {
        this.init();
        this._phylogeny = phylogeny;
        this._gwcd_list = list;
    }

    private DomainParsimonyCalculator(Phylogeny phylogeny, List<GenomeWideCombinableDomains> list, Map<DomainId, Set<String>> map) {
        this.init();
        this._phylogeny = phylogeny;
        this._gwcd_list = list;
        this.setDomainIdToSecondaryFeaturesMap(map);
    }

    int calculateNumberOfBinaryDomainCombination() {
        if (this.getGenomeWideCombinableDomainsList().isEmpty()) {
            throw new IllegalArgumentException("genome wide combinable domains list is empty");
        }
        HashSet<BinaryDomainCombination> hashSet = new HashSet<BinaryDomainCombination>();
        for (GenomeWideCombinableDomains genomeWideCombinableDomains : this.getGenomeWideCombinableDomainsList()) {
            for (BinaryDomainCombination binaryDomainCombination : genomeWideCombinableDomains.toBinaryDomainCombinations()) {
                hashSet.add(binaryDomainCombination);
            }
        }
        return hashSet.size();
    }

    CharacterStateMatrix<CharacterStateMatrix.BinaryStates> createMatrixOfBinaryDomainCombinationPresenceOrAbsence() {
        return DomainParsimonyCalculator.createMatrixOfBinaryDomainCombinationPresenceOrAbsence(this.getGenomeWideCombinableDomainsList());
    }

    CharacterStateMatrix<CharacterStateMatrix.BinaryStates> createMatrixOfDomainPresenceOrAbsence() {
        return DomainParsimonyCalculator.createMatrixOfDomainPresenceOrAbsence(this.getGenomeWideCombinableDomainsList(), this.getPositiveFilter());
    }

    CharacterStateMatrix<CharacterStateMatrix.BinaryStates> createMatrixOfSecondaryFeaturePresenceOrAbsence(Map<Species, MappingResults> map) {
        return DomainParsimonyCalculator.createMatrixOfSecondaryFeaturePresenceOrAbsence(this.getGenomeWideCombinableDomainsList(), this.getDomainIdToSecondaryFeaturesMap(), map);
    }

    Phylogeny decoratePhylogenyWithDomains(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            String string = phylogenyNode.getNodeName();
            BinaryCharacters binaryCharacters = new BinaryCharacters(this.getUnitsOnNode(string), this.getUnitsGainedOnNode(string), this.getUnitsLostOnNode(string), TYPE_FORBINARY_CHARACTERS, this.getSumOfPresentOnNode(string), this.getSumOfGainsOnNode(string), this.getSumOfLossesOnNode(string));
            phylogenyNode.getNodeData().setBinaryCharacters(binaryCharacters);
        }
        return phylogeny;
    }

    private void executeDolloParsimony(boolean bl) {
        this.reset();
        DolloParsimony dolloParsimony = DolloParsimony.createInstance();
        dolloParsimony.setReturnGainLossMatrix(true);
        dolloParsimony.setReturnInternalStates(true);
        CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix = null;
        characterStateMatrix = bl ? this.createMatrixOfDomainPresenceOrAbsence() : this.createMatrixOfBinaryDomainCombinationPresenceOrAbsence();
        dolloParsimony.execute(this.getPhylogeny(), characterStateMatrix);
        this.setGainLossMatrix(dolloParsimony.getGainLossMatrix());
        this.setBinaryInternalStatesMatrix(dolloParsimony.getInternalStatesMatrix());
        this.setCost(dolloParsimony.getCost());
        this.setTotalGains(dolloParsimony.getTotalGains());
        this.setTotalLosses(dolloParsimony.getTotalLosses());
        this.setTotalUnchanged(dolloParsimony.getTotalUnchanged());
    }

    public void executeDolloParsimonyOnBinaryDomainCombintionPresence() {
        this.executeDolloParsimony(false);
    }

    public void executeDolloParsimonyOnDomainPresence() {
        this.executeDolloParsimony(true);
    }

    public void executeDolloParsimonyOnDomainPresence(SortedSet<DomainId> sortedSet) {
        this.setPositiveFilter(sortedSet);
        this.executeDolloParsimony(true);
        this.setPositiveFilter(null);
    }

    public void executeDolloParsimonyOnSecondaryFeatures(Map<Species, MappingResults> map) {
        if (this.getDomainIdToSecondaryFeaturesMap() == null) {
            throw new IllegalStateException("Domain id to secondary features map has apparently not been set");
        }
        this.reset();
        DolloParsimony dolloParsimony = DolloParsimony.createInstance();
        dolloParsimony.setReturnGainLossMatrix(true);
        dolloParsimony.setReturnInternalStates(true);
        CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix = this.createMatrixOfSecondaryFeaturePresenceOrAbsence(map);
        dolloParsimony.execute(this.getPhylogeny(), characterStateMatrix);
        this.setGainLossMatrix(dolloParsimony.getGainLossMatrix());
        this.setBinaryInternalStatesMatrix(dolloParsimony.getInternalStatesMatrix());
        this.setCost(dolloParsimony.getCost());
        this.setTotalGains(dolloParsimony.getTotalGains());
        this.setTotalLosses(dolloParsimony.getTotalLosses());
        this.setTotalUnchanged(dolloParsimony.getTotalUnchanged());
    }

    private void executeFitchParsimony(boolean bl, boolean bl2, boolean bl3, long l) {
        this.reset();
        if (bl2) {
            System.out.println("   Fitch parsimony: use_last = true");
        }
        FitchParsimony<CharacterStateMatrix.BinaryStates> fitchParsimony = new FitchParsimony<CharacterStateMatrix.BinaryStates>();
        fitchParsimony.setRandomize(bl3);
        if (bl3) {
            fitchParsimony.setRandomNumberSeed(l);
        }
        fitchParsimony.setUseLast(bl2);
        fitchParsimony.setReturnGainLossMatrix(true);
        fitchParsimony.setReturnInternalStates(true);
        CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix = null;
        characterStateMatrix = bl ? DomainParsimonyCalculator.createMatrixOfDomainPresenceOrAbsence(this.getGenomeWideCombinableDomainsList()) : DomainParsimonyCalculator.createMatrixOfBinaryDomainCombinationPresenceOrAbsence(this.getGenomeWideCombinableDomainsList());
        fitchParsimony.execute(this.getPhylogeny(), characterStateMatrix);
        this.setGainLossMatrix(fitchParsimony.getGainLossMatrix());
        this.setBinaryInternalStatesMatrix(fitchParsimony.getInternalStatesMatrix());
        this.setCost(fitchParsimony.getCost());
        this.setTotalGains(fitchParsimony.getTotalGains());
        this.setTotalLosses(fitchParsimony.getTotalLosses());
        this.setTotalUnchanged(fitchParsimony.getTotalUnchanged());
    }

    public void executeFitchParsimonyOnBinaryDomainCombintion(boolean bl) {
        this.executeFitchParsimony(false, bl, false, 0L);
    }

    public void executeFitchParsimonyOnBinaryDomainCombintion(long l) {
        this.executeFitchParsimony(false, false, true, l);
    }

    public void executeFitchParsimonyOnDomainPresence(boolean bl) {
        this.executeFitchParsimony(true, bl, false, 0L);
    }

    public void executeFitchParsimonyOnDomainPresence(long l) {
        this.executeFitchParsimony(true, false, true, l);
    }

    public void executeOnGivenBinaryStatesMatrix(CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix, String[] stringArray) {
        this.reset();
        if (characterStateMatrix.getNumberOfCharacters() != stringArray.length) {
            throw new IllegalArgumentException("binary states matrix number of characters is not equal to the number of character labels provided");
        }
        if (characterStateMatrix.getNumberOfIdentifiers() != this.getPhylogeny().getNumberOfBranches()) {
            throw new IllegalArgumentException("binary states matrix number of identifiers is not equal to the number of tree nodes provided");
        }
        BasicCharacterStateMatrix<CharacterStateMatrix.GainLossStates> basicCharacterStateMatrix = new BasicCharacterStateMatrix<CharacterStateMatrix.GainLossStates>(characterStateMatrix.getNumberOfIdentifiers(), characterStateMatrix.getNumberOfCharacters());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = this.getPhylogeny().iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            basicCharacterStateMatrix.setIdentifier(n4++, phylogenyNodeIterator.next().getNodeName());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            basicCharacterStateMatrix.setCharacter(i, stringArray[i]);
            PhylogenyNodeIterator phylogenyNodeIterator2 = this.getPhylogeny().iteratorPostorder();
            while (phylogenyNodeIterator2.hasNext()) {
                PhylogenyNode phylogenyNode = phylogenyNodeIterator2.next();
                String string = phylogenyNode.getNodeName();
                CharacterStateMatrix.BinaryStates binaryStates = characterStateMatrix.getState(characterStateMatrix.getIdentifierIndex(string), i);
                PhylogenyNode phylogenyNode2 = this.getPhylogeny().getNode(string).getParent();
                CharacterStateMatrix.GainLossStates gainLossStates = null;
                if (phylogenyNode.isRoot()) {
                    ++n3;
                    gainLossStates = binaryStates == CharacterStateMatrix.BinaryStates.ABSENT ? CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT : CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
                } else {
                    CharacterStateMatrix.BinaryStates binaryStates2 = characterStateMatrix.getState(characterStateMatrix.getIdentifierIndex(phylogenyNode2.getNodeName()), i);
                    if (binaryStates == CharacterStateMatrix.BinaryStates.ABSENT) {
                        if (binaryStates2 == CharacterStateMatrix.BinaryStates.ABSENT) {
                            ++n3;
                            gainLossStates = CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT;
                        } else {
                            ++n2;
                            gainLossStates = CharacterStateMatrix.GainLossStates.LOSS;
                        }
                    } else if (binaryStates2 == CharacterStateMatrix.BinaryStates.ABSENT) {
                        ++n;
                        gainLossStates = CharacterStateMatrix.GainLossStates.GAIN;
                    } else {
                        ++n3;
                        gainLossStates = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
                    }
                }
                basicCharacterStateMatrix.setState(string, i, gainLossStates);
            }
        }
        this.setTotalGains(n);
        this.setTotalLosses(n2);
        this.setTotalUnchanged(n3);
        this.setCost(n + n2);
        this.setGainLossMatrix(basicCharacterStateMatrix);
    }

    public int getCost() {
        return this._cost;
    }

    private Map<DomainId, Set<String>> getDomainIdToSecondaryFeaturesMap() {
        return this._domain_id_to_secondary_features_map;
    }

    public CharacterStateMatrix<Integer> getGainLossCountsMatrix() {
        int n;
        BasicCharacterStateMatrix<Integer> basicCharacterStateMatrix = new BasicCharacterStateMatrix<Integer>(this.getGainLossMatrix().getNumberOfIdentifiers(), 3);
        for (n = 0; n < this.getGainLossMatrix().getNumberOfIdentifiers(); ++n) {
            basicCharacterStateMatrix.setIdentifier(n, this.getGainLossMatrix().getIdentifier(n));
        }
        basicCharacterStateMatrix.setCharacter(0, "GAINS");
        basicCharacterStateMatrix.setCharacter(1, "LOSSES");
        basicCharacterStateMatrix.setCharacter(2, "NET");
        for (n = 0; n < this.getGainLossMatrix().getNumberOfIdentifiers(); ++n) {
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < this.getGainLossMatrix().getNumberOfCharacters(); ++i) {
                CharacterStateMatrix.GainLossStates gainLossStates = this.getGainLossMatrix().getState(n, i);
                if (gainLossStates == CharacterStateMatrix.GainLossStates.GAIN) {
                    ++n2;
                    continue;
                }
                if (gainLossStates != CharacterStateMatrix.GainLossStates.LOSS) continue;
                ++n3;
            }
            basicCharacterStateMatrix.setState(n, 0, (Integer)n2);
            basicCharacterStateMatrix.setState(n, 1, (Integer)n3);
            basicCharacterStateMatrix.setState(n, 2, (Integer)(n2 - n3));
        }
        return basicCharacterStateMatrix;
    }

    public CharacterStateMatrix<CharacterStateMatrix.GainLossStates> getGainLossMatrix() {
        return this._gain_loss_matrix;
    }

    private List<GenomeWideCombinableDomains> getGenomeWideCombinableDomainsList() {
        return this._gwcd_list;
    }

    public CharacterStateMatrix<CharacterStateMatrix.BinaryStates> getInternalStatesMatrix() {
        return this._binary_internal_states_matrix;
    }

    public int getNetGainsOnNode(String string) {
        if (this.getGainLossMatrix() == null) {
            throw new IllegalStateException("no gain loss matrix has been calculated");
        }
        int n = 0;
        int n2 = this.getGainLossMatrix().getIdentifierIndex(string);
        for (int i = 0; i < this.getGainLossMatrix().getNumberOfCharacters(); ++i) {
            if (this.getGainLossMatrix().getState(n2, i) == CharacterStateMatrix.GainLossStates.GAIN) {
                ++n;
                continue;
            }
            if (this.getGainLossMatrix().getState(n2, i) != CharacterStateMatrix.GainLossStates.LOSS) continue;
            --n;
        }
        return n;
    }

    private Phylogeny getPhylogeny() {
        return this._phylogeny;
    }

    private SortedSet<DomainId> getPositiveFilter() {
        return this._positive_filter;
    }

    public int getSumOfGainsOnNode(String string) {
        return DomainParsimonyCalculator.getStateSumDeltaOnNode(string, this.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN);
    }

    public int getSumOfLossesOnNode(String string) {
        return DomainParsimonyCalculator.getStateSumDeltaOnNode(string, this.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS);
    }

    public int getSumOfPresentOnNode(String string) {
        return this.getSumOfGainsOnNode(string) + this.getSumOfUnchangedPresentOnNode(string);
    }

    int getSumOfUnchangedAbsentOnNode(String string) {
        return DomainParsimonyCalculator.getStateSumDeltaOnNode(string, this.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT);
    }

    int getSumOfUnchangedOnNode(String string) {
        return this.getSumOfUnchangedPresentOnNode(string) + this.getSumOfUnchangedAbsentOnNode(string);
    }

    int getSumOfUnchangedPresentOnNode(String string) {
        return DomainParsimonyCalculator.getStateSumDeltaOnNode(string, this.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT);
    }

    public int getTotalGains() {
        return this._total_gains;
    }

    public int getTotalLosses() {
        return this._total_losses;
    }

    public int getTotalUnchanged() {
        return this._total_unchanged;
    }

    public SortedSet<String> getUnitsGainedOnNode(String string) {
        return DomainParsimonyCalculator.getUnitsDeltaOnNode(string, this.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN);
    }

    public SortedSet<String> getUnitsLostOnNode(String string) {
        return DomainParsimonyCalculator.getUnitsDeltaOnNode(string, this.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS);
    }

    public SortedSet<String> getUnitsOnNode(String string) {
        SortedSet<String> sortedSet = this.getUnitsGainedOnNode(string);
        sortedSet.addAll(this.getUnitsUnchangedPresentOnNode(string));
        return sortedSet;
    }

    SortedSet<String> getUnitsUnchangedAbsentOnNode(String string) {
        return DomainParsimonyCalculator.getUnitsDeltaOnNode(string, this.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT);
    }

    SortedSet<String> getUnitsUnchangedPresentOnNode(String string) {
        return DomainParsimonyCalculator.getUnitsDeltaOnNode(string, this.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT);
    }

    private void init() {
        this.setDomainIdToSecondaryFeaturesMap(null);
        this.setPositiveFilter(null);
        this.reset();
    }

    private void reset() {
        this.setGainLossMatrix(null);
        this.setBinaryInternalStatesMatrix(null);
        this.setCost(-1);
        this.setTotalGains(-1);
        this.setTotalLosses(-1);
        this.setTotalUnchanged(-1);
    }

    private void setBinaryInternalStatesMatrix(CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix) {
        this._binary_internal_states_matrix = characterStateMatrix;
    }

    private void setCost(int n) {
        this._cost = n;
    }

    private void setDomainIdToSecondaryFeaturesMap(Map<DomainId, Set<String>> map) {
        this._domain_id_to_secondary_features_map = map;
    }

    private void setGainLossMatrix(CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix) {
        this._gain_loss_matrix = characterStateMatrix;
    }

    private void setPositiveFilter(SortedSet<DomainId> sortedSet) {
        this._positive_filter = sortedSet;
    }

    private void setTotalGains(int n) {
        this._total_gains = n;
    }

    private void setTotalLosses(int n) {
        this._total_losses = n;
    }

    private void setTotalUnchanged(int n) {
        this._total_unchanged = n;
    }

    public static DomainParsimonyCalculator createInstance(Phylogeny phylogeny) {
        return new DomainParsimonyCalculator(phylogeny);
    }

    public static DomainParsimonyCalculator createInstance(Phylogeny phylogeny, List<GenomeWideCombinableDomains> list) {
        if (phylogeny.getNumberOfExternalNodes() != list.size()) {
            throw new IllegalArgumentException("number of external nodes [" + phylogeny.getNumberOfExternalNodes() + "] does not equal size of genome wide combinable domains list [" + list.size() + "]");
        }
        return new DomainParsimonyCalculator(phylogeny, list);
    }

    public static DomainParsimonyCalculator createInstance(Phylogeny phylogeny, List<GenomeWideCombinableDomains> list, Map<DomainId, Set<String>> map) {
        if (phylogeny.getNumberOfExternalNodes() != list.size()) {
            throw new IllegalArgumentException("size of external nodes does not equal size of genome wide combinable domains list");
        }
        return new DomainParsimonyCalculator(phylogeny, list, map);
    }

    public static CharacterStateMatrix<CharacterStateMatrix.BinaryStates> createMatrixOfBinaryDomainCombinationPresenceOrAbsence(List<GenomeWideCombinableDomains> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("genome wide combinable domains list is empty");
        }
        int n = list.size();
        TreeSet<BinaryDomainCombination> treeSet = new TreeSet<BinaryDomainCombination>();
        HashSet[] hashSetArray = new HashSet[n];
        int n2 = 0;
        for (GenomeWideCombinableDomains object2 : list) {
            hashSetArray[n2] = new HashSet();
            for (BinaryDomainCombination binaryDomainCombination : object2.toBinaryDomainCombinations()) {
                treeSet.add(binaryDomainCombination);
                hashSetArray[n2].add(binaryDomainCombination);
            }
            ++n2;
        }
        int n3 = treeSet.size();
        BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> basicCharacterStateMatrix = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(n, n3);
        int n4 = 0;
        for (BinaryDomainCombination binaryDomainCombination : treeSet) {
            basicCharacterStateMatrix.setCharacter(n4++, ((Object)binaryDomainCombination).toString());
        }
        n2 = 0;
        HashSet<String> hashSet = new HashSet<String>();
        for (GenomeWideCombinableDomains genomeWideCombinableDomains : list) {
            String string = genomeWideCombinableDomains.getSpecies().getSpeciesId();
            if (hashSet.contains(string)) {
                throw new AssertionError((Object)("species [" + string + "] is not unique"));
            }
            hashSet.add(string);
            basicCharacterStateMatrix.setIdentifier(n2, string);
            for (int i = 0; i < basicCharacterStateMatrix.getNumberOfCharacters(); ++i) {
                BinaryDomainCombination binaryDomainCombination = null;
                binaryDomainCombination = genomeWideCombinableDomains.getDomainCombinationType() == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT ? AdjactantDirectedBinaryDomainCombination.createInstance(basicCharacterStateMatrix.getCharacter(i)) : (genomeWideCombinableDomains.getDomainCombinationType() == BinaryDomainCombination.DomainCombinationType.DIRECTED ? DirectedBinaryDomainCombination.createInstance(basicCharacterStateMatrix.getCharacter(i)) : BasicBinaryDomainCombination.createInstance(basicCharacterStateMatrix.getCharacter(i)));
                if (hashSetArray[n2].contains(binaryDomainCombination)) {
                    basicCharacterStateMatrix.setState(n2, i, CharacterStateMatrix.BinaryStates.PRESENT);
                    continue;
                }
                basicCharacterStateMatrix.setState(n2, i, CharacterStateMatrix.BinaryStates.ABSENT);
            }
            ++n2;
        }
        return basicCharacterStateMatrix;
    }

    static CharacterStateMatrix<CharacterStateMatrix.BinaryStates> createMatrixOfDomainPresenceOrAbsence(List<GenomeWideCombinableDomains> list) {
        return DomainParsimonyCalculator.createMatrixOfDomainPresenceOrAbsence(list, null);
    }

    /*
     * WARNING - void declaration
     */
    public static CharacterStateMatrix<CharacterStateMatrix.BinaryStates> createMatrixOfDomainPresenceOrAbsence(List<GenomeWideCombinableDomains> list, SortedSet<DomainId> sortedSet) {
        Object object3;
        if (list.isEmpty()) {
            throw new IllegalArgumentException("genome wide combinable domains list is empty");
        }
        if (sortedSet != null && sortedSet.size() < 1) {
            throw new IllegalArgumentException("positive filter is empty");
        }
        int n = list.size();
        TreeSet<DomainId> treeSet = new TreeSet<DomainId>();
        for (GenomeWideCombinableDomains basicCharacterStateMatrix2 : list) {
            for (DomainId domainId : basicCharacterStateMatrix2.getAllDomainIds()) {
                treeSet.add(domainId);
            }
        }
        int n2 = treeSet.size();
        if (sortedSet != null) {
            n2 = 0;
            for (Object object2 : treeSet) {
                if (!sortedSet.contains(object2)) continue;
                ++n2;
            }
        }
        BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> basicCharacterStateMatrix = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(n, n2);
        int n3 = 0;
        for (Object object3 : treeSet) {
            if (sortedSet == null) {
                basicCharacterStateMatrix.setCharacter(n3++, ((DomainId)object3).getId());
                continue;
            }
            if (!sortedSet.contains(object3)) continue;
            basicCharacterStateMatrix.setCharacter(n3++, ((DomainId)object3).getId());
        }
        boolean bl = false;
        object3 = new HashSet();
        for (GenomeWideCombinableDomains genomeWideCombinableDomains : list) {
            void var7_15;
            String string = genomeWideCombinableDomains.getSpecies().getSpeciesId();
            if (object3.contains(string)) {
                throw new IllegalArgumentException("species [" + string + "] is not unique");
            }
            object3.add(string);
            basicCharacterStateMatrix.setIdentifier((int)var7_15, string);
            for (int i = 0; i < basicCharacterStateMatrix.getNumberOfCharacters(); ++i) {
                if (ForesterUtil.isEmpty(basicCharacterStateMatrix.getCharacter(i))) {
                    throw new IllegalStateException("this should not have happened: problem with character #" + i);
                }
                DomainId domainId = new DomainId(basicCharacterStateMatrix.getCharacter(i));
                if (genomeWideCombinableDomains.contains(domainId)) {
                    basicCharacterStateMatrix.setState((int)var7_15, i, CharacterStateMatrix.BinaryStates.PRESENT);
                    continue;
                }
                basicCharacterStateMatrix.setState((int)var7_15, i, CharacterStateMatrix.BinaryStates.ABSENT);
            }
            ++var7_15;
        }
        return basicCharacterStateMatrix;
    }

    static CharacterStateMatrix<CharacterStateMatrix.BinaryStates> createMatrixOfSecondaryFeaturePresenceOrAbsence(List<GenomeWideCombinableDomains> list, Map<DomainId, Set<String>> map, Map<Species, MappingResults> map2) {
        HashSet<String> hashSet2;
        int n;
        if (list.isEmpty()) {
            throw new IllegalArgumentException("genome wide combinable domains list is empty");
        }
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("domain id to secondary features map is null or empty");
        }
        int n2 = list.size();
        TreeSet treeSet = new TreeSet();
        for (GenomeWideCombinableDomains object2 : list) {
            n = 0;
            int n3 = 0;
            for (DomainId domainId : object2.getAllDomainIds()) {
                if (map.containsKey(domainId)) {
                    treeSet.addAll(map.get(domainId));
                    ++n;
                    continue;
                }
                ++n3;
            }
            if (map2 == null) continue;
            hashSet2 = new MappingResults();
            ((MappingResults)((Object)hashSet2)).setDescription(object2.getSpecies().getSpeciesId());
            ((MappingResults)((Object)hashSet2)).setSumOfSuccesses(n);
            ((MappingResults)((Object)hashSet2)).setSumOfFailures(n3);
            map2.put(object2.getSpecies(), (MappingResults)((Object)hashSet2));
        }
        int n4 = treeSet.size();
        BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> basicCharacterStateMatrix = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(n2, n4);
        n = 0;
        for (HashSet<String> hashSet2 : treeSet) {
            basicCharacterStateMatrix.setCharacter(n++, (String)((Object)hashSet2));
        }
        int n5 = 0;
        hashSet2 = new HashSet<String>();
        for (GenomeWideCombinableDomains genomeWideCombinableDomains : list) {
            String string = genomeWideCombinableDomains.getSpecies().getSpeciesId();
            if (hashSet2.contains(string)) {
                throw new IllegalArgumentException("species [" + string + "] is not unique");
            }
            hashSet2.add(string);
            basicCharacterStateMatrix.setIdentifier(n5, string);
            HashSet hashSet3 = new HashSet();
            for (DomainId domainId : genomeWideCombinableDomains.getAllDomainIds()) {
                if (!map.containsKey(domainId)) continue;
                hashSet3.addAll(map.get(domainId));
            }
            for (int i = 0; i < basicCharacterStateMatrix.getNumberOfCharacters(); ++i) {
                if (hashSet3.contains(basicCharacterStateMatrix.getCharacter(i))) {
                    basicCharacterStateMatrix.setState(n5, i, CharacterStateMatrix.BinaryStates.PRESENT);
                    continue;
                }
                basicCharacterStateMatrix.setState(n5, i, CharacterStateMatrix.BinaryStates.ABSENT);
            }
            ++n5;
        }
        return basicCharacterStateMatrix;
    }

    private static int getStateSumDeltaOnNode(String string, CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix, CharacterStateMatrix.GainLossStates gainLossStates) {
        if (characterStateMatrix == null) {
            throw new IllegalStateException("no gain loss matrix has been calculated");
        }
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("node identifier must not be empty");
        }
        if (characterStateMatrix.isEmpty()) {
            throw new IllegalStateException("gain loss matrix is empty");
        }
        int n = 0;
        int n2 = characterStateMatrix.getIdentifierIndex(string);
        for (int i = 0; i < characterStateMatrix.getNumberOfCharacters(); ++i) {
            if (characterStateMatrix.getState(n2, i) != gainLossStates) continue;
            ++n;
        }
        return n;
    }

    private static SortedSet<String> getUnitsDeltaOnNode(String string, CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix, CharacterStateMatrix.GainLossStates gainLossStates) {
        if (characterStateMatrix == null) {
            throw new IllegalStateException("no gain loss matrix has been calculated");
        }
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("node identifier must not be empty");
        }
        if (characterStateMatrix.isEmpty()) {
            throw new IllegalStateException("gain loss matrix is empty");
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = characterStateMatrix.getIdentifierIndex(string);
        for (int i = 0; i < characterStateMatrix.getNumberOfCharacters(); ++i) {
            if (characterStateMatrix.getState(n, i) != gainLossStates) continue;
            if (treeSet.contains(characterStateMatrix.getCharacter(i))) {
                throw new AssertionError((Object)("this should not have happended: character [" + characterStateMatrix.getCharacter(i) + "] already in set"));
            }
            treeSet.add(characterStateMatrix.getCharacter(i));
        }
        return treeSet;
    }
}

