/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoTerm;
import org.forester.phylogenyinference.BasicSymmetricalDistanceMatrix;
import org.forester.phylogenyinference.DistanceMatrix;
import org.forester.surfacing.BasicDomainSimilarityCalculator;
import org.forester.surfacing.DomainArchitectureBasedGenomeSimilarityCalculator;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.PairwiseDomainSimilarityCalculator;
import org.forester.surfacing.PrintableDomainSimilarity;
import org.forester.surfacing.Species;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairwiseGenomeComparator {
    private List<DistanceMatrix> _domain_distance_scores_means;
    private List<DistanceMatrix> _shared_domains_based_distances;
    private List<DistanceMatrix> _shared_binary_combinations_based_distances;

    public PairwiseGenomeComparator() {
        this.init();
    }

    public List<DistanceMatrix> getDomainDistanceScoresMeans() {
        return this._domain_distance_scores_means;
    }

    public List<DistanceMatrix> getSharedBinaryCombinationsBasedDistances() {
        return this._shared_binary_combinations_based_distances;
    }

    public List<DistanceMatrix> getSharedDomainsBasedDistances() {
        return this._shared_domains_based_distances;
    }

    private void init() {
        this._domain_distance_scores_means = new ArrayList<DistanceMatrix>();
        this._shared_domains_based_distances = new ArrayList<DistanceMatrix>();
        this._shared_binary_combinations_based_distances = new ArrayList<DistanceMatrix>();
    }

    public void performPairwiseComparisons(StringBuilder stringBuilder, boolean bl, DomainSimilarityCalculator.Detailedness detailedness, boolean bl2, boolean bl3, DomainSimilarity.DomainSimilaritySortField domainSimilaritySortField, PrintableDomainSimilarity.PRINT_OPTION pRINT_OPTION, DomainSimilarity.DomainSimilarityScoring domainSimilarityScoring, Map<DomainId, List<GoId>> map, Map<GoId, GoTerm> map2, GoNameSpace goNameSpace, Species[] speciesArray, int n, List<GenomeWideCombinableDomains> list, PairwiseDomainSimilarityCalculator pairwiseDomainSimilarityCalculator, String string, boolean bl4, String string2, String string3, boolean bl5, File file, boolean bl6) {
        this.init();
        BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix = new BasicSymmetricalDistanceMatrix(n);
        BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix2 = new BasicSymmetricalDistanceMatrix(n);
        BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix3 = new BasicSymmetricalDistanceMatrix(n);
        if (bl4) {
            System.out.println();
            System.out.println("Pairwise genome distances:");
            System.out.print("[species-i - species-j:");
            System.out.print(" mean-score-based");
            System.out.print(" (sd)");
            System.out.print(" [N]");
            System.out.print(" | shared-domains-based");
            System.out.println(" | shared-binary-combinations-based]");
            System.out.println();
        }
        for (int i = 0; i < n; ++i) {
            String string4 = speciesArray[i].getSpeciesId();
            basicSymmetricalDistanceMatrix.setIdentifier(i, string4);
            basicSymmetricalDistanceMatrix2.setIdentifier(i, string4);
            basicSymmetricalDistanceMatrix3.setIdentifier(i, string4);
            if (bl4) {
                System.out.println(i + 1 + "/" + n);
            }
            for (int j = 0; j < i; ++j) {
                if (list.get(i).getSize() < 1 || list.get(j).getSize() < 1) {
                    basicSymmetricalDistanceMatrix.setValue(i, j, 1.0);
                    basicSymmetricalDistanceMatrix2.setValue(i, j, 1.0);
                    basicSymmetricalDistanceMatrix3.setValue(i, j, 1.0);
                    continue;
                }
                ArrayList<GenomeWideCombinableDomains> arrayList = new ArrayList<GenomeWideCombinableDomains>(2);
                arrayList.add(list.get(i));
                arrayList.add(list.get(j));
                DomainSimilarityCalculator.GoAnnotationOutput goAnnotationOutput = DomainSimilarityCalculator.GoAnnotationOutput.NONE;
                if (map != null) {
                    goAnnotationOutput = DomainSimilarityCalculator.GoAnnotationOutput.ALL;
                }
                BasicDomainSimilarityCalculator basicDomainSimilarityCalculator = new BasicDomainSimilarityCalculator(domainSimilaritySortField, bl, true);
                SortedSet<DomainSimilarity> sortedSet = basicDomainSimilarityCalculator.calculateSimilarities(pairwiseDomainSimilarityCalculator, arrayList, bl2, bl3);
                SurfacingUtil.decoratePrintableDomainSimilarities(sortedSet, detailedness, goAnnotationOutput, map2, goNameSpace);
                DescriptiveStatistics descriptiveStatistics = SurfacingUtil.calculateDescriptiveStatisticsForMeanValues(sortedSet);
                String string5 = speciesArray[j].getSpeciesId();
                DomainArchitectureBasedGenomeSimilarityCalculator domainArchitectureBasedGenomeSimilarityCalculator = new DomainArchitectureBasedGenomeSimilarityCalculator(list.get(i), list.get(j));
                domainArchitectureBasedGenomeSimilarityCalculator.setAllowDomainsToBeIgnored(false);
                double d = descriptiveStatistics.getN() < 1 ? 1.0 : 1.0 - descriptiveStatistics.arithmeticMean();
                double d2 = 1.0 - domainArchitectureBasedGenomeSimilarityCalculator.calculateSharedDomainsBasedGenomeSimilarityScore();
                double d3 = 1.0 - domainArchitectureBasedGenomeSimilarityCalculator.calculateSharedBinaryDomainCombinationBasedGenomeSimilarityScore();
                basicSymmetricalDistanceMatrix.setValue(i, j, d);
                basicSymmetricalDistanceMatrix2.setValue(i, j, d2);
                basicSymmetricalDistanceMatrix3.setValue(i, j, d3);
                if (bl4) {
                    System.out.print(string4 + "-");
                    System.out.print(string5 + ": ");
                    System.out.print(ForesterUtil.round(d, 2));
                    if (descriptiveStatistics.getN() > 1) {
                        System.out.print(" (" + ForesterUtil.round(descriptiveStatistics.sampleStandardDeviation(), 2) + ")");
                    } else {
                        System.out.print(" (n/a)");
                    }
                    System.out.print(" [" + descriptiveStatistics.getN() + "]");
                    System.out.print(" | ");
                    System.out.print(ForesterUtil.round(d2, 2));
                    System.out.print(" | ");
                    System.out.println(ForesterUtil.round(d3, 2));
                }
                String string6 = string2 + string4 + "_" + string5 + string;
                switch (pRINT_OPTION) {
                    case HTML: {
                        if (string6.endsWith(".html")) break;
                        string6 = string6 + ".html";
                    }
                }
                DescriptiveStatistics descriptiveStatistics2 = null;
                if (bl6) {
                    try {
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file == null ? string6 : file + ForesterUtil.FILE_SEPARATOR + string6));
                        descriptiveStatistics2 = SurfacingUtil.writeDomainSimilaritiesToFile(stringBuilder, new StringBuilder(string4 + "-" + string5), bufferedWriter, sortedSet, true, null, pRINT_OPTION, domainSimilaritySortField, domainSimilarityScoring, false);
                    }
                    catch (IOException iOException) {
                        ForesterUtil.fatalError(string3, "Failed to write similarites to: \"" + string6 + "\" [" + iOException.getMessage() + "]");
                    }
                }
                if (descriptiveStatistics2 == null) continue;
                if (descriptiveStatistics2.getMin() >= descriptiveStatistics2.getMax()) {
                    ForesterUtil.printWarningMessage(string3, "for [" + string4 + "-" + string5 + "] score minimum is [" + descriptiveStatistics2.getMin() + "] while score maximum is [" + descriptiveStatistics2.getMax() + "], possibly indicating that a genome is compared to itself");
                }
                if (bl5 && !(descriptiveStatistics2.getMin() < descriptiveStatistics2.getMax())) continue;
            }
        }
        this.getDomainDistanceScoresMeans().add(basicSymmetricalDistanceMatrix);
        this.getSharedDomainsBasedDistances().add(basicSymmetricalDistanceMatrix2);
        this.getSharedBinaryCombinationsBasedDistances().add(basicSymmetricalDistanceMatrix3);
        if (bl4) {
            System.out.println();
        }
    }

    public void performPairwiseComparisonsJacknifed(Species[] speciesArray, int n, List<GenomeWideCombinableDomains> list, boolean bl, int n2, double d, long l) {
        this.init();
        if (n2 < 2) {
            throw new IllegalArgumentException("attempt to perform jacknife resampling with less than 2 resamplings");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("attempt to perform jacknife resampling with jacknife ratio of 0.0 or less");
        }
        if (d >= 1.0) {
            throw new IllegalArgumentException("attempt to perform jacknife resampling with jacknife ratio 1.0 or more");
        }
        DomainId[] domainIdArray = PairwiseGenomeComparator.getAllUniqueDomainIdAsArray(list);
        if (bl) {
            System.out.println();
            System.out.println("Jacknife: total of domains: " + domainIdArray.length);
        }
        if (bl) {
            System.out.print("resampling ");
        }
        Random random = new Random(l);
        for (int i = 0; i < n2; ++i) {
            if (bl) {
                System.out.print(" " + i);
            }
            SortedSet<DomainId> sortedSet = PairwiseGenomeComparator.randomlyPickDomainIds(domainIdArray, d, random);
            BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix = new BasicSymmetricalDistanceMatrix(n);
            BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix2 = new BasicSymmetricalDistanceMatrix(n);
            for (int j = 0; j < n; ++j) {
                String string = speciesArray[j].getSpeciesId();
                basicSymmetricalDistanceMatrix.setIdentifier(j, string);
                basicSymmetricalDistanceMatrix2.setIdentifier(j, string);
                for (int k = 0; k < j; ++k) {
                    ArrayList<GenomeWideCombinableDomains> arrayList = new ArrayList<GenomeWideCombinableDomains>(2);
                    arrayList.add(list.get(j));
                    arrayList.add(list.get(k));
                    DomainArchitectureBasedGenomeSimilarityCalculator domainArchitectureBasedGenomeSimilarityCalculator = new DomainArchitectureBasedGenomeSimilarityCalculator(list.get(j), list.get(k));
                    domainArchitectureBasedGenomeSimilarityCalculator.setAllowDomainsToBeIgnored(true);
                    domainArchitectureBasedGenomeSimilarityCalculator.setDomainIdsToIgnore(sortedSet);
                    basicSymmetricalDistanceMatrix.setValue(j, k, 1.0 - domainArchitectureBasedGenomeSimilarityCalculator.calculateSharedDomainsBasedGenomeSimilarityScore());
                    basicSymmetricalDistanceMatrix2.setValue(j, k, 1.0 - domainArchitectureBasedGenomeSimilarityCalculator.calculateSharedBinaryDomainCombinationBasedGenomeSimilarityScore());
                }
            }
            this.getSharedDomainsBasedDistances().add(basicSymmetricalDistanceMatrix);
            this.getSharedBinaryCombinationsBasedDistances().add(basicSymmetricalDistanceMatrix2);
        }
        if (bl) {
            System.out.println();
        }
    }

    private static DomainId[] getAllUniqueDomainIdAsArray(List<GenomeWideCombinableDomains> list) {
        TreeSet<DomainId> treeSet = new TreeSet<DomainId>();
        for (GenomeWideCombinableDomains object : list) {
            SortedSet<DomainId> sortedSet = object.getAllDomainIds();
            for (DomainId domainId : sortedSet) {
                treeSet.add(domainId);
            }
        }
        DomainId[] domainIdArray = new DomainId[treeSet.size()];
        int n = 0;
        for (DomainId domainId : treeSet) {
            domainIdArray[n++] = domainId;
        }
        return domainIdArray;
    }

    private static SortedSet<DomainId> randomlyPickDomainIds(DomainId[] domainIdArray, double d, Random random) {
        int n = domainIdArray.length;
        TreeSet<DomainId> treeSet = new TreeSet<DomainId>();
        int n2 = ForesterUtil.roundToInt(d * (double)n);
        while (treeSet.size() < n2) {
            int n3 = random.nextInt(n);
            treeSet.add(domainIdArray[n3]);
        }
        return treeSet;
    }
}

