/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.SpeciesSpecificDomainSimilariyData;
import org.forester.util.DescriptiveStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PrintableSpeciesSpecificDomainSimilariyData
implements SpeciesSpecificDomainSimilariyData {
    private static final NumberFormat FORMATTER = new DecimalFormat("0.0E0");
    final SortedMap<DomainId, Integer> _combinable_domain_id_to_count_map;
    private final int _key_domain_proteins_count;
    private final int _key_domain_domains_count;
    private final int _combinable_domains_count;
    private final DescriptiveStatistics _key_domain_confidence_descriptive_statistics;

    public PrintableSpeciesSpecificDomainSimilariyData(int n, int n2, int n3, DescriptiveStatistics descriptiveStatistics) {
        this._key_domain_proteins_count = n;
        this._key_domain_domains_count = n2;
        this._combinable_domains_count = n3;
        this._key_domain_confidence_descriptive_statistics = descriptiveStatistics;
        this._combinable_domain_id_to_count_map = new TreeMap<DomainId, Integer>();
    }

    @Override
    public void addProteinsExhibitingCombinationCount(DomainId domainId, int n) {
        if (this.getCombinableDomainIdToCountsMap().containsKey(domainId)) {
            throw new IllegalArgumentException("Domain with id " + domainId + " already exists");
        }
        this.getCombinableDomainIdToCountsMap().put(domainId, n);
    }

    @Override
    public SortedMap<DomainId, Integer> getCombinableDomainIdToCountsMap() {
        return this._combinable_domain_id_to_count_map;
    }

    private int getCombinableDomainsCount() {
        return this._combinable_domains_count;
    }

    private DescriptiveStatistics getKeyDomainConfidenceDescriptiveStatistics() {
        return this._key_domain_confidence_descriptive_statistics;
    }

    private int getKeyDomainDomainsCount() {
        return this._key_domain_domains_count;
    }

    private int getKeyDomainProteinsCount() {
        return this._key_domain_proteins_count;
    }

    @Override
    public int getNumberOfProteinsExhibitingCombinationWith(DomainId domainId) {
        if (!this.getCombinableDomainIdToCountsMap().containsKey(domainId)) {
            throw new IllegalArgumentException("Domain with id " + domainId + " not found");
        }
        return (Integer)this.getCombinableDomainIdToCountsMap().get(domainId);
    }

    public String toString() {
        return this.toStringBuffer(DomainSimilarityCalculator.Detailedness.LIST_COMBINING_DOMAIN_FOR_EACH_SPECIES, false).toString();
    }

    @Override
    public StringBuffer toStringBuffer(DomainSimilarityCalculator.Detailedness detailedness, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (detailedness == DomainSimilarityCalculator.Detailedness.PUNCTILIOUS) {
            stringBuffer.append(" ");
            stringBuffer.append(this.getKeyDomainDomainsCount());
            stringBuffer.append(", ");
            stringBuffer.append(this.getKeyDomainProteinsCount());
            stringBuffer.append(", ");
            stringBuffer.append(this.getCombinableDomainsCount());
            stringBuffer.append(", ");
            if (bl) {
                stringBuffer.append("<i>");
            }
            stringBuffer.append(FORMATTER.format(this.getKeyDomainConfidenceDescriptiveStatistics().arithmeticMean()));
            if (bl) {
                stringBuffer.append("</i>");
            }
            if (!this.getCombinableDomainIdToCountsMap().isEmpty()) {
                stringBuffer.append(":");
            }
        }
        Set<DomainId> set = this.getCombinableDomainIdToCountsMap().keySet();
        int n = 0;
        for (DomainId domainId : set) {
            ++n;
            stringBuffer.append(" ");
            if (bl) {
                stringBuffer.append("<a href=\"http://pfam.sanger.ac.uk/family?id=" + domainId.getId() + "\">" + domainId.getId() + "</a>");
            } else {
                stringBuffer.append(domainId.getId());
            }
            if (detailedness == DomainSimilarityCalculator.Detailedness.PUNCTILIOUS) {
                stringBuffer.append(":");
                stringBuffer.append(this.getCombinableDomainIdToCountsMap().get(domainId));
            }
            if (n >= set.size() - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer;
    }
}

