/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProteinId
implements Comparable<ProteinId> {
    private final String _id;

    public ProteinId(String string) {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("attempt to create new protein id from empty or null string");
        }
        this._id = string.trim();
    }

    @Override
    public int compareTo(ProteinId proteinId) {
        if (this == proteinId) {
            return 0;
        }
        return this.getId().toLowerCase().compareTo(proteinId.getId().toLowerCase());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            throw new IllegalArgumentException("attempt to check protein id equality to null");
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check protein id equality to " + object + " [" + object.getClass() + "]");
        }
        return this.getId().equals(((ProteinId)object).getId());
    }

    public String getId() {
        return this._id;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getId();
    }
}

