/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoTerm;
import org.forester.go.GoUtils;
import org.forester.go.PfamToGoMapping;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogenyinference.BasicCharacterStateMatrix;
import org.forester.phylogenyinference.CharacterStateMatrix;
import org.forester.phylogenyinference.DistanceMatrix;
import org.forester.phylogenyinference.NeighborJoining;
import org.forester.surfacing.AdjactantDirectedBinaryDomainCombination;
import org.forester.surfacing.BasicBinaryDomainCombination;
import org.forester.surfacing.BasicDomain;
import org.forester.surfacing.BasicProtein;
import org.forester.surfacing.BinaryDomainCombination;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.DirectedBinaryDomainCombination;
import org.forester.surfacing.Domain;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.DomainLengths;
import org.forester.surfacing.DomainLengthsTable;
import org.forester.surfacing.DomainParsimonyCalculator;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.MappingResults;
import org.forester.surfacing.PrintableDomainSimilarity;
import org.forester.surfacing.Protein;
import org.forester.surfacing.Species;
import org.forester.surfacing.SurfacingConstants;
import org.forester.util.AsciiHistogram;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SurfacingUtil {
    private static final NumberFormat FORMATTER = new DecimalFormat("0.0E0");
    private static final NumberFormat FORMATTER_3 = new DecimalFormat("0.000");
    private static final Comparator<Domain> ASCENDING_CONFIDENCE_VALUE_ORDER = new Comparator<Domain>(){

        @Override
        public int compare(Domain domain, Domain domain2) {
            if (domain.getPerSequenceEvalue() < domain2.getPerSequenceEvalue()) {
                return -1;
            }
            if (domain.getPerSequenceEvalue() > domain2.getPerSequenceEvalue()) {
                return 1;
            }
            return domain.compareTo(domain2);
        }
    };
    public static final Pattern PATTERN_SP_STYLE_TAXONOMY = Pattern.compile("^[A-Z0-9]{3,5}$");

    private SurfacingUtil() {
    }

    public static void addAllBinaryDomainCombinationToSet(GenomeWideCombinableDomains genomeWideCombinableDomains, SortedSet<BinaryDomainCombination> sortedSet) {
        SortedMap<DomainId, CombinableDomains> sortedMap = genomeWideCombinableDomains.getAllCombinableDomainsIds();
        for (DomainId domainId : sortedMap.keySet()) {
            sortedSet.addAll(((CombinableDomains)sortedMap.get(domainId)).toBinaryDomainCombinations());
        }
    }

    public static void addAllDomainIdsToSet(GenomeWideCombinableDomains genomeWideCombinableDomains, SortedSet<DomainId> sortedSet) {
        SortedSet<DomainId> sortedSet2 = genomeWideCombinableDomains.getAllDomainIds();
        for (DomainId domainId : sortedSet2) {
            sortedSet.add(domainId);
        }
    }

    public static void addHtmlHead(Writer writer, String string) throws IOException {
        writer.write(SurfacingConstants.NL);
        writer.write("<head>");
        writer.write("<title>");
        writer.write(string);
        writer.write("</title>");
        writer.write(SurfacingConstants.NL);
        writer.write("<style>");
        writer.write(SurfacingConstants.NL);
        writer.write("a:visited { color : #6633FF; text-decoration : none; }");
        writer.write(SurfacingConstants.NL);
        writer.write("a:link { color : #6633FF; text-decoration : none; }");
        writer.write(SurfacingConstants.NL);
        writer.write("a:active { color : #99FF00; text-decoration : none; }");
        writer.write(SurfacingConstants.NL);
        writer.write("a:hover { color : #FFFFFF; background-color : #99FF00; text-decoration : none; }");
        writer.write(SurfacingConstants.NL);
        writer.write("td { text-align: left; vertical-align: top; font-family: Verdana, Arial, Helvetica; font-size: 8pt}");
        writer.write(SurfacingConstants.NL);
        writer.write("h1 { color : #0000FF; font-family: Verdana, Arial, Helvetica; font-size: 18pt; font-weight: bold }");
        writer.write(SurfacingConstants.NL);
        writer.write("h2 { color : #0000FF; font-family: Verdana, Arial, Helvetica; font-size: 16pt; font-weight: bold }");
        writer.write(SurfacingConstants.NL);
        writer.write("</style>");
        writer.write(SurfacingConstants.NL);
        writer.write("</head>");
        writer.write(SurfacingConstants.NL);
    }

    public static DescriptiveStatistics calculateDescriptiveStatisticsForMeanValues(Set<DomainSimilarity> set) {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (DomainSimilarity domainSimilarity : set) {
            basicDescriptiveStatistics.addValue(domainSimilarity.getMeanSimilarityScore());
        }
        return basicDescriptiveStatistics;
    }

    public static int calculateOverlap(Domain domain, List<Boolean> list) {
        int n = 0;
        for (int i = domain.getFrom(); i <= domain.getTo(); ++i) {
            if (i >= list.size() || !list.get(i).booleanValue()) continue;
            ++n;
        }
        return n;
    }

    public static void checkForOutputFileWriteability(File file) {
        String string = ForesterUtil.isWritableFile(file);
        if (!ForesterUtil.isEmpty(string)) {
            ForesterUtil.fatalError("surfacing", string);
        }
    }

    private static SortedSet<String> collectAllDomainsChangedOnSubtree(PhylogenyNode phylogenyNode, boolean bl) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (PhylogenyNode phylogenyNode2 : PhylogenyMethods.getAllDescendants(phylogenyNode)) {
            BinaryCharacters binaryCharacters = phylogenyNode2.getNodeData().getBinaryCharacters();
            if (bl) {
                treeSet.addAll(binaryCharacters.getGainedCharacters());
                continue;
            }
            treeSet.addAll(binaryCharacters.getLostCharacters());
        }
        return treeSet;
    }

    public static void collectChangedDomainCombinationsFromBinaryStatesMatrixAsListToFile(CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix, BinaryDomainCombination.DomainCombinationType domainCombinationType, List<BinaryDomainCombination> list, boolean bl) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < characterStateMatrix.getNumberOfIdentifiers(); ++i) {
            treeSet.add(characterStateMatrix.getIdentifier(i));
        }
        for (String string : treeSet) {
            for (int i = 0; i < characterStateMatrix.getNumberOfCharacters(); ++i) {
                if ((!bl || characterStateMatrix.getState(string, i) != CharacterStateMatrix.GainLossStates.GAIN) && (bl || characterStateMatrix.getState(string, i) != CharacterStateMatrix.GainLossStates.LOSS)) continue;
                if (domainCombinationType == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT) {
                    list.add(AdjactantDirectedBinaryDomainCombination.createInstance(characterStateMatrix.getCharacter(i)));
                    continue;
                }
                if (domainCombinationType == BinaryDomainCombination.DomainCombinationType.DIRECTED) {
                    list.add(DirectedBinaryDomainCombination.createInstance(characterStateMatrix.getCharacter(i)));
                    continue;
                }
                list.add(BasicBinaryDomainCombination.createInstance(characterStateMatrix.getCharacter(i)));
            }
        }
    }

    private static File createBaseDirForPerNodeDomainFiles(String string, boolean bl, CharacterStateMatrix.GainLossStates gainLossStates, String string2) {
        File file = new File(new File(string2).getParent() + ForesterUtil.FILE_SEPARATOR + string);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(file = bl ? new File(file + ForesterUtil.FILE_SEPARATOR + "DC") : new File(file + ForesterUtil.FILE_SEPARATOR + "DOMAINS")).exists()) {
            file.mkdir();
        }
        if (!(file = gainLossStates == CharacterStateMatrix.GainLossStates.GAIN ? new File(file + ForesterUtil.FILE_SEPARATOR + "GAINS") : (gainLossStates == CharacterStateMatrix.GainLossStates.LOSS ? new File(file + ForesterUtil.FILE_SEPARATOR + "LOSSES") : new File(file + ForesterUtil.FILE_SEPARATOR + "PRESENT"))).exists()) {
            file.mkdir();
        }
        return file;
    }

    public static Map<DomainId, List<GoId>> createDomainIdToGoIdMap(List<PfamToGoMapping> list) {
        HashMap<DomainId, List<GoId>> hashMap = new HashMap<DomainId, List<GoId>>(list.size());
        for (PfamToGoMapping pfamToGoMapping : list) {
            if (!hashMap.containsKey(pfamToGoMapping.getKey())) {
                hashMap.put(pfamToGoMapping.getKey(), new ArrayList());
            }
            ((List)hashMap.get(pfamToGoMapping.getKey())).add(pfamToGoMapping.getValue());
        }
        return hashMap;
    }

    public static Map<DomainId, Set<String>> createDomainIdToSecondaryFeaturesMap(File file) throws IOException {
        BasicTable<String> basicTable = BasicTableParser.parse(file, "\t");
        TreeMap<DomainId, Set<String>> treeMap = new TreeMap<DomainId, Set<String>>();
        for (int i = 0; i < basicTable.getNumberOfRows(); ++i) {
            DomainId domainId = new DomainId(basicTable.getValue(0, i));
            if (!treeMap.containsKey(domainId)) {
                treeMap.put(domainId, new HashSet());
            }
            ((Set)treeMap.get(domainId)).add(basicTable.getValue(1, i));
        }
        return treeMap;
    }

    public static Phylogeny createNjTreeBasedOnMatrixToFile(File file, DistanceMatrix distanceMatrix) {
        SurfacingUtil.checkForOutputFileWriteability(file);
        NeighborJoining neighborJoining = NeighborJoining.createInstance();
        Phylogeny phylogeny = neighborJoining.execute(distanceMatrix);
        phylogeny.setName(file.getName());
        SurfacingUtil.writePhylogenyToFile(phylogeny, file.toString());
        return phylogeny;
    }

    private static SortedSet<BinaryDomainCombination> createSetOfAllBinaryDomainCombinationsPerGenome(GenomeWideCombinableDomains genomeWideCombinableDomains) {
        SortedMap<DomainId, CombinableDomains> sortedMap = genomeWideCombinableDomains.getAllCombinableDomainsIds();
        TreeSet<BinaryDomainCombination> treeSet = new TreeSet<BinaryDomainCombination>();
        for (DomainId domainId : sortedMap.keySet()) {
            CombinableDomains combinableDomains = (CombinableDomains)sortedMap.get(domainId);
            treeSet.addAll(combinableDomains.toBinaryDomainCombinations());
        }
        return treeSet;
    }

    public static void decoratePrintableDomainSimilarities(SortedSet<DomainSimilarity> sortedSet, DomainSimilarityCalculator.Detailedness detailedness, DomainSimilarityCalculator.GoAnnotationOutput goAnnotationOutput, Map<GoId, GoTerm> map, GoNameSpace goNameSpace) {
        if (goNameSpace != null && (map == null || map.isEmpty())) {
            throw new IllegalArgumentException("attempt to use a GO namespace limit without a GO id to term map");
        }
        for (DomainSimilarity domainSimilarity : sortedSet) {
            if (!(domainSimilarity instanceof PrintableDomainSimilarity)) continue;
            PrintableDomainSimilarity printableDomainSimilarity = (PrintableDomainSimilarity)domainSimilarity;
            printableDomainSimilarity.setDetailedness(detailedness);
            printableDomainSimilarity.setGoAnnotationOutput(goAnnotationOutput);
            printableDomainSimilarity.setGoIdToTermMap(map);
            printableDomainSimilarity.setGoNamespaceLimit(goNameSpace);
        }
    }

    public static void executeDomainLengthAnalysis(String[][] stringArray, int n, DomainLengthsTable domainLengthsTable, File file) throws IOException {
        DecimalFormat decimalFormat = new DecimalFormat("#.00");
        SurfacingUtil.checkForOutputFileWriteability(file);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write("MEAN BASED STATISTICS PER SPECIES");
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        bufferedWriter.write(domainLengthsTable.createMeanBasedStatisticsPerSpeciesTable().toString());
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        List<DomainLengths> list = domainLengthsTable.getDomainLengthsList();
        bufferedWriter.write("OUTLIER SPECIES PER DOMAIN (Z>=1.5)");
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        for (DomainLengths object2 : list) {
            List<Species> d = object2.getMeanBasedOutlierSpecies(1.5);
            if (d.size() <= 0) continue;
            bufferedWriter.write(object2.getDomainId() + "\t");
            for (Species d2 : d) {
                bufferedWriter.write(d2 + "\t");
            }
            bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        }
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        bufferedWriter.write("OUTLIER SPECIES (Z 1.0)");
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        DescriptiveStatistics descriptiveStatistics = domainLengthsTable.calculateMeanBasedStatisticsForAllSpecies();
        bufferedWriter.write(descriptiveStatistics.asSummary());
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        AsciiHistogram asciiHistogram = new AsciiHistogram(descriptiveStatistics);
        bufferedWriter.write(asciiHistogram.toStringBuffer(40, '=', 60, 4).toString());
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        double d = descriptiveStatistics.sampleStandardDeviation();
        double d2 = descriptiveStatistics.arithmeticMean();
        for (Species species : domainLengthsTable.getSpecies()) {
            double descriptiveStatistics2 = domainLengthsTable.calculateMeanBasedStatisticsForSpecies(species).arithmeticMean();
            double d3 = (descriptiveStatistics2 - d2) / d;
            bufferedWriter.write(species + "\t" + d3);
            bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        }
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        for (Species species : domainLengthsTable.getSpecies()) {
            DescriptiveStatistics descriptiveStatistics2 = domainLengthsTable.calculateMeanBasedStatisticsForSpecies(species);
            double d4 = descriptiveStatistics2.arithmeticMean();
            double d5 = (d4 - d2) / d;
            if (!(d5 <= -1.0) && !(d5 >= 1.0)) continue;
            bufferedWriter.write(species + "\t" + decimalFormat.format(d5) + "\t" + descriptiveStatistics2.asSummary());
            bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        }
        bufferedWriter.close();
        System.gc();
    }

    public static void executeParsimonyAnalysis(long l, boolean bl, String string, DomainParsimonyCalculator domainParsimonyCalculator, Phylogeny phylogeny, Map<DomainId, List<GoId>> map, Map<GoId, GoTerm> map2, GoNameSpace goNameSpace, String string2, Map<DomainId, Set<String>>[] mapArray, SortedSet<DomainId> sortedSet, boolean bl2, List<BinaryDomainCombination> list, List<BinaryDomainCombination> list2, BinaryDomainCombination.DomainCombinationType domainCombinationType) {
        String string3 = ForesterUtil.LINE_SEPARATOR + "###################" + ForesterUtil.LINE_SEPARATOR;
        String string4 = ForesterUtil.getCurrentDateTime();
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        TreeSet<String> treeSet3 = new TreeSet<String>();
        TreeSet<String> treeSet4 = new TreeSet<String>();
        TreeSet<String> treeSet5 = new TreeSet<String>();
        SurfacingUtil.writeToNexus(string, domainParsimonyCalculator, phylogeny);
        Phylogeny phylogeny2 = phylogeny.copy();
        if (sortedSet != null && sortedSet.size() > 0) {
            domainParsimonyCalculator.executeDolloParsimonyOnDomainPresence(sortedSet);
        } else {
            domainParsimonyCalculator.executeDolloParsimonyOnDomainPresence();
        }
        SurfacingUtil.writeMatrixToFile(domainParsimonyCalculator.getGainLossMatrix(), string + "_dollo_gl_d", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeMatrixToFile(domainParsimonyCalculator.getGainLossCountsMatrix(), string + "_dollo_glc_d", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, string + "_dollo_gains_d", string3, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, string + "_dollo_losses_d", string3, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), null, string + "_dollo_present_d", string3, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixToList(map, map2, goNameSpace, false, domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, string + "_dollo_gains_d.html", string3, ForesterUtil.LINE_SEPARATOR, "Dollo Parsimony | Gains | Domains", "+", mapArray, treeSet, treeSet2, "_dollo_gains_d");
        SurfacingUtil.writeBinaryStatesMatrixToList(map, map2, goNameSpace, false, domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, string + "_dollo_losses_d.html", string3, ForesterUtil.LINE_SEPARATOR, "Dollo Parsimony | Losses | Domains", "-", mapArray, treeSet, treeSet3, "_dollo_losses_d");
        SurfacingUtil.writeBinaryStatesMatrixToList(map, map2, goNameSpace, false, domainParsimonyCalculator.getGainLossMatrix(), null, string + "_dollo_present_d.html", string3, ForesterUtil.LINE_SEPARATOR, "Dollo Parsimony | Present | Domains", "", mapArray, treeSet, null, "_dollo_present_d");
        SurfacingUtil.preparePhylogeny(phylogeny2, domainParsimonyCalculator, string4, "Dollo parsimony on domain presence/absence", "dollo_on_domains_" + string, string2);
        SurfacingUtil.writePhylogenyToFile(phylogeny2, string + "_d_dollo.xml");
        try {
            SurfacingUtil.writeAllDomainsChangedOnAllSubtrees(phylogeny2, true, string, "_dollo_all_gains_d");
            SurfacingUtil.writeAllDomainsChangedOnAllSubtrees(phylogeny2, false, string, "_dollo_all_losses_d");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            ForesterUtil.fatalError("surfacing", iOException.getLocalizedMessage());
        }
        if (domainParsimonyCalculator.calculateNumberOfBinaryDomainCombination() > 0) {
            phylogeny2 = phylogeny.copy();
            String string5 = "no";
            if (bl) {
                domainParsimonyCalculator.executeFitchParsimonyOnBinaryDomainCombintion(l);
                string5 = "yes, seed = " + l;
            } else {
                domainParsimonyCalculator.executeFitchParsimonyOnBinaryDomainCombintion(false);
            }
            SurfacingUtil.writeMatrixToFile(domainParsimonyCalculator.getGainLossMatrix(), string + "_fitch_gl_dc", CharacterStateMatrix.Format.FORESTER);
            SurfacingUtil.writeMatrixToFile(domainParsimonyCalculator.getGainLossCountsMatrix(), string + "_fitch_glc_dc", CharacterStateMatrix.Format.FORESTER);
            SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, string + "_fitch_gains_dc", string3, ForesterUtil.LINE_SEPARATOR, null);
            SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, string + "_fitch_losses_dc", string3, ForesterUtil.LINE_SEPARATOR, null);
            SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), null, string + "_fitch_present_dc", string3, ForesterUtil.LINE_SEPARATOR, null);
            if (list != null) {
                SurfacingUtil.collectChangedDomainCombinationsFromBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), domainCombinationType, list, true);
            }
            if (list2 != null) {
                SurfacingUtil.collectChangedDomainCombinationsFromBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), domainCombinationType, list2, false);
            }
            if (bl2) {
                SurfacingUtil.writeBinaryStatesMatrixAsListToFileForBinaryCombinationsForGraphAnalysis(domainParsimonyCalculator.getGainLossMatrix(), null, string + "_fitch_present_dc.dot", string3, ForesterUtil.LINE_SEPARATOR, BinaryDomainCombination.OutputFormat.DOT);
            }
            SurfacingUtil.writeBinaryStatesMatrixToList(map, map2, goNameSpace, true, domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, string + "_fitch_gains_dc.html", string3, ForesterUtil.LINE_SEPARATOR, "Fitch Parsimony | Gains | Domain Combinations", "+", null, treeSet, treeSet4, "_fitch_gains_dc");
            SurfacingUtil.writeBinaryStatesMatrixToList(map, map2, goNameSpace, true, domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, string + "_fitch_losses_dc.html", string3, ForesterUtil.LINE_SEPARATOR, "Fitch Parsimony | Losses | Domain Combinations", "-", null, treeSet, treeSet5, "_fitch_losses_dc");
            SurfacingUtil.writeBinaryStatesMatrixToList(map, map2, goNameSpace, true, domainParsimonyCalculator.getGainLossMatrix(), null, string + "_fitch_present_dc.html", string3, ForesterUtil.LINE_SEPARATOR, "Fitch Parsimony | Present | Domain Combinations", "", null, treeSet, null, "_fitch_present_dc");
            SurfacingUtil.writeAllEncounteredPfamsToFile(map, map2, string, treeSet);
            SurfacingUtil.writePfamsToFile(string + "_all_pfams_gained_as_domains", treeSet2);
            SurfacingUtil.writePfamsToFile(string + "_all_pfams_lost_as_domains", treeSet3);
            SurfacingUtil.writePfamsToFile(string + "_all_pfams_gained_as_dc", treeSet4);
            SurfacingUtil.writePfamsToFile(string + "_all_pfams_lost_as_dc", treeSet5);
            SurfacingUtil.preparePhylogeny(phylogeny2, domainParsimonyCalculator, string4, "Fitch parsimony on binary domain combination presence/absence randomization: " + string5, "fitch_on_binary_domain_combinations_" + string, string2);
            SurfacingUtil.writePhylogenyToFile(phylogeny2, string + "_dc_fitch.xml");
        }
    }

    public static void executeParsimonyAnalysisForSecondaryFeatures(String string, DomainParsimonyCalculator domainParsimonyCalculator, Phylogeny phylogeny, String string2, Map<Species, MappingResults> map) {
        String string3 = ForesterUtil.LINE_SEPARATOR + "###################" + ForesterUtil.LINE_SEPARATOR;
        String string4 = ForesterUtil.getCurrentDateTime();
        System.out.println();
        SurfacingUtil.writeToNexus(string + "_secondary_features.nex", domainParsimonyCalculator.createMatrixOfSecondaryFeaturePresenceOrAbsence(null), phylogeny);
        Phylogeny phylogeny2 = phylogeny.copy();
        domainParsimonyCalculator.executeDolloParsimonyOnSecondaryFeatures(map);
        SurfacingUtil.writeMatrixToFile(domainParsimonyCalculator.getGainLossMatrix(), string + "_dollo_gl_secondary_features", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeMatrixToFile(domainParsimonyCalculator.getGainLossCountsMatrix(), string + "_dollo_glc_secondary_features", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, string + "_dollo_gains_secondary_features", string3, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, string + "_dollo_losses_secondary_features", string3, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), null, string + "_dollo_present_secondary_features", string3, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.preparePhylogeny(phylogeny2, domainParsimonyCalculator, string4, "Dollo parsimony on secondary feature presence/absence", "dollo_on_secondary_features_" + string, string2);
        SurfacingUtil.writePhylogenyToFile(phylogeny2, string + "_secondary_features_dollo.xml");
    }

    public static void extractProteinNames(List<Protein> list, List<DomainId> list2, Writer writer, String string) throws IOException {
        for (Protein protein : list) {
            if (!protein.contains(list2, true)) continue;
            writer.write(protein.getSpecies().getSpeciesId());
            writer.write(string);
            writer.write(protein.getProteinId().getId());
            writer.write(string);
            writer.write("[");
            HashSet<DomainId> hashSet = new HashSet<DomainId>();
            boolean bl = true;
            for (Domain domain : protein.getProteinDomains()) {
                if (hashSet.contains(domain.getDomainId())) continue;
                hashSet.add(domain.getDomainId());
                if (bl) {
                    bl = false;
                } else {
                    writer.write(" ");
                }
                writer.write(domain.getDomainId().getId());
                writer.write(" {");
                writer.write("" + domain.getTotalCount());
                writer.write("}");
            }
            writer.write("]");
            writer.write(string);
            if (!ForesterUtil.isEmpty(protein.getDescription()) && !protein.getDescription().equals("[none]")) {
                writer.write(protein.getDescription());
            }
            writer.write(string);
            if (!ForesterUtil.isEmpty(protein.getAccession()) && !protein.getAccession().equals("[none]")) {
                writer.write(protein.getAccession());
            }
            writer.write(SurfacingConstants.NL);
        }
        writer.flush();
    }

    public static void extractProteinNames(SortedMap<Species, List<Protein>> sortedMap, DomainId domainId, Writer writer, String string) throws IOException {
        for (Species species : sortedMap.keySet()) {
            for (Protein protein : (List)sortedMap.get(species)) {
                List<Domain> list = protein.getProteinDomains(domainId);
                if (list.size() <= 0) continue;
                BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
                for (Domain domain : list) {
                    basicDescriptiveStatistics.addValue(domain.getPerSequenceEvalue());
                }
                writer.write(protein.getSpecies().getSpeciesId());
                writer.write(string);
                writer.write(protein.getProteinId().getId());
                writer.write(string);
                writer.write("[" + FORMATTER.format(basicDescriptiveStatistics.median()) + "]");
                writer.write(string);
                if (!ForesterUtil.isEmpty(protein.getDescription()) && !protein.getDescription().equals("[none]")) {
                    writer.write(protein.getDescription());
                }
                writer.write(string);
                if (!ForesterUtil.isEmpty(protein.getAccession()) && !protein.getAccession().equals("[none]")) {
                    writer.write(protein.getAccession());
                }
                writer.write(SurfacingConstants.NL);
            }
        }
        writer.flush();
    }

    public static SortedSet<DomainId> getAllDomainIds(List<GenomeWideCombinableDomains> list) {
        TreeSet<DomainId> treeSet = new TreeSet<DomainId>();
        for (GenomeWideCombinableDomains genomeWideCombinableDomains : list) {
            SortedSet<DomainId> sortedSet = genomeWideCombinableDomains.getAllDomainIds();
            treeSet.addAll(sortedSet);
        }
        return treeSet;
    }

    public static SortedMap<String, Integer> getDomainCounts(List<Protein> list) {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        for (Protein protein : list) {
            for (Domain domain : protein.getProteinDomains()) {
                BasicDomain basicDomain = (BasicDomain)domain;
                String string = basicDomain.getDomainId().getId();
                if (treeMap.containsKey(string)) {
                    treeMap.put(string, (Integer)treeMap.get(string) + 1);
                    continue;
                }
                treeMap.put(string, 1);
            }
        }
        return treeMap;
    }

    public static int getNumberOfNodesLackingName(Phylogeny phylogeny, StringBuilder stringBuilder) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        int n = 0;
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeName())) continue;
            if (phylogenyNode.getParent() != null) {
                stringBuilder.append(" ");
                stringBuilder.append(phylogenyNode.getParent().getNodeName());
            }
            ++n;
        }
        return n;
    }

    public static boolean isEngulfed(Domain domain, List<Boolean> list) {
        for (int i = domain.getFrom(); i <= domain.getTo(); ++i) {
            if (i < list.size() && list.get(i).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static void preparePhylogeny(Phylogeny phylogeny, DomainParsimonyCalculator domainParsimonyCalculator, String string, String string2, String string3, String string4) {
        domainParsimonyCalculator.decoratePhylogenyWithDomains(phylogeny);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Method: " + string2 + "] [Date: " + string + "] ");
        stringBuilder.append("[Cost: " + domainParsimonyCalculator.getCost() + "] ");
        stringBuilder.append("[Gains: " + domainParsimonyCalculator.getTotalGains() + "] ");
        stringBuilder.append("[Losses: " + domainParsimonyCalculator.getTotalLosses() + "] ");
        stringBuilder.append("[Unchanged: " + domainParsimonyCalculator.getTotalUnchanged() + "] ");
        stringBuilder.append("[Parameters: " + string4 + "]");
        phylogeny.setName(string3);
        phylogeny.setDescription(stringBuilder.toString());
        phylogeny.setConfidence(new Confidence(domainParsimonyCalculator.getCost(), "parsimony"));
        phylogeny.setRerootable(false);
        phylogeny.setRooted(true);
    }

    public static Protein removeOverlappingDomains(int n, boolean bl, Protein protein) {
        BasicProtein basicProtein = new BasicProtein(protein.getProteinId().getId(), protein.getSpecies().getSpeciesId());
        List<Domain> list = SurfacingUtil.sortDomainsWithAscendingConfidenceValues(protein);
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        for (Domain domain : list) {
            int n2;
            int n3;
            if (n >= 0 && SurfacingUtil.calculateOverlap(domain, arrayList) > n || bl && SurfacingUtil.isEngulfed(domain, arrayList)) continue;
            for (n3 = n2 = arrayList.size(); n3 < domain.getFrom(); ++n3) {
                arrayList.add(false);
            }
            n3 = arrayList.size();
            for (int i = domain.getFrom(); i <= domain.getTo(); ++i) {
                if (i < n3) {
                    arrayList.set(i, true);
                    continue;
                }
                arrayList.add(true);
            }
            basicProtein.addProteinDomain(domain);
        }
        return basicProtein;
    }

    static List<Domain> sortDomainsWithAscendingConfidenceValues(Protein protein) {
        ArrayList<Domain> arrayList = new ArrayList<Domain>();
        for (Domain domain : protein.getProteinDomains()) {
            arrayList.add(domain);
        }
        Collections.sort(arrayList, ASCENDING_CONFIDENCE_VALUE_ORDER);
        return arrayList;
    }

    public static void writeAllDomainsChangedOnAllSubtrees(Phylogeny phylogeny, boolean bl, String string, String string2) throws IOException {
        CharacterStateMatrix.GainLossStates gainLossStates = CharacterStateMatrix.GainLossStates.GAIN;
        if (!bl) {
            gainLossStates = CharacterStateMatrix.GainLossStates.LOSS;
        }
        File file = SurfacingUtil.createBaseDirForPerNodeDomainFiles("PER_SUBTREE_EVENTS", false, gainLossStates, string);
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            SortedSet<String> sortedSet;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || (sortedSet = SurfacingUtil.collectAllDomainsChangedOnSubtree(phylogenyNode, bl)).size() <= 0) continue;
            BufferedWriter bufferedWriter = ForesterUtil.createBufferedWriter(file + ForesterUtil.FILE_SEPARATOR + phylogenyNode.getNodeName() + string2);
            for (String string3 : sortedSet) {
                bufferedWriter.write(string3);
                bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
            }
            ((Writer)bufferedWriter).close();
        }
    }

    private static void writeAllEncounteredPfamsToFile(Map<DomainId, List<GoId>> map, Map<GoId, GoTerm> map2, String string, SortedSet<String> sortedSet) {
        File file = new File(string + "_all_encountered_pfams");
        File file2 = new File(string + "_all_encountered_pfams_with_go_annotation");
        File file3 = new File(string + "_encountered_pfams_summary");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(file2));
            BufferedWriter bufferedWriter3 = new BufferedWriter(new FileWriter(file3));
            bufferedWriter3.write("# Pfam to GO mapping summary");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Actual summary is at the end of this file.");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Encountered Pfams without a GO mapping:");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            for (String string2 : sortedSet) {
                bufferedWriter.write(string2);
                bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
                DomainId domainId = new DomainId(string2);
                if (map.containsKey(domainId)) {
                    ++n4;
                    bufferedWriter2.write(string2);
                    bufferedWriter2.write(ForesterUtil.LINE_SEPARATOR);
                    List<GoId> list = map.get(domainId);
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    for (GoId goId : list) {
                        GoTerm goTerm = map2.get(goId);
                        if (goTerm.getGoNameSpace().isBiologicalProcess()) {
                            bl = true;
                            continue;
                        }
                        if (goTerm.getGoNameSpace().isCellularComponent()) {
                            bl2 = true;
                            continue;
                        }
                        if (!goTerm.getGoNameSpace().isMolecularFunction()) continue;
                        bl3 = true;
                    }
                    if (bl) {
                        ++n;
                    }
                    if (bl2) {
                        ++n2;
                    }
                    if (bl3) {
                        ++n3;
                    }
                    if (bl || bl3) {
                        ++n7;
                        continue;
                    }
                    ++n6;
                    continue;
                }
                ++n6;
                ++n5;
                bufferedWriter3.write(string2);
                bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            }
            ((Writer)bufferedWriter).close();
            ((Writer)bufferedWriter2).close();
            ForesterUtil.programMessage("surfacing", "Wrote all [" + sortedSet.size() + "] encountered Pfams to: \"" + file + "\"");
            ForesterUtil.programMessage("surfacing", "Wrote all [" + n4 + "] encountered Pfams with GO mappings to: \"" + file2 + "\"");
            ForesterUtil.programMessage("surfacing", "Wrote summary (including all [" + n5 + "] encountered Pfams without GO mappings) to: \"" + file3 + "\"");
            ForesterUtil.programMessage("surfacing", "Sum of Pfams encountered                : " + sortedSet.size());
            ForesterUtil.programMessage("surfacing", "Pfams without a mapping                 : " + n5 + " [" + 100 * n5 / sortedSet.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams without mapping to proc. or func. : " + n6 + " [" + 100 * n6 / sortedSet.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with a mapping                    : " + n4 + " [" + 100 * n4 / sortedSet.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with a mapping to proc. or func.  : " + n7 + " [" + 100 * n7 / sortedSet.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with mapping to biological process: " + n + " [" + 100 * n / sortedSet.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with mapping to molecular function: " + n3 + " [" + 100 * n3 / sortedSet.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with mapping to cellular component: " + n2 + " [" + 100 * n2 / sortedSet.size() + "%]");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Sum of Pfams encountered                : " + sortedSet.size());
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Pfams without a mapping                 : " + n5 + " [" + 100 * n5 / sortedSet.size() + "%]");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Pfams without mapping to proc. or func. : " + n6 + " [" + 100 * n6 / sortedSet.size() + "%]");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Pfams with a mapping                    : " + n4 + " [" + 100 * n4 / sortedSet.size() + "%]");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Pfams with a mapping to proc. or func.  : " + n7 + " [" + 100 * n7 / sortedSet.size() + "%]");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Pfams with mapping to biological process: " + n + " [" + 100 * n / sortedSet.size() + "%]");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Pfams with mapping to molecular function: " + n3 + " [" + 100 * n3 / sortedSet.size() + "%]");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Pfams with mapping to cellular component: " + n2 + " [" + 100 * n2 / sortedSet.size() + "%]");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            ((Writer)bufferedWriter3).close();
        }
        catch (IOException iOException) {
            ForesterUtil.printWarningMessage("surfacing", "Failure to write: " + iOException);
        }
    }

    public static void writeBinaryDomainCombinationsFileForGraphAnalysis(String[][] stringArray, File file, GenomeWideCombinableDomains genomeWideCombinableDomains, int n, GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder genomeWideCombinableDomainsSortOrder) {
        File file2 = new File(stringArray[n][0] + "_dc.dot");
        if (file != null) {
            file2 = new File(file + ForesterUtil.FILE_SEPARATOR + file2);
        }
        SurfacingUtil.checkForOutputFileWriteability(file2);
        SortedSet<BinaryDomainCombination> sortedSet = SurfacingUtil.createSetOfAllBinaryDomainCombinationsPerGenome(genomeWideCombinableDomains);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
            for (BinaryDomainCombination binaryDomainCombination : sortedSet) {
                bufferedWriter.write(binaryDomainCombination.toGraphDescribingLanguage(BinaryDomainCombination.OutputFormat.DOT, null, null).toString());
                bufferedWriter.write(SurfacingConstants.NL);
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote binary domain combination for \"" + stringArray[n][0] + "\" (" + stringArray[n][1] + ", " + stringArray[n][2] + ") to: \"" + file2 + "\"");
    }

    public static StringBuffer proteinToDomainCombinations(Protein protein, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (protein.getSpecies() == null) {
            throw new IllegalArgumentException("species must not be null");
        }
        if (ForesterUtil.isEmpty(protein.getSpecies().getSpeciesId())) {
            throw new IllegalArgumentException("species id must not be empty");
        }
        List<Domain> list = protein.getProteinDomains();
        if (list.size() > 1) {
            Object object;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (Domain domain : list) {
                object = domain.getDomainId().getId();
                if (hashMap.containsKey(object)) {
                    hashMap.put((String)object, (Integer)hashMap.get(object) + 1);
                    continue;
                }
                hashMap.put((String)object, 1);
            }
            for (int i = 1; i < list.size(); ++i) {
                for (int j = 0; j < i; ++j) {
                    object = list.get(i);
                    Domain domain = list.get(j);
                    if (object.getFrom() > domain.getFrom()) {
                        object = list.get(j);
                        domain = list.get(i);
                    }
                    stringBuffer.append(protein.getSpecies());
                    stringBuffer.append(string2);
                    stringBuffer.append(string);
                    stringBuffer.append(string2);
                    stringBuffer.append(object.getDomainId().getId());
                    stringBuffer.append(string2);
                    stringBuffer.append(domain.getDomainId().getId());
                    stringBuffer.append(string2);
                    stringBuffer.append(object.getPerDomainEvalue());
                    stringBuffer.append(string2);
                    stringBuffer.append(domain.getPerDomainEvalue());
                    stringBuffer.append(string2);
                    stringBuffer.append(hashMap.get(object.getDomainId().getId()));
                    stringBuffer.append(string2);
                    stringBuffer.append(hashMap.get(domain.getDomainId().getId()));
                    stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
                }
            }
        } else if (list.size() == 1) {
            stringBuffer.append(protein.getSpecies());
            stringBuffer.append(string2);
            stringBuffer.append(string);
            stringBuffer.append(string2);
            stringBuffer.append(list.get(0).getDomainId().getId());
            stringBuffer.append(string2);
            stringBuffer.append(string2);
            stringBuffer.append(list.get(0).getPerDomainEvalue());
            stringBuffer.append(string2);
            stringBuffer.append(string2);
            stringBuffer.append(1);
            stringBuffer.append(string2);
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        } else {
            stringBuffer.append(protein.getSpecies());
            stringBuffer.append(string2);
            stringBuffer.append(string);
            stringBuffer.append(string2);
            stringBuffer.append(string2);
            stringBuffer.append(string2);
            stringBuffer.append(string2);
            stringBuffer.append(string2);
            stringBuffer.append(string2);
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        }
        return stringBuffer;
    }

    public static void writeBinaryStatesMatrixAsListToFile(CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix, CharacterStateMatrix.GainLossStates gainLossStates, String string, String string2, String string3, Map<String, String> map) {
        File file = new File(string);
        SurfacingUtil.checkForOutputFileWriteability(file);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < characterStateMatrix.getNumberOfIdentifiers(); ++i) {
            treeSet.add(characterStateMatrix.getIdentifier(i));
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (String string4 : treeSet) {
                bufferedWriter.write(string2);
                bufferedWriter.write("#" + string4);
                bufferedWriter.write(string2);
                for (int i = 0; i < characterStateMatrix.getNumberOfCharacters(); ++i) {
                    if (characterStateMatrix.getState(string4, i) != gainLossStates && (gainLossStates != null || characterStateMatrix.getState(string4, i) != CharacterStateMatrix.GainLossStates.GAIN && characterStateMatrix.getState(string4, i) != CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT)) continue;
                    bufferedWriter.write(characterStateMatrix.getCharacter(i));
                    if (map != null && !map.isEmpty() && map.containsKey(characterStateMatrix.getCharacter(i))) {
                        bufferedWriter.write("\t");
                        bufferedWriter.write(map.get(characterStateMatrix.getCharacter(i)));
                    }
                    bufferedWriter.write(string3);
                }
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote characters list: \"" + string + "\"");
    }

    public static void writeBinaryStatesMatrixAsListToFileForBinaryCombinationsForGraphAnalysis(CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix, CharacterStateMatrix.GainLossStates gainLossStates, String string, String string2, String string3, BinaryDomainCombination.OutputFormat outputFormat) {
        File file = new File(string);
        SurfacingUtil.checkForOutputFileWriteability(file);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < characterStateMatrix.getNumberOfIdentifiers(); ++i) {
            treeSet.add(characterStateMatrix.getIdentifier(i));
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (String string4 : treeSet) {
                bufferedWriter.write(string2);
                bufferedWriter.write("#" + string4);
                bufferedWriter.write(string2);
                for (int i = 0; i < characterStateMatrix.getNumberOfCharacters(); ++i) {
                    if (characterStateMatrix.getState(string4, i) != gainLossStates && (gainLossStates != null || characterStateMatrix.getState(string4, i) != CharacterStateMatrix.GainLossStates.GAIN && characterStateMatrix.getState(string4, i) != CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT)) continue;
                    BinaryDomainCombination binaryDomainCombination = null;
                    try {
                        binaryDomainCombination = BasicBinaryDomainCombination.createInstance(characterStateMatrix.getCharacter(i));
                    }
                    catch (Exception exception) {
                        ForesterUtil.fatalError("surfacing", exception.getLocalizedMessage());
                    }
                    bufferedWriter.write(binaryDomainCombination.toGraphDescribingLanguage(outputFormat, null, null).toString());
                    bufferedWriter.write(string3);
                }
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote characters list: \"" + string + "\"");
    }

    public static void writeBinaryStatesMatrixToList(Map<DomainId, List<GoId>> map, Map<GoId, GoTerm> map2, GoNameSpace goNameSpace, boolean bl, CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix, CharacterStateMatrix.GainLossStates gainLossStates, String string, String string2, String string3, String string4, String string5, Map<DomainId, Set<String>>[] mapArray, SortedSet<String> sortedSet, SortedSet<String> sortedSet2, String string6) {
        if (goNameSpace != null && (map2 == null || map2.size() < 1)) {
            throw new IllegalArgumentException("attempt to use GO namespace limit without a GO-id to term map");
        }
        if (map == null || map.size() < 1) {
            throw new IllegalArgumentException("attempt to output detailed HTML without a Pfam to GO map");
        }
        if (map2 == null || map2.size() < 1) {
            throw new IllegalArgumentException("attempt to output detailed HTML without a GO-id to term map");
        }
        File file = new File(string);
        SurfacingUtil.checkForOutputFileWriteability(file);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < characterStateMatrix.getNumberOfIdentifiers(); ++i) {
            treeSet.add(characterStateMatrix.getIdentifier(i));
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            File file2 = SurfacingUtil.createBaseDirForPerNodeDomainFiles("PER_NODE_EVENTS", bl, gainLossStates, string);
            Writer writer = null;
            File file3 = null;
            int n = 0;
            bufferedWriter.write("<html>");
            bufferedWriter.write(SurfacingConstants.NL);
            SurfacingUtil.addHtmlHead(bufferedWriter, string4);
            bufferedWriter.write(SurfacingConstants.NL);
            bufferedWriter.write("<body>");
            bufferedWriter.write(SurfacingConstants.NL);
            bufferedWriter.write("<h1>");
            bufferedWriter.write(SurfacingConstants.NL);
            bufferedWriter.write(string4);
            bufferedWriter.write(SurfacingConstants.NL);
            bufferedWriter.write("</h1>");
            bufferedWriter.write(SurfacingConstants.NL);
            bufferedWriter.write("<table>");
            bufferedWriter.write(SurfacingConstants.NL);
            for (String string7 : treeSet) {
                bufferedWriter.write("<tr>");
                bufferedWriter.write("<td>");
                bufferedWriter.write("<a href=\"#" + string7 + "\">" + string7 + "</a>");
                SurfacingUtil.writeTaxonomyLinks(bufferedWriter, string7);
                bufferedWriter.write("</td>");
                bufferedWriter.write("</tr>");
                bufferedWriter.write(SurfacingConstants.NL);
            }
            bufferedWriter.write("</table>");
            bufferedWriter.write(SurfacingConstants.NL);
            for (String string7 : treeSet) {
                bufferedWriter.write(SurfacingConstants.NL);
                bufferedWriter.write("<h2>");
                bufferedWriter.write("<a name=\"" + string7 + "\">" + string7 + "</a>");
                SurfacingUtil.writeTaxonomyLinks(bufferedWriter, string7);
                bufferedWriter.write("</h2>");
                bufferedWriter.write(SurfacingConstants.NL);
                bufferedWriter.write("<table>");
                bufferedWriter.write(SurfacingConstants.NL);
                bufferedWriter.write("<tr>");
                bufferedWriter.write("<td><b>");
                bufferedWriter.write("Pfam domain(s)");
                bufferedWriter.write("</b></td><td><b>");
                bufferedWriter.write("GO term acc");
                bufferedWriter.write("</b></td><td><b>");
                bufferedWriter.write("GO term");
                bufferedWriter.write("</b></td><td><b>");
                bufferedWriter.write("Penultimate GO term");
                bufferedWriter.write("</b></td><td><b>");
                bufferedWriter.write("GO namespace");
                bufferedWriter.write("</b></td>");
                bufferedWriter.write("</tr>");
                bufferedWriter.write(SurfacingConstants.NL);
                bufferedWriter.write("</tr>");
                bufferedWriter.write(SurfacingConstants.NL);
                n = 0;
                if (characterStateMatrix.getNumberOfCharacters() > 0) {
                    file3 = new File(file2 + ForesterUtil.FILE_SEPARATOR + string7 + string6);
                    SurfacingUtil.checkForOutputFileWriteability(file3);
                    writer = ForesterUtil.createBufferedWriter(file3);
                } else {
                    file3 = null;
                    writer = null;
                }
                for (int i = 0; i < characterStateMatrix.getNumberOfCharacters(); ++i) {
                    if (characterStateMatrix.getState(string7, i) != gainLossStates && (gainLossStates != null || characterStateMatrix.getState(string7, i) != CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT && characterStateMatrix.getState(string7, i) != CharacterStateMatrix.GainLossStates.GAIN)) continue;
                    String string8 = characterStateMatrix.getCharacter(i);
                    String string9 = "";
                    String string10 = "";
                    if (string8.indexOf("=") > 0) {
                        String[] stringArray = string8.split("=");
                        if (stringArray.length != 2) {
                            throw new AssertionError((Object)("this should not have happened: unexpected format for domain combination: [" + string8 + "]"));
                        }
                        string9 = stringArray[0];
                        string10 = stringArray[1];
                    } else {
                        string9 = string8;
                    }
                    SurfacingUtil.writeDomainData(map, map2, goNameSpace, bufferedWriter, string9, string10, string5, string3, mapArray, null);
                    sortedSet.add(string9);
                    if (sortedSet2 != null) {
                        sortedSet2.add(string9);
                    }
                    if (!ForesterUtil.isEmpty(string10)) {
                        sortedSet.add(string10);
                        if (sortedSet2 != null) {
                            sortedSet2.add(string10);
                        }
                    }
                    if (writer == null) continue;
                    SurfacingUtil.writeDomainsToIndividualFilePerTreeNode(writer, string9, string10);
                    ++n;
                }
                if (writer != null) {
                    writer.close();
                    if (n < 1) {
                        file3.delete();
                    }
                    n = 0;
                }
                bufferedWriter.write("</table>");
                bufferedWriter.write(SurfacingConstants.NL);
                bufferedWriter.write("<hr>");
                bufferedWriter.write(SurfacingConstants.NL);
            }
            bufferedWriter.write("</body>");
            bufferedWriter.write(SurfacingConstants.NL);
            bufferedWriter.write("</html>");
            bufferedWriter.write(SurfacingConstants.NL);
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote characters detailed HTML list: \"" + string + "\"");
    }

    public static void writeDomainCombinationsCountsFile(String[][] stringArray, File file, Writer writer, GenomeWideCombinableDomains genomeWideCombinableDomains, int n, GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder genomeWideCombinableDomainsSortOrder) {
        Object object;
        File file2 = new File(stringArray[n][0] + ".dcc");
        if (file != null) {
            file2 = new File(file + ForesterUtil.FILE_SEPARATOR + file2);
        }
        SurfacingUtil.checkForOutputFileWriteability(file2);
        try {
            object = new BufferedWriter(new FileWriter(file2));
            ((Writer)object).write(genomeWideCombinableDomains.toStringBuilder(genomeWideCombinableDomainsSortOrder).toString());
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        object = genomeWideCombinableDomains.getPerGenomeDomainPromiscuityStatistics();
        try {
            writer.write(stringArray[n][0] + "\t");
            writer.write(FORMATTER_3.format(object.arithmeticMean()) + "\t");
            if (object.getN() < 2) {
                writer.write("n/a\t");
            } else {
                writer.write(FORMATTER_3.format(object.sampleStandardDeviation()) + "\t");
            }
            writer.write(FORMATTER_3.format(object.median()) + "\t");
            writer.write((int)object.getMin() + "\t");
            writer.write((int)object.getMax() + "\t");
            writer.write(object.getN() + "\t");
            SortedSet<DomainId> sortedSet = genomeWideCombinableDomains.getMostPromiscuosDomain();
            for (DomainId domainId : sortedSet) {
                writer.write(domainId.getId() + " ");
            }
            writer.write(ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        if (stringArray[n].length == 3) {
            ForesterUtil.programMessage("surfacing", "Wrote domain combination counts for \"" + stringArray[n][0] + "\" (" + stringArray[n][1] + ", " + stringArray[n][2] + ") to: \"" + file2 + "\"");
        } else {
            ForesterUtil.programMessage("surfacing", "Wrote domain combination counts for \"" + stringArray[n][0] + "\" (" + stringArray[n][1] + ") to: \"" + file2 + "\"");
        }
    }

    private static void writeDomainData(Map<DomainId, List<GoId>> map, Map<GoId, GoTerm> map2, GoNameSpace goNameSpace, Writer writer, String string, String string2, String string3, String string4, Map<DomainId, Set<String>>[] mapArray, Set<GoId> set) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 2;
        if (ForesterUtil.isEmpty(string2)) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            DomainId domainId;
            List<GoId> list = null;
            boolean bl3 = false;
            if (i == 0) {
                domainId = new DomainId(string);
                if (map.containsKey(domainId)) {
                    bl3 = true;
                    bl = true;
                    list = map.get(domainId);
                } else {
                    bl2 = true;
                }
            } else {
                domainId = new DomainId(string2);
                if (map.containsKey(domainId)) {
                    bl3 = true;
                    bl = true;
                    list = map.get(domainId);
                }
            }
            if (!bl3) continue;
            boolean bl4 = i == 0 || i == 1 && bl2;
            for (GoId goId : list) {
                writer.write("<tr>");
                if (bl4) {
                    bl4 = false;
                    SurfacingUtil.writeDomainIdsToHtml(writer, string, string2, string3, mapArray);
                } else {
                    writer.write("<td></td>");
                }
                if (!map2.containsKey(goId)) {
                    throw new IllegalArgumentException("GO-id [" + goId + "] not found in GO-id to GO-term map");
                }
                GoTerm goTerm = map2.get(goId);
                if (goNameSpace == null || goNameSpace.equals(goTerm.getGoNameSpace())) {
                    String string5 = GoUtils.getPenultimateGoTerm(goTerm, map2).getName();
                    String string6 = goId.getId();
                    writer.write("<td>");
                    writer.write("<a href=\"http://amigo.geneontology.org/cgi-bin/amigo/go.cgi?view=details&search_constraint=terms&query=" + string6 + "\" target=\"amigo_window\">" + string6 + "</a>");
                    writer.write("</td><td>");
                    writer.write(goTerm.getName());
                    if (n == 2) {
                        writer.write(" (" + i + ")");
                    }
                    writer.write("</td><td>");
                    writer.write(string5);
                    writer.write("</td><td>");
                    writer.write("[");
                    writer.write(goTerm.getGoNameSpace().toShortString());
                    writer.write("]");
                    writer.write("</td>");
                    if (set != null) {
                        set.add(goId);
                    }
                } else {
                    writer.write("<td>");
                    writer.write("</td><td>");
                    writer.write("</td><td>");
                    writer.write("</td><td>");
                    writer.write("</td>");
                }
                writer.write("</tr>");
                writer.write(SurfacingConstants.NL);
            }
        }
        if (!bl) {
            writer.write("<tr>");
            SurfacingUtil.writeDomainIdsToHtml(writer, string, string2, string3, mapArray);
            writer.write("<td>");
            writer.write("</td><td>");
            writer.write("</td><td>");
            writer.write("</td><td>");
            writer.write("</td>");
            writer.write("</tr>");
            writer.write(SurfacingConstants.NL);
        }
    }

    private static void writeDomainIdsToHtml(Writer writer, String string, String string2, String string3, Map<DomainId, Set<String>>[] mapArray) throws IOException {
        writer.write("<td>");
        if (!ForesterUtil.isEmpty(string3)) {
            writer.write(string3);
            writer.write(" ");
        }
        writer.write("<a href=\"http://pfam.sanger.ac.uk/family?id=" + string + "\">" + string + "</a>");
        if (ForesterUtil.isEmpty(string2)) {
            writer.write(" <a href=\"http://scholar.google.com/scholar?q=" + string + "&as_subj=bio&as_subj=med&as_subj=chm&num=100" + "\">[gs]</a>");
        }
        if (!ForesterUtil.isEmpty(string2)) {
            writer.write("=");
            writer.write("<a href=\"http://pfam.sanger.ac.uk/family?id=" + string2 + "\">" + string2 + "</a>");
        } else if (mapArray != null && mapArray.length > 0) {
            writer.write(" [");
            boolean bl = true;
            for (Map<DomainId, Set<String>> map : mapArray) {
                Set<String> set = map.get(new DomainId(string));
                if (set == null || set.size() <= 0) continue;
                for (String string4 : set) {
                    if (bl) {
                        bl = false;
                    } else {
                        writer.write(", ");
                    }
                    if ("http://scop.mrc-lmb.cam.ac.uk/scop/search.cgi?key=" != null) {
                        writer.write("<a href=\"http://scop.mrc-lmb.cam.ac.uk/scop/search.cgi?key=" + string4 + "\" target=\"scop_window\">" + string4 + "</a>");
                        continue;
                    }
                    writer.write(string4);
                }
            }
            writer.write("]");
        }
        writer.write("</td>");
    }

    public static DescriptiveStatistics writeDomainSimilaritiesToFile(StringBuilder stringBuilder, StringBuilder stringBuilder2, Writer writer, SortedSet<DomainSimilarity> sortedSet, boolean bl, List<Species> list, PrintableDomainSimilarity.PRINT_OPTION pRINT_OPTION, DomainSimilarity.DomainSimilaritySortField domainSimilaritySortField, DomainSimilarity.DomainSimilarityScoring domainSimilarityScoring, boolean bl2) throws IOException {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        String string = null;
        switch (domainSimilaritySortField) {
            case ABS_MAX_COUNTS_DIFFERENCE: {
                if (bl) {
                    string = "absolute counts difference:";
                    break;
                }
                string = "absolute (maximal) counts difference:";
                break;
            }
            case MAX_COUNTS_DIFFERENCE: {
                if (bl) {
                    string = "counts difference:";
                    break;
                }
                string = "(maximal) counts difference:";
                break;
            }
            case DOMAIN_ID: {
                string = "score mean:";
                break;
            }
            case MIN: {
                string = "score minimum:";
                break;
            }
            case MAX: {
                string = "score maximum:";
                break;
            }
            case MAX_DIFFERENCE: {
                if (bl) {
                    string = "difference:";
                    break;
                }
                string = "(maximal) difference:";
                break;
            }
            case MEAN: {
                string = "score mean:";
                break;
            }
            case SD: {
                string = "score standard deviation:";
                break;
            }
            case SPECIES_COUNT: {
                string = "species number:";
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown sort field: " + (Object)((Object)domainSimilaritySortField)));
            }
        }
        block29: for (DomainSimilarity object : sortedSet) {
            switch (domainSimilaritySortField) {
                case ABS_MAX_COUNTS_DIFFERENCE: {
                    basicDescriptiveStatistics.addValue(Math.abs(object.getMaximalDifferenceInCounts()));
                    continue block29;
                }
                case MAX_COUNTS_DIFFERENCE: {
                    basicDescriptiveStatistics.addValue(object.getMaximalDifferenceInCounts());
                    continue block29;
                }
                case DOMAIN_ID: {
                    basicDescriptiveStatistics.addValue(object.getMeanSimilarityScore());
                    continue block29;
                }
                case MIN: {
                    basicDescriptiveStatistics.addValue(object.getMinimalSimilarityScore());
                    continue block29;
                }
                case MAX: {
                    basicDescriptiveStatistics.addValue(object.getMaximalSimilarityScore());
                    continue block29;
                }
                case MAX_DIFFERENCE: {
                    basicDescriptiveStatistics.addValue(object.getMaximalDifference());
                    continue block29;
                }
                case MEAN: {
                    basicDescriptiveStatistics.addValue(object.getMeanSimilarityScore());
                    continue block29;
                }
                case SD: {
                    basicDescriptiveStatistics.addValue(object.getStandardDeviationOfSimilarityScore());
                    continue block29;
                }
                case SPECIES_COUNT: {
                    basicDescriptiveStatistics.addValue(object.getSpecies().size());
                    continue block29;
                }
            }
            throw new AssertionError((Object)("Unknown sort field: " + (Object)((Object)domainSimilaritySortField)));
        }
        Object object = null;
        if (basicDescriptiveStatistics.getMin() < basicDescriptiveStatistics.getMin()) {
            object = new AsciiHistogram(basicDescriptiveStatistics, string);
        }
        if (bl2) {
            if (object != null) {
                System.out.println(((AsciiHistogram)object).toStringBuffer(20, '|', 40, 5));
            }
            System.out.println();
            System.out.println("N                   : " + basicDescriptiveStatistics.getN());
            System.out.println("Min                 : " + basicDescriptiveStatistics.getMin());
            System.out.println("Max                 : " + basicDescriptiveStatistics.getMax());
            System.out.println("Mean                : " + basicDescriptiveStatistics.arithmeticMean());
            if (basicDescriptiveStatistics.getN() > 1) {
                System.out.println("SD                  : " + basicDescriptiveStatistics.sampleStandardDeviation());
            } else {
                System.out.println("SD                  : n/a");
            }
            System.out.println("Median              : " + basicDescriptiveStatistics.median());
            if (basicDescriptiveStatistics.getN() > 1) {
                System.out.println("Pearsonian skewness : " + basicDescriptiveStatistics.pearsonianSkewness());
            } else {
                System.out.println("Pearsonian skewness : n/a");
            }
        }
        switch (pRINT_OPTION) {
            case SIMPLE_TAB_DELIMITED: {
                break;
            }
            case HTML: {
                writer.write("<html>");
                writer.write(SurfacingConstants.NL);
                SurfacingUtil.addHtmlHead(writer, "SURFACING :: " + stringBuilder2);
                writer.write(SurfacingConstants.NL);
                writer.write("<body>");
                writer.write(SurfacingConstants.NL);
                writer.write(stringBuilder.toString());
                writer.write(SurfacingConstants.NL);
                writer.write("<hr>");
                writer.write("<br>");
                writer.write(SurfacingConstants.NL);
                writer.write("<tt><pre>");
                writer.write(SurfacingConstants.NL);
                if (object != null) {
                    writer.write(((AsciiHistogram)object).toStringBuffer(20, '|', 40, 5).toString());
                    writer.write(SurfacingConstants.NL);
                }
                writer.write("</pre></tt>");
                writer.write(SurfacingConstants.NL);
                writer.write("<table>");
                writer.write(SurfacingConstants.NL);
                writer.write("<tr><td>N: </td><td>" + basicDescriptiveStatistics.getN() + "</td></tr>");
                writer.write(SurfacingConstants.NL);
                writer.write("<tr><td>Min: </td><td>" + basicDescriptiveStatistics.getMin() + "</td></tr>");
                writer.write(SurfacingConstants.NL);
                writer.write("<tr><td>Max: </td><td>" + basicDescriptiveStatistics.getMax() + "</td></tr>");
                writer.write(SurfacingConstants.NL);
                writer.write("<tr><td>Mean: </td><td>" + basicDescriptiveStatistics.arithmeticMean() + "</td></tr>");
                writer.write(SurfacingConstants.NL);
                if (basicDescriptiveStatistics.getN() > 1) {
                    writer.write("<tr><td>SD: </td><td>" + basicDescriptiveStatistics.sampleStandardDeviation() + "</td></tr>");
                } else {
                    writer.write("<tr><td>SD: </td><td>n/a</td></tr>");
                }
                writer.write(SurfacingConstants.NL);
                writer.write("<tr><td>Median: </td><td>" + basicDescriptiveStatistics.median() + "</td></tr>");
                writer.write(SurfacingConstants.NL);
                if (basicDescriptiveStatistics.getN() > 1) {
                    writer.write("<tr><td>Pearsonian skewness: </td><td>" + basicDescriptiveStatistics.pearsonianSkewness() + "</td></tr>");
                } else {
                    writer.write("<tr><td>Pearsonian skewness: </td><td>n/a</td></tr>");
                }
                writer.write(SurfacingConstants.NL);
                writer.write("</table>");
                writer.write(SurfacingConstants.NL);
                writer.write("<br>");
                writer.write(SurfacingConstants.NL);
                writer.write("<hr>");
                writer.write(SurfacingConstants.NL);
                writer.write("<br>");
                writer.write(SurfacingConstants.NL);
                writer.write("<table>");
                writer.write(SurfacingConstants.NL);
            }
        }
        writer.write(SurfacingConstants.NL);
        for (DomainSimilarity domainSimilarity : sortedSet) {
            if (list != null && !list.isEmpty()) {
                ((PrintableDomainSimilarity)domainSimilarity).setSpeciesOrder(list);
            }
            writer.write(domainSimilarity.toStringBuffer(pRINT_OPTION).toString());
            writer.write(SurfacingConstants.NL);
        }
        switch (pRINT_OPTION) {
            case HTML: {
                writer.write(SurfacingConstants.NL);
                writer.write("</table>");
                writer.write(SurfacingConstants.NL);
                writer.write("</font>");
                writer.write(SurfacingConstants.NL);
                writer.write("</body>");
                writer.write(SurfacingConstants.NL);
                writer.write("</html>");
                writer.write(SurfacingConstants.NL);
            }
        }
        writer.flush();
        writer.close();
        return basicDescriptiveStatistics;
    }

    private static void writeDomainsToIndividualFilePerTreeNode(Writer writer, String string, String string2) throws IOException {
        writer.write(string);
        writer.write(ForesterUtil.LINE_SEPARATOR);
        if (!ForesterUtil.isEmpty(string2)) {
            writer.write(string2);
            writer.write(ForesterUtil.LINE_SEPARATOR);
        }
    }

    public static void writeMatrixToFile(CharacterStateMatrix<?> characterStateMatrix, String string, CharacterStateMatrix.Format format) {
        File file = new File(string);
        SurfacingUtil.checkForOutputFileWriteability(file);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            characterStateMatrix.toWriter(bufferedWriter, format);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote matrix: \"" + string + "\"");
    }

    public static void writeMatrixToFile(File file, List<DistanceMatrix> list) {
        SurfacingUtil.checkForOutputFileWriteability(file);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (DistanceMatrix distanceMatrix : list) {
                bufferedWriter.write(distanceMatrix.toStringBuffer(DistanceMatrix.Format.PHYLIP).toString());
                bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
                bufferedWriter.flush();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote distance matrices to \"" + file + "\"");
    }

    private static void writePfamsToFile(String string, SortedSet<String> sortedSet) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(string)));
            for (String string2 : sortedSet) {
                bufferedWriter.write(string2);
                bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
            }
            ((Writer)bufferedWriter).close();
            ForesterUtil.programMessage("surfacing", "Wrote " + sortedSet.size() + " pfams to [" + string + "]");
        }
        catch (IOException iOException) {
            ForesterUtil.printWarningMessage("surfacing", "Failure to write: " + iOException);
        }
    }

    public static void writePhylogenyToFile(Phylogeny phylogeny, String string) {
        PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
        try {
            phylogenyWriter.toPhyloXML(new File(string), phylogeny, 1);
        }
        catch (IOException iOException) {
            ForesterUtil.printWarningMessage("surfacing", "failed to write phylogeny to \"" + string + "\": " + iOException);
        }
        ForesterUtil.programMessage("surfacing", "Wrote phylogeny to \"" + string + "\"");
    }

    public static void writeTaxonomyLinks(Writer writer, String string) throws IOException {
        if (string.length() > 1 && string.indexOf(95) < 1) {
            Matcher matcher = PATTERN_SP_STYLE_TAXONOMY.matcher(string);
            writer.write(" [");
            if (matcher.matches()) {
                writer.write("<a href=\"http://beta.uniprot.org/taxonomy/?query=" + string + "\" target=\"taxonomy_window\">uniprot</a>");
            } else {
                writer.write("<a href=\"http://www.eol.org/search?q=" + string + "\" target=\"taxonomy_window\">eol</a>");
                writer.write("|");
                writer.write("<a href=\"http://www.googlesyndicatedsearch.com/u/TreeofLife?q=" + string + "\" target=\"taxonomy_window\">tol</a>");
                writer.write("|");
                writer.write("<a href=\"http://wikipedia.org/wiki/" + string + "\" target=\"taxonomy_window\">wikipedia</a>");
                writer.write("|");
                writer.write("<a href=\"http://scholar.google.com/scholar?q=" + string + "\" target=\"taxonomy_window\">gs</a>");
            }
            writer.write("]");
        }
    }

    private static void writeToNexus(String string, CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix) {
        if (!(characterStateMatrix instanceof BasicCharacterStateMatrix)) {
            throw new IllegalArgumentException("can only write matrices of type [" + BasicCharacterStateMatrix.class + "] to nexus");
        }
        BasicCharacterStateMatrix basicCharacterStateMatrix = (BasicCharacterStateMatrix)characterStateMatrix;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write("#NEXUS");
            bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
            basicCharacterStateMatrix.writeNexusTaxaBlock(bufferedWriter);
            basicCharacterStateMatrix.writeNexusBinaryChractersBlock(bufferedWriter);
            bufferedWriter.flush();
            bufferedWriter.close();
            ForesterUtil.programMessage("surfacing", "Wrote Nexus file: \"" + string + "\"");
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
    }

    private static void writeToNexus(String string, CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix, Phylogeny phylogeny) {
        if (!(characterStateMatrix instanceof BasicCharacterStateMatrix)) {
            throw new IllegalArgumentException("can only write matrices of type [" + BasicCharacterStateMatrix.class + "] to nexus");
        }
        BasicCharacterStateMatrix basicCharacterStateMatrix = (BasicCharacterStateMatrix)characterStateMatrix;
        ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>(1);
        arrayList.add(phylogeny);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write("#NEXUS");
            bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
            basicCharacterStateMatrix.writeNexusTaxaBlock(bufferedWriter);
            basicCharacterStateMatrix.writeNexusBinaryChractersBlock(bufferedWriter);
            PhylogenyWriter.writeNexusTreesBlock(bufferedWriter, arrayList);
            bufferedWriter.flush();
            bufferedWriter.close();
            ForesterUtil.programMessage("surfacing", "Wrote Nexus file: \"" + string + "\"");
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
    }

    private static void writeToNexus(String string, DomainParsimonyCalculator domainParsimonyCalculator) {
        SurfacingUtil.writeToNexus(string + "_dom.nex", domainParsimonyCalculator.createMatrixOfDomainPresenceOrAbsence());
        SurfacingUtil.writeToNexus(string + "_dc.nex", domainParsimonyCalculator.createMatrixOfBinaryDomainCombinationPresenceOrAbsence());
    }

    private static void writeToNexus(String string, DomainParsimonyCalculator domainParsimonyCalculator, Phylogeny phylogeny) {
        SurfacingUtil.writeToNexus(string + "_dom.nex", domainParsimonyCalculator.createMatrixOfDomainPresenceOrAbsence(), phylogeny);
        SurfacingUtil.writeToNexus(string + "_dc.nex", domainParsimonyCalculator.createMatrixOfBinaryDomainCombinationPresenceOrAbsence(), phylogeny);
    }
}

