/*
 * Decompiled with CFR 0.152.
 */
package org.forester.tools;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.tools.TreeSplitMatrix;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfidenceAssessor {
    private ConfidenceAssessor() {
    }

    private static final void addExternalNodesToMap(Map<PhylogenyNode, Set<PhylogenyNode>> map, PhylogenyNode phylogenyNode) {
        HashSet<PhylogenyNode> hashSet = new HashSet<PhylogenyNode>();
        for (PhylogenyNode phylogenyNode2 : phylogenyNode.getAllExternalDescendants()) {
            if (hashSet.contains(phylogenyNode2)) {
                throw new IllegalArgumentException("node '" + phylogenyNode2.toString() + "' of target is not unique");
            }
            hashSet.add(phylogenyNode2);
        }
        map.put(phylogenyNode, hashSet);
    }

    private static final void checkPreconditions(String string, Phylogeny[] phylogenyArray, Phylogeny phylogeny, double d, int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("attempt to set first or last evaluator topology to use to a number less than zero");
        }
        if (phylogenyArray.length < 1) {
            throw new IllegalArgumentException("need at least one evaluator topology");
        }
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("attempt to use empty confidence type");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("attempt to use zero or negative 'count value'");
        }
        if (!(n == 0 && n2 == 0 || n2 < phylogenyArray.length && n2 > n)) {
            throw new IllegalArgumentException("illegal value for last evaluator topology to use");
        }
        HashSet<PhylogenyNode> hashSet = new HashSet<PhylogenyNode>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (hashSet.contains(phylogenyNode)) {
                throw new IllegalArgumentException("node [" + phylogenyNode + "] in target is not unique");
            }
            hashSet.add(phylogenyNode);
            List<Confidence> list = phylogenyNode.getBranchData().getConfidences();
            for (Confidence confidence : list) {
                if (!confidence.getType().equals(string)) continue;
                throw new IllegalArgumentException("confidence [" + string + "] is already present in target");
            }
        }
    }

    public static final void evaluate(String string, Phylogeny[] phylogenyArray, Phylogeny phylogeny, boolean bl, double d) {
        ConfidenceAssessor.evaluate(string, phylogenyArray, phylogeny, bl, d, 0, 0);
    }

    public static final void evaluate(String string, Phylogeny[] phylogenyArray, Phylogeny phylogeny, boolean bl, double d, int n, int n2) {
        ConfidenceAssessor.checkPreconditions(string, phylogenyArray, phylogeny, d, n, n2);
        boolean bl2 = true;
        if (n != 0 || n2 != 0) {
            bl2 = false;
        }
        int n3 = 0;
        HashMap<PhylogenyNode, Set<PhylogenyNode>> hashMap = new HashMap<PhylogenyNode, Set<PhylogenyNode>>();
        for (Phylogeny phylogeny2 : phylogenyArray) {
            if (bl2 || n3 >= n && n3 <= n2) {
                if (bl && phylogeny2.getNumberOfExternalNodes() != phylogeny.getNumberOfExternalNodes()) {
                    throw new IllegalArgumentException("evaluator #" + n3 + " does not have the same number of external nodes [" + phylogeny2.getNumberOfExternalNodes() + "] than the corresponding target [" + phylogeny.getNumberOfExternalNodes() + "]");
                }
                TreeSplitMatrix treeSplitMatrix = new TreeSplitMatrix(phylogeny2, bl, phylogeny);
                PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
                while (phylogenyNodeIterator.hasNext()) {
                    PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
                    if (phylogenyNode.isExternal() || phylogenyNode.isRoot() || phylogenyNode.getParent().isRoot() && phylogeny.getRoot().getNumberOfDescendants() == 2 && (phylogeny.getRoot().getChildNode1().isExternal() || phylogeny.getRoot().getChildNode2().isExternal())) continue;
                    if (!hashMap.containsKey(phylogenyNode)) {
                        ConfidenceAssessor.addExternalNodesToMap(hashMap, phylogenyNode);
                    }
                    Set set = (Set)hashMap.get(phylogenyNode);
                    Confidence confidence = ConfidenceAssessor.obtainConfidence(phylogenyNode, string);
                    if (!treeSplitMatrix.match(set)) continue;
                    confidence.setValue(confidence.getValue() + d);
                }
            }
            ++n3;
        }
    }

    private static final Confidence obtainConfidence(PhylogenyNode phylogenyNode, String string) {
        List<Confidence> list = phylogenyNode.getBranchData().getConfidences();
        Confidence confidence = null;
        for (Confidence confidence2 : list) {
            if (!confidence2.getType().equals(string)) continue;
            if (confidence != null) {
                throw new IllegalArgumentException("confidence [" + string + "] is not unique");
            }
            confidence = confidence2;
        }
        if (confidence == null) {
            confidence = new Confidence(0.0, string);
            list.add(confidence);
        }
        return confidence;
    }
}

