/*
 * Decompiled with CFR 0.152.
 */
package org.forester.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeSplitMatrix {
    private final SortedMap<PhylogenyNode, List<Boolean>> _data;
    private final Map<Integer, Integer> _positive_counts;
    private final boolean _strict;

    public TreeSplitMatrix(Phylogeny phylogeny, boolean bl, Phylogeny phylogeny2) {
        HashSet<PhylogenyNode> hashSet = null;
        if (!bl) {
            if (phylogeny2 == null || phylogeny2.isEmpty()) {
                throw new IllegalArgumentException("target must not be null or empty if non-strict evalution is expected");
            }
            hashSet = new HashSet<PhylogenyNode>();
            PhylogenyNodeIterator phylogenyNodeIterator = phylogeny2.iteratorExternalForward();
            while (phylogenyNodeIterator.hasNext()) {
                hashSet.add(phylogenyNodeIterator.next());
            }
        }
        this._data = new TreeMap<PhylogenyNode, List<Boolean>>();
        this._positive_counts = new HashMap<Integer, Integer>();
        this._strict = bl;
        this.decompose(phylogeny, hashSet);
    }

    public TreeSplitMatrix(Phylogeny phylogeny, boolean bl, Set<PhylogenyNode> set) {
        if (!bl && (set == null || set.isEmpty())) {
            throw new IllegalArgumentException("target nodes list must not be null or empty if non-strict evalution is expected");
        }
        this._data = new TreeMap<PhylogenyNode, List<Boolean>>();
        this._positive_counts = new HashMap<Integer, Integer>();
        this._strict = bl;
        this.decompose(phylogeny, set);
    }

    private boolean contains(PhylogenyNode phylogenyNode) {
        return this._data.keySet().contains(phylogenyNode);
    }

    private void decompose(Phylogeny phylogeny, Set<PhylogenyNode> set) {
        this.setUpKeys(phylogeny, set);
        this.setUpValues(phylogeny, set);
        this.sanityCheck();
    }

    private int getNumberOfTrueValuesAt(int n) {
        if (this._positive_counts.containsKey(n)) {
            return this._positive_counts.get(n);
        }
        return 0;
    }

    private boolean getValue(PhylogenyNode phylogenyNode, int n) {
        if (this._data.containsKey(phylogenyNode)) {
            return (Boolean)((List)this._data.get(phylogenyNode)).get(n);
        }
        return false;
    }

    private char getValueAsChar(PhylogenyNode phylogenyNode, int n) {
        if (this.getValue(phylogenyNode, n)) {
            return '.';
        }
        return ' ';
    }

    private Set<PhylogenyNode> keySet() {
        return this._data.keySet();
    }

    public boolean match(Set<PhylogenyNode> set) {
        Set<PhylogenyNode> set2 = set;
        if (this._strict && !this.keySet().containsAll(set2)) {
            throw new IllegalArgumentException("external nodes of target and evaluator do not match");
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!this.match(set2, i)) continue;
            return true;
        }
        return false;
    }

    private boolean match(Set<PhylogenyNode> set, int n) {
        int n2 = this.getNumberOfTrueValuesAt(n);
        int n3 = set.size();
        boolean bl = true;
        boolean bl2 = true;
        if (n3 != n2) {
            bl = false;
        }
        if (n3 != this.keySet().size() - n2) {
            bl2 = false;
        }
        if (!bl && !bl2) {
            return false;
        }
        for (PhylogenyNode phylogenyNode : set) {
            if (!this.contains(phylogenyNode)) {
                if (this._strict) {
                    throw new IllegalStateException("this should not have happened, for query " + phylogenyNode + ":\n" + this.toString());
                }
                return false;
            }
            if (this.getValue(phylogenyNode, n)) {
                bl2 = false;
            } else {
                bl = false;
            }
            if (bl || bl2) continue;
            return false;
        }
        return true;
    }

    private void sanityCheck() {
        int n = -1;
        for (PhylogenyNode phylogenyNode : this.keySet()) {
            if (n < 0) {
                n = this.size(phylogenyNode);
                continue;
            }
            if (n == this.size(phylogenyNode)) continue;
            throw new IllegalStateException("this should not have happened: failed to build split matrix");
        }
    }

    private void setUpKeys(Phylogeny phylogeny, Set<PhylogenyNode> set) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!this._strict && !set.contains(phylogenyNode)) continue;
            if (this._data.containsKey(phylogenyNode)) {
                throw new IllegalArgumentException("node '" + phylogenyNode.toString() + "' of evaluator is not unique");
            }
            this._data.put(phylogenyNode, new ArrayList());
        }
    }

    private void setUpValues(Phylogeny phylogeny, Set<PhylogenyNode> set) {
        int n = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
            for (PhylogenyNode phylogenyNode2 : this.keySet()) {
                if (list.contains(phylogenyNode2)) {
                    ((List)this._data.get(phylogenyNode2)).add(n, true);
                    if (!this._positive_counts.containsKey(n)) {
                        this._positive_counts.put(n, 1);
                        continue;
                    }
                    this._positive_counts.put(n, this._positive_counts.get(n) + 1);
                    continue;
                }
                ((List)this._data.get(phylogenyNode2)).add(n, false);
            }
            ++n;
        }
    }

    private int size() {
        Iterator<PhylogenyNode> iterator = this.keySet().iterator();
        if (iterator.hasNext()) {
            PhylogenyNode phylogenyNode = iterator.next();
            return this.size(phylogenyNode);
        }
        return 0;
    }

    private int size(PhylogenyNode phylogenyNode) {
        return ((List)this._data.get(phylogenyNode)).size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (PhylogenyNode phylogenyNode : this.keySet()) {
            stringBuffer.append(phylogenyNode.getNodeName());
            stringBuffer.append(":");
            for (int i = 0; i < this.size(phylogenyNode); ++i) {
                stringBuffer.append(" ");
                stringBuffer.append(this.getValueAsChar(phylogenyNode, i));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

