/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class AsciiHistogram {
    private final DescriptiveStatistics _stats;
    private final String _title;

    public AsciiHistogram(DescriptiveStatistics descriptiveStatistics) {
        this._stats = descriptiveStatistics;
        this._title = "";
    }

    public AsciiHistogram(DescriptiveStatistics descriptiveStatistics, String string) {
        this._stats = descriptiveStatistics;
        this._title = string;
    }

    private void drawToStringBuffer(double d, char c, int n, int n2, StringBuffer stringBuffer, int[] nArray, int n3, int n4, int n5, double d2) {
        double d3 = (double)n3 / (double)n;
        int n6 = ForesterUtil.roundToInt(Math.log10(n3)) + 1;
        if (!ForesterUtil.isEmpty(this.getTitle())) {
            stringBuffer.append(this.getTitle());
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        }
        if (n4 > 0) {
            stringBuffer.append("[" + n4 + "] ");
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n7 = nArray[i];
            double d4 = ForesterUtil.round(d + (double)i * (1.0 / d2), n2);
            stringBuffer.append(ForesterUtil.pad(d4 + "", n2, '0', false));
            stringBuffer.append(" [" + ForesterUtil.pad(n7 + "", n6, ' ', true) + "] ");
            int n8 = ForesterUtil.roundToInt((double)n7 / d3);
            for (int j = 0; j < n8; ++j) {
                stringBuffer.append(c);
            }
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        }
        if (n5 > 0) {
            stringBuffer.append("[" + n5 + "] ");
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        }
    }

    private DescriptiveStatistics getDescriptiveStatistics() {
        return this._stats;
    }

    private String getTitle() {
        return this._title;
    }

    public StringBuffer toStringBuffer(double d, double d2, int n, char c, int n2, int n3) {
        int[] nArray;
        if (d >= d2) {
            throw new IllegalArgumentException("min [" + d + "] is larger than or equal to max [" + d2 + "]");
        }
        if (n < 3) {
            throw new IllegalArgumentException("number of bins is smaller than 3");
        }
        if (n2 < 2) {
            throw new IllegalArgumentException("size is smaller than 2");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        double d3 = (double)n / (d2 - d);
        for (int n5 : nArray = BasicDescriptiveStatistics.performBinning(this.getDescriptiveStatistics().getDataAsDoubleArray(), d, d2, n)) {
            if (n5 <= n4) continue;
            n4 = n5;
        }
        this.drawToStringBuffer(d, c, n2, n3, stringBuffer, nArray, n4, 0, 0, d3);
        return stringBuffer;
    }

    public StringBuffer toStringBuffer(int n, char c, int n2, int n3) {
        return this.toStringBuffer(this.getDescriptiveStatistics().getMin(), this.getDescriptiveStatistics().getMax(), n, c, n2, n3);
    }
}

