/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class BasicDescriptiveStatistics
implements DescriptiveStatistics {
    private List<Double> _data;
    private double _sum;
    private double _min;
    private double _max;
    private double _sigma;
    private boolean _recalc_sigma;

    public BasicDescriptiveStatistics() {
        this.init();
    }

    public void addValue(double d) {
        this._recalc_sigma = true;
        this._sum += d;
        this._data.add(new Double(d));
        if (d < this._min) {
            this._min = d;
        }
        if (d > this._max) {
            this._max = d;
        }
    }

    public double arithmeticMean() {
        this.validate();
        return this.getSum() / (double)this.getN();
    }

    public String asSummary() {
        if (this.getN() > 1) {
            return this.arithmeticMean() + "\u00b1" + this.sampleStandardDeviation() + " [" + this.getMin() + "..." + this.getMax() + "]";
        }
        return "" + this.arithmeticMean();
    }

    public double coefficientOfVariation() {
        this.validate();
        return this.sampleStandardDeviation() / this.arithmeticMean();
    }

    public double[] getDataAsDoubleArray() {
        this.validate();
        double[] dArray = new double[this.getN()];
        for (int i = 0; i < this.getN(); ++i) {
            dArray[i] = this.getValue(i);
        }
        return dArray;
    }

    public double getMax() {
        this.validate();
        return this._max;
    }

    public double getMin() {
        this.validate();
        return this._min;
    }

    public int getN() {
        return this._data.size();
    }

    public double getSum() {
        this.validate();
        return this._sum;
    }

    public String getSummaryAsString() {
        this.validate();
        double d = this.arithmeticMean();
        double d2 = this.sampleStandardDeviation();
        return "" + d + '\u00b1' + d2 + " [" + this.getMin() + "..." + this.getMax() + "]";
    }

    public double getValue(int n) {
        this.validate();
        return this._data.get(n);
    }

    private void init() {
        this._data = new ArrayList<Double>();
        this._sum = 0.0;
        this._min = Double.MAX_VALUE;
        this._max = -1.7976931348623157E308;
        this._sigma = 0.0;
        this._recalc_sigma = true;
    }

    public double median() {
        this.validate();
        double d = 0.0;
        if (this.getN() == 1) {
            d = this.getValue(0);
        } else {
            int n = this.getN() / 2;
            double[] dArray = this.getDataAsDoubleArray();
            Arrays.sort(dArray);
            d = dArray.length % 2 == 0 ? (dArray[n - 1] + dArray[n]) / 2.0 : dArray[n];
        }
        return d;
    }

    public double midrange() {
        this.validate();
        return (this._min + this._max) / 2.0;
    }

    public double pearsonianSkewness() {
        this.validate();
        double d = this.arithmeticMean();
        double d2 = this.median();
        double d3 = this.sampleStandardDeviation();
        return 3.0 * (d - d2) / d3;
    }

    public double sampleStandardDeviation() {
        return Math.sqrt(this.sampleVariance());
    }

    public double sampleStandardUnit(double d) {
        this.validate();
        return BasicDescriptiveStatistics.sampleStandardUnit(d, this.arithmeticMean(), this.sampleStandardDeviation());
    }

    public double sampleVariance() {
        this.validate();
        if (this.getN() < 2) {
            throw new ArithmeticException("attempt to calculate sample variance for less then two values");
        }
        return this.sumDeviations() / (double)(this.getN() - 1);
    }

    public double standardErrorOfMean() {
        this.validate();
        return this.sampleStandardDeviation() / Math.sqrt(this.getN());
    }

    public double sumDeviations() {
        this.validate();
        if (this._recalc_sigma) {
            this._recalc_sigma = false;
            this._sigma = 0.0;
            double d = this.arithmeticMean();
            for (int i = 0; i < this.getN(); ++i) {
                this._sigma += Math.pow(this.getValue(i) - d, 2.0);
            }
        }
        return this._sigma;
    }

    public String toString() {
        if (this.getN() < 1) {
            return "empty data set statistics";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Descriptive statistics:");
        stringBuffer.append(ForesterUtil.getLineSeparator());
        stringBuffer.append("n                       : " + this.getN());
        if (this.getN() > 1) {
            stringBuffer.append(ForesterUtil.getLineSeparator());
            stringBuffer.append("min                     : " + this.getMin());
            stringBuffer.append(ForesterUtil.getLineSeparator());
            stringBuffer.append("max                     : " + this.getMax());
            stringBuffer.append(ForesterUtil.getLineSeparator());
            stringBuffer.append("midrange                : " + this.midrange());
            stringBuffer.append(ForesterUtil.getLineSeparator());
            stringBuffer.append("median                  : " + this.median());
            stringBuffer.append(ForesterUtil.getLineSeparator());
            stringBuffer.append("mean                    : " + this.arithmeticMean());
            stringBuffer.append(ForesterUtil.getLineSeparator());
            stringBuffer.append("sd                      : " + this.sampleStandardDeviation());
            stringBuffer.append(ForesterUtil.getLineSeparator());
            stringBuffer.append("variance                : " + this.sampleVariance());
            stringBuffer.append(ForesterUtil.getLineSeparator());
            stringBuffer.append("standard error of mean  : " + this.standardErrorOfMean());
            stringBuffer.append(ForesterUtil.getLineSeparator());
            stringBuffer.append("coefficient of variation: " + this.coefficientOfVariation());
            stringBuffer.append(ForesterUtil.getLineSeparator());
            stringBuffer.append("pearsonian skewness     : " + this.pearsonianSkewness());
        }
        return stringBuffer.toString();
    }

    private void validate() throws ArithmeticException {
        if (this.getN() < 1) {
            throw new ArithmeticException("attempt to get a result from empty data set statistics");
        }
    }

    public static int[] performBinning(double[] dArray, double d, double d2, int n) {
        if (d >= d2) {
            throw new IllegalArgumentException("min [" + d + "] is larger than or equal to max [" + d2 + "]");
        }
        if (n < 3) {
            throw new IllegalArgumentException("number of bins is smaller than 3");
        }
        int[] nArray = new int[n];
        double d3 = (double)n / (d2 - d);
        int n2 = n - 1;
        for (double d4 : dArray) {
            if (d4 > d2 || d4 < d) continue;
            int n3 = (int)((d4 - d) * d3);
            if (n3 > n2) {
                int n4 = n2;
                nArray[n4] = nArray[n4] + 1;
                continue;
            }
            int n5 = n3;
            nArray[n5] = nArray[n5] + 1;
        }
        return nArray;
    }

    public static double sampleStandardUnit(double d, double d2, double d3) {
        return (d - d2) / d3;
    }
}

