/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.tol.TolParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Distribution;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ForesterUtil {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String JAVA_VENDOR = System.getProperty("java.vendor");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final double ZERO_DIFF = 1.0E-9;
    public static final BigDecimal NULL_BD = new BigDecimal(0);
    public static final NumberFormat FORMATTER_9;
    public static final NumberFormat FORMATTER_6;
    public static final NumberFormat FORMATTER_06;
    public static final NumberFormat FORMATTER_3;

    private ForesterUtil() {
    }

    public static final void appendSeparatorIfNotEmpty(StringBuffer stringBuffer, char c) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(c);
        }
    }

    public static final Color calcColor(double d, double d2, double d3, Color color, Color color2) {
        if (d < d2) {
            d = d2;
        }
        if (d > d3) {
            d = d3;
        }
        double d4 = ForesterUtil.calculateColorFactor(d, d3, d2);
        int n = ForesterUtil.calculateColorComponent(color.getRed(), color2.getRed(), d4);
        int n2 = ForesterUtil.calculateColorComponent(color.getGreen(), color2.getGreen(), d4);
        int n3 = ForesterUtil.calculateColorComponent(color.getBlue(), color2.getBlue(), d4);
        return new Color(n, n2, n3);
    }

    public static final Color calcColor(double d, double d2, double d3, double d4, Color color, Color color2, Color color3) {
        if (d < d2) {
            d = d2;
        }
        if (d > d3) {
            d = d3;
        }
        if (d < d4) {
            double d5 = ForesterUtil.calculateColorFactor(d, d4, d2);
            int n = ForesterUtil.calculateColorComponent(color.getRed(), color3.getRed(), d5);
            int n2 = ForesterUtil.calculateColorComponent(color.getGreen(), color3.getGreen(), d5);
            int n3 = ForesterUtil.calculateColorComponent(color.getBlue(), color3.getBlue(), d5);
            return new Color(n, n2, n3);
        }
        if (d > d4) {
            double d6 = ForesterUtil.calculateColorFactor(d, d3, d4);
            int n = ForesterUtil.calculateColorComponent(color3.getRed(), color2.getRed(), d6);
            int n4 = ForesterUtil.calculateColorComponent(color3.getGreen(), color2.getGreen(), d6);
            int n5 = ForesterUtil.calculateColorComponent(color3.getBlue(), color2.getBlue(), d6);
            return new Color(n, n4, n5);
        }
        return color3;
    }

    private static final int calculateColorComponent(double d, double d2, double d3) {
        return (int)(d + d3 * (d2 - d) / 255.0);
    }

    private static final double calculateColorFactor(double d, double d2, double d3) {
        return 255.0 * (d - d3) / (d2 - d3);
    }

    public static final String collapseWhiteSpace(String string) {
        return string.replaceAll("[\\s]+", " ");
    }

    public static final String colorToHex(Color color) {
        String string = Integer.toHexString(color.getRGB());
        return string.substring(2, string.length());
    }

    public static synchronized void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static final int countChars(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    public static final BufferedWriter createBufferedWriter(File file) throws IOException {
        if (file.exists()) {
            throw new IOException("[" + file + "] already exists");
        }
        return new BufferedWriter(new FileWriter(file));
    }

    public static final BufferedWriter createBufferedWriter(String string) throws IOException {
        return new BufferedWriter(new FileWriter(ForesterUtil.createFileForWriting(string)));
    }

    public static final File createFileForWriting(String string) throws IOException {
        File file = new File(string);
        if (file.exists()) {
            throw new IOException("[" + string + "] already exists");
        }
        return file;
    }

    public static final PhylogenyParser createParserDependingFileContents(File file, boolean bl) throws FileNotFoundException, IOException {
        PhylogenyParser phylogenyParser = null;
        String string = ForesterUtil.getFirstLine(file).trim().toLowerCase();
        if (string.startsWith("<")) {
            ClassLoader classLoader;
            URL uRL;
            phylogenyParser = new PhyloXmlParser();
            if (bl && (uRL = (classLoader = PhyloXmlParser.class.getClassLoader()).getResource("resources/phyloxml.xsd")) != null) {
                ((PhyloXmlParser)phylogenyParser).setValidateAgainstSchema(uRL.toString());
            }
        } else {
            phylogenyParser = string.startsWith("nexus") || string.startsWith("#nexus") || string.startsWith("# nexus") || string.startsWith("begin") ? new NexusPhylogeniesParser() : new NHXParser();
        }
        return phylogenyParser;
    }

    public static final PhylogenyParser createParserDependingOnFileType(File file, boolean bl) throws FileNotFoundException, IOException {
        PhylogenyParser phylogenyParser = null;
        phylogenyParser = ForesterUtil.createParserDependingOnSuffix(file.getName(), bl);
        if (phylogenyParser == null) {
            phylogenyParser = ForesterUtil.createParserDependingFileContents(file, bl);
        }
        return phylogenyParser;
    }

    public static final PhylogenyParser createParserDependingOnSuffix(String string, boolean bl) {
        PhylogenyParser phylogenyParser = null;
        String string2 = string.toLowerCase();
        if (string2.endsWith(".tol") || string2.endsWith(".tolxml") || string2.endsWith(".tol.zip")) {
            phylogenyParser = new TolParser();
        } else if (string2.endsWith(".xml") || string2.endsWith(".px") || string2.endsWith("phyloxml") || string2.endsWith(".zip")) {
            ClassLoader classLoader;
            URL uRL;
            phylogenyParser = new PhyloXmlParser();
            if (bl && (uRL = (classLoader = PhyloXmlParser.class.getClassLoader()).getResource("resources/phyloxml.xsd")) != null) {
                ((PhyloXmlParser)phylogenyParser).setValidateAgainstSchema(uRL.toString());
            }
        } else if (string2.endsWith(".nexus") || string2.endsWith(".nex") || string2.endsWith(".nx")) {
            phylogenyParser = new NexusPhylogeniesParser();
        } else if (string2.endsWith(".nhx") || string2.endsWith(".nh") || string2.endsWith(".newick")) {
            phylogenyParser = new NHXParser();
        }
        return phylogenyParser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final PhylogenyParser createParserDependingOnUrlContents(URL uRL, boolean bl) throws FileNotFoundException, IOException {
        String string = uRL.getFile().toString().toLowerCase();
        PhylogenyParser phylogenyParser = ForesterUtil.createParserDependingOnSuffix(string, bl);
        if (phylogenyParser != null && string.endsWith(".zip")) {
            if (phylogenyParser instanceof PhyloXmlParser) {
                ((PhyloXmlParser)phylogenyParser).setZippedInputstream(true);
            } else if (phylogenyParser instanceof TolParser) {
                ((TolParser)phylogenyParser).setZippedInputstream(true);
            }
        }
        if (phylogenyParser != null) return phylogenyParser;
        String string2 = ForesterUtil.getFirstLine(uRL).trim().toLowerCase();
        if (!string2.startsWith("<")) {
            if (string2.startsWith("nexus")) return new NexusPhylogeniesParser();
            if (string2.startsWith("#nexus")) return new NexusPhylogeniesParser();
            if (string2.startsWith("# nexus")) return new NexusPhylogeniesParser();
            if (!string2.startsWith("begin")) return new NHXParser();
            return new NexusPhylogeniesParser();
        }
        phylogenyParser = new PhyloXmlParser();
        if (!bl) return phylogenyParser;
        ClassLoader classLoader = PhyloXmlParser.class.getClassLoader();
        URL uRL2 = classLoader.getResource("resources/phyloxml.xsd");
        if (uRL2 == null) throw new IllegalStateException("failed to get URL for phyloXML XSD from jar file from [resources/phyloxml.xsd]");
        ((PhyloXmlParser)phylogenyParser).setValidateAgainstSchema(uRL2.toString());
        return phylogenyParser;
    }

    public static final void ensurePresenceOfDate(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasDate()) {
            phylogenyNode.getNodeData().setDate(new org.forester.phylogeny.data.Date());
        }
    }

    public static final void ensurePresenceOfDistribution(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasDistribution()) {
            phylogenyNode.getNodeData().setDistribution(new Distribution(""));
        }
    }

    public static void ensurePresenceOfSequence(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasSequence()) {
            phylogenyNode.getNodeData().setSequence(new Sequence());
        }
    }

    public static void ensurePresenceOfTaxonomy(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
            phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
        }
    }

    public static String extractTaxonomyCodeFromNodeName(String string, boolean bl, TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION) {
        String[] stringArray;
        if (!(string.indexOf("_") <= 0 || string.length() >= 25 || string.lastIndexOf("_") != string.indexOf("_") || string.indexOf("|") >= 0 || string.indexOf(".") >= 0 || tAXONOMY_EXTRACTION == TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY && string.indexOf("/") < 0 || string.indexOf("/") >= 0 && string.indexOf("/") <= string.indexOf("_") || (stringArray = string.split("[_/]")).length <= 1)) {
            Matcher matcher;
            String string2 = stringArray[1];
            if (bl) {
                if (string2.length() > 5) {
                    string2 = string2.substring(0, 5);
                } else if (string2.length() < 5 && (string2.startsWith("RAT") || string2.startsWith("PIG"))) {
                    string2 = string2.substring(0, 3);
                }
            }
            if (!(matcher = NHXParser.UC_LETTERS_NUMBERS_PATTERN.matcher(string2)).matches()) {
                return null;
            }
            Matcher matcher2 = NHXParser.NUMBERS_ONLY_PATTERN.matcher(string2);
            if (matcher2.matches()) {
                return null;
            }
            return string2;
        }
        return null;
    }

    public static void fatalError(String string, String string2) {
        System.err.println();
        System.err.println("[" + string + "] > " + string2);
        System.err.println();
        System.exit(-1);
    }

    public static String[] file2array(File file) throws IOException {
        List<String> list = ForesterUtil.file2list(file);
        String[] stringArray = new String[list.size()];
        int n = 0;
        for (String string : list) {
            stringArray[n++] = string;
        }
        return stringArray;
    }

    public static final List<String> file2list(File file) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() <= 0 || string.startsWith("#")) continue;
            for (String string2 : ForesterUtil.splitString(string)) {
                arrayList.add(string2);
            }
        }
        bufferedReader.close();
        return arrayList;
    }

    public static final SortedSet<String> file2set(File file) throws IOException {
        String string;
        TreeSet<String> treeSet = new TreeSet<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() <= 0 || string.startsWith("#")) continue;
            for (String string2 : ForesterUtil.splitString(string)) {
                treeSet.add(string2);
            }
        }
        bufferedReader.close();
        return treeSet;
    }

    public static final String getCurrentDateTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return simpleDateFormat.format(new Date());
    }

    public static final String getFileSeparator() {
        return FILE_SEPARATOR;
    }

    public static final String getFirstLine(Object object) throws FileNotFoundException, IOException {
        Object object2;
        BufferedReader bufferedReader = null;
        if (object instanceof File) {
            object2 = (File)object;
            if (!((File)object2).exists()) {
                throw new IOException("[" + ((File)object2).getAbsolutePath() + "] does not exist");
            }
            if (!((File)object2).isFile()) {
                throw new IOException("[" + ((File)object2).getAbsolutePath() + "] is not a file");
            }
            if (!((File)object2).canRead()) {
                throw new IOException("[" + ((File)object2).getAbsolutePath() + "] is not a readable");
            }
            bufferedReader = new BufferedReader(new FileReader((File)object2));
        } else if (object instanceof InputStream) {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
        } else if (object instanceof String) {
            bufferedReader = new BufferedReader(new StringReader((String)object));
        } else if (object instanceof StringBuffer) {
            bufferedReader = new BufferedReader(new StringReader(object.toString()));
        } else if (object instanceof URL) {
            bufferedReader = new BufferedReader(new InputStreamReader(((URL)object).openStream()));
        } else {
            throw new IllegalArgumentException("dont know how to read [" + object.getClass() + "]");
        }
        while ((object2 = bufferedReader.readLine()) != null) {
            if (ForesterUtil.isEmpty((String)(object2 = ((String)object2).trim()))) continue;
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            return object2;
        }
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        return object2;
    }

    public static final String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public static final Hashtable<String, Boolean> getPropertyRefs(Phylogeny phylogeny) {
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        if (phylogeny.isEmpty()) {
            return hashtable;
        }
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasProperties()) continue;
            String[] stringArray = phylogenyNode.getNodeData().getProperties().getPropertyRefs();
            for (int i = 0; i < stringArray.length; ++i) {
                hashtable.put(stringArray[i], new Boolean(false));
            }
        }
        return hashtable;
    }

    public static final void increaseCountingMap(Map<String, Integer> map, String string) {
        if (!map.containsKey(string)) {
            map.put(string, 1);
        } else {
            map.put(string, map.get(string) + 1);
        }
    }

    public static final boolean isAllNonEmptyInternalLabelsArePositiveNumbers(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isRoot() || phylogenyNode.isExternal() || ForesterUtil.isEmpty(phylogenyNode.getNodeName())) continue;
            double d = -1.0;
            try {
                d = Double.parseDouble(phylogenyNode.getNodeName());
            }
            catch (Exception exception) {
                d = -1.0;
            }
            if (!(d < 0.0)) continue;
            return false;
        }
        return true;
    }

    public static final boolean isEmpty(String string) {
        return string == null || string.length() < 1;
    }

    public static final boolean isEqual(double d, double d2) {
        return Math.abs(d - d2) < 1.0E-9;
    }

    public static final boolean isEven(int n) {
        return n % 2 == 0;
    }

    public static final boolean isHasAtLeastNodeWithEvent(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            if (!phylogenyNodeIterator.next().getNodeData().isHasEvent()) continue;
            return true;
        }
        return false;
    }

    public static final boolean isHasAtLeastOneBranchLengthLargerThanZero(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            if (!(phylogenyNodeIterator.next().getDistanceToParent() > 0.0)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isHasAtLeastOneBranchWithSupportValues(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            if (!phylogenyNodeIterator.next().getBranchData().isHasConfidences()) continue;
            return true;
        }
        return false;
    }

    public static final boolean isIntersecting(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        if (stringArray.length < 1 || stringArray2.length < 1) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            for (int j = 0; j < stringArray2.length; ++j) {
                if (string == null || stringArray2[j] == null || !string.equals(stringArray2[j])) continue;
                return true;
            }
        }
        return false;
    }

    public static final double isLargerOrEqualToZero(double d) {
        if (d > 0.0) {
            return d;
        }
        return 0.0;
    }

    public static final boolean isNull(BigDecimal bigDecimal) {
        return bigDecimal == null || bigDecimal.compareTo(NULL_BD) == 0;
    }

    public static final String isReadableFile(File file) {
        if (!file.exists()) {
            return "file [" + file + "] does not exist";
        }
        if (file.isDirectory()) {
            return "[" + file + "] is a directory";
        }
        if (!file.isFile()) {
            return "[" + file + "] is not a file";
        }
        if (!file.canRead()) {
            return "file [" + file + "] is not readable";
        }
        if (file.length() < 1L) {
            return "file [" + file + "] is empty";
        }
        return null;
    }

    public static final String isReadableFile(String string) {
        return ForesterUtil.isReadableFile(new File(string));
    }

    public static final String isWritableFile(File file) {
        if (file.isDirectory()) {
            return "[" + file + "] is a directory";
        }
        if (file.exists()) {
            return "[" + file + "] already exists";
        }
        return null;
    }

    public static final int limitRangeForColor(int n) {
        if (n > 255) {
            n = 255;
        } else if (n < 0) {
            n = 0;
        }
        return n;
    }

    public static final SortedMap<Object, Integer> listToSortedCountsMap(List list) {
        TreeMap<Object, Integer> treeMap = new TreeMap<Object, Integer>();
        for (Object e : list) {
            if (!treeMap.containsKey(e)) {
                treeMap.put(e, 1);
                continue;
            }
            treeMap.put(e, (Integer)treeMap.get(e) + 1);
        }
        return treeMap;
    }

    public static final StringBuffer mapToStringBuffer(Map map, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object k : map.keySet()) {
            stringBuffer.append(k.toString());
            stringBuffer.append(string);
            stringBuffer.append(map.get(k).toString());
            stringBuffer.append(ForesterUtil.getLineSeparator());
        }
        return stringBuffer;
    }

    public static final String normalizeString(String string, int n, boolean bl, char c) {
        if (string.length() > n) {
            return string.substring(0, n);
        }
        StringBuffer stringBuffer = new StringBuffer(n - string.length());
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuffer.append(c);
        }
        if (bl) {
            return stringBuffer + string;
        }
        return string + stringBuffer;
    }

    public static final BufferedReader obtainReader(Object object) throws IOException, FileNotFoundException {
        BufferedReader bufferedReader = null;
        if (object instanceof File) {
            File file = (File)object;
            if (!file.exists()) {
                throw new IOException("\"" + file.getAbsolutePath() + "\" does not exist");
            }
            if (!file.isFile()) {
                throw new IOException("\"" + file.getAbsolutePath() + "\" is not a file");
            }
            if (!file.canRead()) {
                throw new IOException("\"" + file.getAbsolutePath() + "\" is not a readable");
            }
            bufferedReader = new BufferedReader(new FileReader(file));
        } else if (object instanceof InputStream) {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
        } else if (object instanceof String) {
            bufferedReader = new BufferedReader(new StringReader((String)object));
        } else if (object instanceof StringBuffer) {
            bufferedReader = new BufferedReader(new StringReader(object.toString()));
        } else {
            throw new IllegalArgumentException("attempt to parse object of type [" + object.getClass() + "] (can only parse objects of type File, InputStream, String, or StringBuffer)");
        }
        return bufferedReader;
    }

    public static final StringBuffer pad(double d, int n, char c, boolean bl) {
        return ForesterUtil.pad(new StringBuffer(d + ""), n, c, bl);
    }

    public static final StringBuffer pad(String string, int n, char c, boolean bl) {
        return ForesterUtil.pad(new StringBuffer(string), n, c, bl);
    }

    public static final StringBuffer pad(StringBuffer stringBuffer, int n, char c, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = n - stringBuffer.length();
        if (n2 < 1) {
            return new StringBuffer(stringBuffer.substring(0, n));
        }
        for (int i = 0; i < n2; ++i) {
            stringBuffer2.append(c);
        }
        if (bl) {
            return stringBuffer2.append(stringBuffer);
        }
        return stringBuffer.append(stringBuffer2);
    }

    public static final double parseDouble(String string) throws ParseException {
        if (ForesterUtil.isEmpty(string)) {
            return 0.0;
        }
        return Double.parseDouble(string);
    }

    public static final int parseInt(String string) throws ParseException {
        if (ForesterUtil.isEmpty(string)) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public static final void postOrderRelabelInternalNodes(Phylogeny phylogeny, int n) {
        int n2 = n;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal()) continue;
            phylogenyNode.setName(String.valueOf(n2++));
        }
    }

    public static final void printArray(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            System.out.println("[" + i + "]=" + objectArray[i]);
        }
    }

    public static final void printCountingMap(Map<String, Integer> map) {
        for (String string : map.keySet()) {
            System.out.println(string + ": " + map.get(string));
        }
    }

    public static final void printErrorMessage(String string, String string2) {
        System.out.println("[" + string + "] > error: " + string2);
    }

    public static final void printProgramInformation(String string, String string2, String string3) {
        int n = string.length() + string2.length() + string3.length() + 4;
        System.out.println();
        System.out.println(string + " " + string2 + " (" + string3 + ")");
        for (int i = 0; i < n; ++i) {
            System.out.print("_");
        }
        System.out.println();
    }

    public static final void printProgramInformation(String string, String string2, String string3, String string4, String string5) {
        int n = string.length() + string2.length() + string3.length() + 4;
        System.out.println();
        System.out.println(string + " " + string2 + " (" + string3 + ")");
        for (int i = 0; i < n; ++i) {
            System.out.print("_");
        }
        System.out.println();
        System.out.println();
        System.out.println("WWW    : " + string5);
        System.out.println("Contact: " + string4);
        if (!ForesterUtil.isEmpty(JAVA_VERSION) && !ForesterUtil.isEmpty(JAVA_VENDOR)) {
            System.out.println();
            System.out.println("[running on Java " + JAVA_VERSION + " " + JAVA_VENDOR + "]");
        }
        System.out.println();
    }

    public static final void printWarningMessage(String string, String string2) {
        System.out.println("[" + string + "] > warning: " + string2);
    }

    public static final void programMessage(String string, String string2) {
        System.out.println("[" + string + "] > " + string2);
    }

    public static final String removeSuffix(String string) {
        int n = string.lastIndexOf(46);
        if (n > 1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static final String removeWhiteSpace(String string) {
        for (int i = 0; i <= string.length() - 1; ++i) {
            if (string.charAt(i) != ' ' && string.charAt(i) != '\t' && string.charAt(i) != '\n' && string.charAt(i) != '\r') continue;
            string = string.substring(0, i) + string.substring(i + 1);
            --i;
        }
        return string;
    }

    public static final String replaceIllegalNhCharacters(String string) {
        if (string == null) {
            return "";
        }
        return string.trim().replaceAll("[\\[\\](),:;\\s]+", "_");
    }

    public static final String replaceIllegalNhxCharacters(String string) {
        if (string == null) {
            return "";
        }
        return string.trim().replaceAll("[\\[\\](),:;\\s]+", "_");
    }

    public static final double round(double d, int n) {
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(n, 4);
        return bigDecimal.doubleValue();
    }

    public static final int roundToInt(double d) {
        return (int)(d + 0.5);
    }

    public static final int roundToInt(float f) {
        return (int)(f + 0.5f);
    }

    public static final String sanitizeString(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    private static final String[] splitString(String string) {
        return string.split("[\\s;,]+");
    }

    public static final String stringArrayToString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuffer.append(stringArray[i] + ", ");
            }
            stringBuffer.append(stringArray[stringArray.length - 1]);
        }
        return stringBuffer.toString();
    }

    public static final void transferInternalNamesToBootstrapSupport(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || ForesterUtil.isEmpty(phylogenyNode.getNodeName())) continue;
            double d = -1.0;
            try {
                d = Double.parseDouble(phylogenyNode.getNodeName());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("failed to parse number from [" + phylogenyNode.getNodeName() + "]: " + numberFormatException.getLocalizedMessage());
            }
            if (!(d >= 0.0)) continue;
            phylogenyNode.getBranchData().addConfidence(new Confidence(d, "bootstrap"));
            phylogenyNode.setName("");
        }
    }

    public static final void transferInternalNodeNamesToConfidence(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isRoot() || phylogenyNode.isExternal() || phylogenyNode.getBranchData().isHasConfidences() || ForesterUtil.isEmpty(phylogenyNode.getNodeName())) continue;
            double d = -1.0;
            try {
                d = Double.parseDouble(phylogenyNode.getNodeName());
            }
            catch (Exception exception) {
                d = -1.0;
            }
            if (!(d >= 0.0)) continue;
            phylogenyNode.getBranchData().addConfidence(new Confidence(d, ""));
            phylogenyNode.setName("");
        }
    }

    public static final void transferNodeNameToField(Phylogeny phylogeny, PhylogenyNodeField phylogenyNodeField) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            String string = phylogenyNode.getNodeName().trim();
            if (ForesterUtil.isEmpty(string)) continue;
            switch (phylogenyNodeField) {
                case TAXONOMY_CODE: {
                    phylogenyNode.setName("");
                    PhylogenyMethods.setTaxonomyCode(phylogenyNode, string);
                    break;
                }
                case TAXONOMY_SCIENTIFIC_NAME: {
                    phylogenyNode.setName("");
                    if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                        phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    phylogenyNode.getNodeData().getTaxonomy().setScientificName(string);
                    break;
                }
                case TAXONOMY_COMMON_NAME: {
                    phylogenyNode.setName("");
                    if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                        phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    phylogenyNode.getNodeData().getTaxonomy().setCommonName(string);
                    break;
                }
                case SEQUENCE_SYMBOL: {
                    phylogenyNode.setName("");
                    if (!phylogenyNode.getNodeData().isHasSequence()) {
                        phylogenyNode.getNodeData().setSequence(new Sequence());
                    }
                    phylogenyNode.getNodeData().getSequence().setSymbol(string);
                    break;
                }
                case SEQUENCE_NAME: {
                    phylogenyNode.setName("");
                    if (!phylogenyNode.getNodeData().isHasSequence()) {
                        phylogenyNode.getNodeData().setSequence(new Sequence());
                    }
                    phylogenyNode.getNodeData().getSequence().setName(string);
                }
            }
        }
    }

    public static final void unexpectedFatalError(String string, Exception exception) {
        System.err.println();
        System.err.println("[" + string + "] > unexpected error (Should not have occured! Please contact program author(s).)");
        exception.printStackTrace(System.err);
        System.err.println();
        System.exit(-1);
    }

    public static final void unexpectedFatalError(String string, String string2) {
        System.err.println();
        System.err.println("[" + string + "] > unexpected error. Should not have occured! Please contact program author(s).");
        System.err.println(string2);
        System.err.println();
        System.exit(-1);
    }

    public static final void unexpectedFatalError(String string, String string2, Exception exception) {
        System.err.println();
        System.err.println("[" + string + "] > unexpected error. Should not have occured! Please contact program author(s).");
        System.err.println(string2);
        exception.printStackTrace(System.err);
        System.err.println();
        System.exit(-1);
    }

    public static final String wordWrap(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (stringBuilder.charAt(i) == ' ') {
                n3 = i;
            }
            if (stringBuilder.charAt(i) == '\n') {
                n3 = -1;
                n2 = i + 1;
            }
            if (i <= n2 + n - 1) continue;
            if (n3 != -1) {
                stringBuilder.setCharAt(n3, '\n');
                n2 = n3 + 1;
                n3 = -1;
                continue;
            }
            stringBuilder.insert(i, '\n');
            n2 = i + 1;
        }
        return stringBuilder.toString();
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        FORMATTER_9 = new DecimalFormat("#.#########", decimalFormatSymbols);
        FORMATTER_6 = new DecimalFormat("#.######", decimalFormatSymbols);
        FORMATTER_06 = new DecimalFormat("0.######", decimalFormatSymbols);
        FORMATTER_3 = new DecimalFormat("#.###", decimalFormatSymbols);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TAXONOMY_EXTRACTION {
        NO,
        YES,
        PFAM_STYLE_ONLY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PhylogenyNodeField {
        CLADE_NAME,
        TAXONOMY_CODE,
        TAXONOMY_SCIENTIFIC_NAME,
        TAXONOMY_COMMON_NAME,
        SEQUENCE_SYMBOL,
        SEQUENCE_NAME;

    }
}

