/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.uniprot;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.forester.util.ForesterUtil;
import org.forester.ws.uniprot.UniProtTaxonomy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UniProtWsTools {
    private static final String BASE_URL = "http://www.uniprot.org/";
    private static final String URL_ENC = "UTF-8";
    private static final boolean DEBUG = false;

    private static synchronized String encode(String string) throws UnsupportedEncodingException {
        return URLEncoder.encode(string.trim(), URL_ENC);
    }

    public static synchronized List<UniProtTaxonomy> getTaxonomiesFromCommonName(String string, int n) throws IOException {
        List<String> list = UniProtWsTools.getTaxonomyStringFromCommonName(string, n);
        if (list.size() > 0) {
            return UniProtWsTools.parseUniProtTaxonomy(list);
        }
        return null;
    }

    public static synchronized List<UniProtTaxonomy> getTaxonomiesFromCommonNameStrict(String string, int n) throws IOException {
        List<UniProtTaxonomy> list = UniProtWsTools.getTaxonomiesFromCommonName(string, n);
        if (list != null && list.size() > 0) {
            ArrayList<UniProtTaxonomy> arrayList = new ArrayList<UniProtTaxonomy>();
            for (UniProtTaxonomy uniProtTaxonomy : list) {
                if (!uniProtTaxonomy.getCommonName().equalsIgnoreCase(string)) continue;
                arrayList.add(uniProtTaxonomy);
            }
            return arrayList;
        }
        return null;
    }

    public static synchronized List<UniProtTaxonomy> getTaxonomiesFromId(String string, int n) throws IOException {
        List<String> list = UniProtWsTools.getTaxonomyStringFromId(string, n);
        if (list.size() > 0) {
            return UniProtWsTools.parseUniProtTaxonomy(list);
        }
        return null;
    }

    public static synchronized List<UniProtTaxonomy> getTaxonomiesFromScientificName(String string, int n) throws IOException {
        if (string.equals("Drosophila")) {
            return UniProtWsTools.hack(UniProtTaxonomy.DROSOPHILA_GENUS);
        }
        if (string.equals("Xenopus")) {
            return UniProtWsTools.hack(UniProtTaxonomy.XENOPUS_GENUS);
        }
        List<String> list = UniProtWsTools.getTaxonomyStringFromScientificName(string, n);
        if (list.size() > 0) {
            return UniProtWsTools.parseUniProtTaxonomy(list);
        }
        return null;
    }

    public static synchronized List<UniProtTaxonomy> getTaxonomiesFromScientificNameStrict(String string, int n) throws IOException {
        List<UniProtTaxonomy> list = UniProtWsTools.getTaxonomiesFromScientificName(string, n);
        if (list != null && list.size() > 0) {
            ArrayList<UniProtTaxonomy> arrayList = new ArrayList<UniProtTaxonomy>();
            for (UniProtTaxonomy uniProtTaxonomy : list) {
                if (!uniProtTaxonomy.getScientificName().equalsIgnoreCase(string)) continue;
                arrayList.add(uniProtTaxonomy);
            }
            return arrayList;
        }
        return null;
    }

    public static synchronized List<UniProtTaxonomy> getTaxonomiesFromTaxonomyCode(String string, int n) throws IOException {
        String string2 = new String(string);
        if (string2.equals("FUGRU")) {
            string2 = "TAKRU";
        } else if (string2.equals("CAP")) {
            return UniProtWsTools.hack(UniProtTaxonomy.CAPITELLA_TELATA_SPECIES);
        }
        List<String> list = UniProtWsTools.getTaxonomyStringFromTaxonomyCode(string2, n);
        if (list.size() > 0) {
            return UniProtWsTools.parseUniProtTaxonomy(list);
        }
        return null;
    }

    private static synchronized List<String> getTaxonomyStringFromCommonName(String string, int n) throws IOException {
        return UniProtWsTools.queryUniprot("taxonomy/?query=common%3a%22" + UniProtWsTools.encode(string) + "%22&format=tab", n);
    }

    private static synchronized List<String> getTaxonomyStringFromId(String string, int n) throws IOException {
        return UniProtWsTools.queryUniprot("taxonomy/?query=id%3a%22" + UniProtWsTools.encode(string) + "%22&format=tab", n);
    }

    private static synchronized List<String> getTaxonomyStringFromScientificName(String string, int n) throws IOException {
        return UniProtWsTools.queryUniprot("taxonomy/?query=scientific%3a%22" + UniProtWsTools.encode(string) + "%22&format=tab", n);
    }

    private static synchronized List<String> getTaxonomyStringFromTaxonomyCode(String string, int n) throws IOException {
        return UniProtWsTools.queryUniprot("taxonomy/?query=mnemonic%3a%22" + UniProtWsTools.encode(string) + "%22&format=tab", n);
    }

    private static synchronized List<UniProtTaxonomy> hack(UniProtTaxonomy uniProtTaxonomy) {
        ArrayList<UniProtTaxonomy> arrayList = new ArrayList<UniProtTaxonomy>();
        arrayList.add(uniProtTaxonomy);
        return arrayList;
    }

    private static synchronized List<UniProtTaxonomy> parseUniProtTaxonomy(List<String> list) throws IOException {
        ArrayList<UniProtTaxonomy> arrayList = new ArrayList<UniProtTaxonomy>();
        for (String string : list) {
            if (ForesterUtil.isEmpty(string) || string.startsWith("Taxon")) continue;
            arrayList.add(new UniProtTaxonomy(string));
        }
        return arrayList;
    }

    public static synchronized List<String> queryUniprot(String string, int n) throws IOException {
        String string2;
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("illegal attempt to use empty query ");
        }
        if (n < 1) {
            n = 1;
        }
        URL uRL = new URL(BASE_URL + string);
        URLConnection uRLConnection = uRL.openConnection();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            arrayList.add(string2);
            if (arrayList.size() <= n) continue;
        }
        bufferedReader.close();
        return arrayList;
    }
}

