/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.wabi;

import java.io.IOException;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.util.ForesterUtil;
import org.forester.ws.wabi.TxSearch;

public final class WabiTools {
    private static String getATxName(Taxonomy taxonomy) throws IOException {
        String string = null;
        if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) {
            string = taxonomy.getScientificName();
        } else if (!ForesterUtil.isEmpty(taxonomy.getCommonName())) {
            string = taxonomy.getCommonName();
        }
        if (ForesterUtil.isEmpty(string)) {
            String string2 = null;
            if (PhylogenyMethods.isTaxonomyHasIdentifierOfGivenProvider(taxonomy, new String[]{"uniprot", "ncbi"})) {
                string2 = taxonomy.getIdentifier().getValue();
            }
            if (!ForesterUtil.isEmpty(string2)) {
                string = TxSearch.getTxName(string2);
            }
        }
        return string;
    }

    public static String[] obtainLineage(Taxonomy taxonomy) throws IOException {
        String[] stringArray;
        String string = WabiTools.getATxName(taxonomy);
        String string2 = null;
        if (!ForesterUtil.isEmpty(string)) {
            string2 = TxSearch.searchParam(string, TxSearch.TAX_NAME_CLASS.ALL, TxSearch.TAX_RANK.ALL, 2, true);
        }
        if (!ForesterUtil.isEmpty(string2) && (stringArray = TxSearch.getLineage(string2)) != null) {
            String[] stringArray2 = new String[stringArray.length + 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = stringArray[i];
            }
            stringArray2[stringArray.length] = string;
            return stringArray2;
        }
        return null;
    }

    public static String obtainRank(Taxonomy taxonomy) throws IOException {
        String string = WabiTools.searchParam(taxonomy);
        if (!ForesterUtil.isEmpty(string)) {
            return TxSearch.getTaxonomicRank(string);
        }
        return null;
    }

    private static String searchParam(Taxonomy taxonomy) throws IOException {
        String string = WabiTools.getATxName(taxonomy);
        String string2 = null;
        if (!ForesterUtil.isEmpty(string)) {
            string2 = TxSearch.searchParam(string, TxSearch.TAX_NAME_CLASS.ALL, TxSearch.TAX_RANK.ALL, 2, true);
        }
        return string2;
    }
}

