/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.plugintypes.DataCanvas;
import org.biolegato.core.properties.PropertiesListener;
import org.biolegato.gdesupport.canvas.ClipboardWrapper;
import org.biolegato.gdesupport.canvas.GDECanvasObject;
import org.biolegato.gdesupport.canvas.GDECanvasProperties;
import org.biolegato.gdesupport.canvas.data.Cell;
import org.biolegato.gdesupport.canvas.data.GDEModel;
import org.biolegato.gdesupport.canvas.list.GDEList;
import org.biolegato.gdesupport.canvas.listeners.CursorListener;
import org.biolegato.gdesupport.canvas.listeners.ModeListener;
import org.biolegato.gdesupport.canvas.textarea.BLTextArea;
import org.biolegato.gdesupport.canvas.textarea.GDETextArea;
import org.biolegato.gdesupport.canvas.textarea.UndoableGDETextArea;
import org.biolegato.gdesupport.canvas.undo.Undoable;
import org.biolegato.gdesupport.formats.DataFormat;

public class GDECanvas
extends Box
implements DataCanvas,
ListSelectionListener,
CursorListener,
ModeListener,
PropertiesListener {
    private final GDEModel datamodel = new GDEModel();
    private GDEList nameList = new GDEList(this);
    private GDETextArea dataCollector = null;
    private GDETextArea altDataCollector = null;
    private GDECanvasObject currentPane = this.nameList;
    private static final long serialVersionUID = 7526472295622776154L;
    private JScrollPane dataPane;
    private JScrollPane altDataPane;
    private Box canvasPane = new Box(2);
    private JSplitPane splitPane;
    private final GDECanvas canvasSelf = this;
    private final JLabel status = new JLabel("Row: 1 Col: 1");
    private final JLabel insertStatus = new JLabel("     ");
    private Stack<Undoable> undoStack = new Stack();
    private Stack<Undoable> redoStack = new Stack();
    private final AbstractAction splitAction = new AbstractAction("Split"){
        private static final long serialVersionUID = 7526472295622777032L;

        public void actionPerformed(ActionEvent e) {
            if ("true".equalsIgnoreCase(BLMain.getProperty((String)"undo"))) {
                GDECanvas.this.altDataCollector = new UndoableGDETextArea(GDECanvas.this.canvasSelf);
            } else {
                GDECanvas.this.altDataCollector = new GDETextArea(GDECanvas.this.canvasSelf);
            }
            GDECanvas.this.canvasPane.remove(GDECanvas.this.dataPane);
            GDECanvas.this.altDataPane = new JScrollPane(GDECanvas.this.altDataCollector, 22, 32);
            GDECanvas.this.splitPane = new JSplitPane(1, GDECanvas.this.dataPane, GDECanvas.this.altDataPane);
            GDECanvas.this.splitPane.setAlignmentX(0.5f);
            GDECanvas.this.splitPane.setAlignmentY(0.5f);
            GDECanvas.this.canvasPane.add(GDECanvas.this.splitPane);
            GDECanvas.this.dataCollector.removePopupMenuItem(GDECanvas.this.splitMenuItem);
            GDECanvas.this.dataCollector.addPopupMenuItem(GDECanvas.this.joinMenuItem);
            GDECanvas.this.altDataCollector.addPopupMenuItem(new JMenuItem(GDECanvas.this.joinAction));
        }
    };
    public final AbstractAction joinAction = new AbstractAction("Join"){
        private static final long serialVersionUID = 7526472295622777032L;

        public void actionPerformed(ActionEvent e) {
            if (GDECanvas.this.currentPane == GDECanvas.this.altDataCollector) {
                GDECanvas.this.currentPane = GDECanvas.this.dataCollector;
            }
            if (GDECanvas.this.splitPane != null) {
                GDECanvas.this.canvasPane.remove(GDECanvas.this.splitPane);
                GDECanvas.this.splitPane = null;
                GDECanvas.this.altDataPane = null;
                GDECanvas.this.canvasPane.add(GDECanvas.this.dataPane);
            }
            GDECanvas.this.dataCollector.removePopupMenuItem(GDECanvas.this.joinMenuItem);
            GDECanvas.this.dataCollector.addPopupMenuItem(GDECanvas.this.splitMenuItem);
        }
    };
    public final AbstractAction cutAction = new AbstractAction("Cut"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.canvasSelf.cut();
        }
    };
    public final AbstractAction copyAction = new AbstractAction("Copy"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(89));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.canvasSelf.copy();
        }
    };
    public final AbstractAction pasteAction = new AbstractAction("Paste"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(80));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.canvasSelf.paste();
        }
    };
    public final AbstractAction undoAction = new AbstractAction("Undo"){
        private static final long serialVersionUID = 7526472295622777038L;
        {
            this.putValue("MnemonicKey", new Integer(85));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.canvasSelf.undo();
        }
    };
    public final AbstractAction redoAction = new AbstractAction("Redo"){
        private static final long serialVersionUID = 7526472295622777039L;
        {
            this.putValue("MnemonicKey", new Integer(82));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.canvasSelf.redo();
        }
    };
    public final AbstractAction changeCaseAction = new AbstractAction("Change case"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(69));
        }

        public void actionPerformed(ActionEvent evt) {
            GDECanvas.this.canvasSelf.changeCase();
        }
    };
    private final JMenuItem selectByNameMenuItem;
    private final JMenuItem splitMenuItem;
    private final JMenuItem joinMenuItem;
    private final JMenuItem cutMenuItem;
    private final JMenuItem copyMenuItem;
    private final JMenuItem pasteMenuItem;
    private final JMenuItem undoMenuItem;
    private final JMenuItem redoMenuItem;
    private final JMenuItem changeCaseMenuItem;
    private final JMenuItem selectGroupMenuItem;
    private final JMenuItem selectAllMenuItem;
    private final JMenuItem groupMenuItem;
    private final JMenuItem ungroupMenuItem;
    private final JMenuItem getInfoMenuItem;
    public final GDECanvas gdeCanvasSelf;

    public GDECanvas() {
        super(3);
        this.selectByNameMenuItem = new JMenuItem(this.nameList.selectByNameAction);
        this.splitMenuItem = new JMenuItem(this.splitAction);
        this.joinMenuItem = new JMenuItem(this.joinAction);
        this.cutMenuItem = new JMenuItem(this.cutAction);
        this.copyMenuItem = new JMenuItem(this.copyAction);
        this.pasteMenuItem = new JMenuItem(this.pasteAction);
        this.undoMenuItem = new JMenuItem(this.undoAction);
        this.redoMenuItem = new JMenuItem(this.redoAction);
        this.changeCaseMenuItem = new JMenuItem(this.changeCaseAction);
        this.selectGroupMenuItem = new JMenuItem(this.nameList.selectGroupAction);
        this.selectAllMenuItem = new JMenuItem(this.nameList.selectAllAction);
        this.groupMenuItem = new JMenuItem(this.nameList.groupAction);
        this.ungroupMenuItem = new JMenuItem(this.nameList.ungroupAction);
        this.getInfoMenuItem = new JMenuItem(this.nameList.getInfoAction);
        this.gdeCanvasSelf = this;
        int menuInsertCount = 0;
        BLMain.setProperty((String)"font.bold", (String)"false");
        BLMain.addMenuItem((int)0, (String)"File", (JMenuItem)new JMenuItem(new AbstractAction("Open..."){
            private static final long serialVersionUID = 7526472295622776157L;
            {
                this.putValue("MnemonicKey", new Integer(79));
            }

            public void actionPerformed(ActionEvent evt) {
                JFileChooser openDialog = new JFileChooser();
                openDialog.setCurrentDirectory(BLMain.getCurrentPWD());
                openDialog.setAcceptAllFileFilterUsed(true);
                openDialog.setMultiSelectionEnabled(true);
                DataFormat.addFormats(openDialog, BLMain.getProperty((String)"default.fileformat").toString());
                if (openDialog.showOpenDialog(BLMain.getJFrame()) == 0) {
                    if (openDialog.getSelectedFiles() != null) {
                        File[] openFiles;
                        for (File ofile : openFiles = openDialog.getSelectedFiles()) {
                            if (!ofile.exists() || !ofile.isFile()) continue;
                            try {
                                if (openDialog.getFileFilter() != null && !openDialog.getFileFilter().equals(openDialog.getAcceptAllFileFilter())) {
                                    GDECanvas.this.datamodel.addSequences(((DataFormat)openDialog.getFileFilter()).readFile(ofile));
                                    continue;
                                }
                                GDECanvas.this.datamodel.addSequences(DataFormat.auto(ofile));
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (openDialog.getCurrentDirectory() != null) {
                        BLMain.setCurrentPWD((File)openDialog.getCurrentDirectory());
                    }
                }
            }
        }));
        BLMain.addMenuItem((int)1, (String)"File", (JMenuItem)new JMenuItem(new AbstractAction("Save As..."){
            private static final long serialVersionUID = 7526472295622776157L;
            {
                this.putValue("MnemonicKey", new Integer(83));
            }

            public void actionPerformed(ActionEvent evt) {
                JFileChooser saveDialog = new JFileChooser();
                saveDialog.setCurrentDirectory(BLMain.getCurrentPWD());
                saveDialog.setAcceptAllFileFilterUsed(false);
                DataFormat.addFormats(saveDialog, BLMain.getProperty((String)"default.fileformat").toString());
                if (!(saveDialog.showSaveDialog(BLMain.getJFrame()) != 0 || saveDialog.getSelectedFile() == null || saveDialog.getSelectedFile().exists() && JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Overwrite", 2, 3) == 2)) {
                    try {
                        ((DataFormat)saveDialog.getFileFilter()).writeFile(saveDialog.getSelectedFile(), GDECanvas.this.datamodel.toArray());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    if (saveDialog.getCurrentDirectory() != null) {
                        BLMain.setCurrentPWD((File)saveDialog.getCurrentDirectory());
                    }
                }
            }
        }));
        BLMain.addMenuItem((int)2, (String)"File", (JMenuItem)new JMenuItem(new AbstractAction("Properties..."){
            private static final long serialVersionUID = 7526472295622776157L;
            {
                this.putValue("MnemonicKey", new Integer(80));
            }

            public void actionPerformed(ActionEvent evt) {
                new GDECanvasProperties(BLMain.getJFrame(), BLMain.getProperties());
            }
        }));
        BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.cutMenuItem, menuInsertCount++);
        BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.copyMenuItem, menuInsertCount++);
        BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.pasteMenuItem, menuInsertCount++);
        if (this.currentPane == this.nameList) {
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.groupMenuItem, menuInsertCount++);
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.ungroupMenuItem, menuInsertCount++);
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.getInfoMenuItem, menuInsertCount++);
        }
        if ("true".equalsIgnoreCase(BLMain.getProperty((String)"undo"))) {
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.undoMenuItem, menuInsertCount++);
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.redoMenuItem, menuInsertCount++);
        }
        BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.selectGroupMenuItem, menuInsertCount++);
        BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.selectAllMenuItem, menuInsertCount++);
        BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.changeCaseMenuItem, menuInsertCount++);
        BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.selectByNameMenuItem, menuInsertCount++);
        this.dataCollector = "true".equalsIgnoreCase(BLMain.getProperty((String)"undo")) ? new UndoableGDETextArea(this) : new GDETextArea(this.canvasSelf);
        this.dataCollector.addCursorListener(this);
        this.dataCollector.addModeListener(this);
        this.nameList.addListSelectionListener(this);
        BLMain.addPropertiesListener((String)"font.size", (PropertiesListener)this);
        BLMain.addPropertiesListener((String)"font.bold", (PropertiesListener)this);
        this.dataCollector.addPopupMenuItem(this.splitMenuItem);
        this.dataPane = new JScrollPane(this.dataCollector, 22, 32);
        JScrollPane listPane = new JScrollPane(this.nameList, 21, 32);
        this.dataPane.setPreferredSize(new Dimension(200, 150));
        listPane.setPreferredSize(new Dimension(100, 150));
        this.dataPane.setVerticalScrollBar(listPane.getVerticalScrollBar());
        this.updateFont();
        this.canvasPane.add(this.dataPane);
        JSplitPane mainPane = new JSplitPane(1, listPane, this.canvasPane);
        mainPane.setAlignmentX(0.5f);
        mainPane.setAlignmentY(0.5f);
        Box statusBar = new Box(2);
        statusBar.setAlignmentX(0.0f);
        statusBar.add(this.status);
        statusBar.add(this.insertStatus);
        this.add((Component)mainPane, "First");
        this.add(new JSeparator(0));
        this.add((Component)statusBar, "Last");
    }

    public String getTabName() {
        return "GDE";
    }

    private void updateFont() {
        int fontsize = 12;
        String fontsizestr = BLMain.getProperty((String)"font.size");
        if (fontsizestr != null) {
            try {
                fontsize = Integer.parseInt(fontsizestr);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        Font currentFont = new Font("Lucida Sans Typewriter", 0, fontsize);
        if ("true".equalsIgnoreCase(BLMain.getProperty((String)"font.bold"))) {
            this.dataCollector.setFont(currentFont.deriveFont(1));
        } else {
            this.dataCollector.setFont(currentFont);
        }
        this.nameList.setFont(currentFont);
    }

    public void copy() {
        if (this.currentPane != null) {
            this.currentPane.copy();
        }
    }

    public void cut() {
        if (this.currentPane != null) {
            this.currentPane.cut();
        }
    }

    public void paste() {
        if (this.currentPane != null) {
            this.currentPane.paste();
        }
    }

    private void changeCase() {
        if (this.currentPane != null) {
            this.currentPane.changeCase();
        }
    }

    public void cursorChange(BLTextArea source, int column, int row) {
        this.status.setText("Row: " + (row + 1) + " Col: " + (column + 1));
    }

    public void insertionMode(boolean mode) {
        if (mode) {
            this.insertStatus.setText("[INS]");
        } else {
            this.insertStatus.setText("     ");
        }
    }

    public void propertiesUpdate(String key, String value) {
        if (key.toLowerCase().startsWith("font.")) {
            this.updateFont();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.currentPane != this.nameList) {
            this.currentPane = this.nameList;
            this.dataCollector.clearSelection();
            if (this.altDataCollector != null) {
                this.altDataCollector.clearSelection();
            }
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.groupMenuItem, 3);
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.ungroupMenuItem, 4);
            BLMain.addMenuHeading((int)1, (String)"Edit").insert(this.getInfoMenuItem, 5);
        }
    }

    public void selectionMade(GDETextArea source) {
        if (this.currentPane != source) {
            this.currentPane = source;
            this.nameList.clearSelection();
            if (this.altDataCollector != null && source != this.altDataCollector) {
                this.altDataCollector.clearSelection();
            }
            if (source != this.dataCollector) {
                this.dataCollector.clearSelection();
            }
            BLMain.addMenuHeading((int)1, (String)"Edit").remove(this.groupMenuItem);
            BLMain.addMenuHeading((int)1, (String)"Edit").remove(this.ungroupMenuItem);
            BLMain.addMenuHeading((int)1, (String)"Edit").remove(this.getInfoMenuItem);
        }
    }

    public boolean undo() {
        boolean result = !this.undoStack.empty();
        Undoable undone = null;
        if (result && (undone = this.undoStack.pop().undo()) != null) {
            this.redoStack.push(undone);
        }
        return result;
    }

    public boolean redo() {
        boolean result = !this.redoStack.empty();
        Undoable redone = null;
        if (result && (redone = this.redoStack.pop().undo()) != null) {
            this.undoStack.push(redone);
        }
        return result;
    }

    public void addUndo(Undoable undo) {
        int undomax = 0;
        if ("true".equalsIgnoreCase(BLMain.getProperty((String)"undo"))) {
            this.redoStack.clear();
            this.undoStack.push(undo);
            if (BLMain.getProperty((String)"undo.size") != null && BLMain.testNumber((char[])BLMain.getProperty((String)"undo.size").toCharArray())) {
                try {
                    undomax = Integer.parseInt(BLMain.getProperty((String)"undo.size"));
                    while (undomax > 0 && this.undoStack.size() > undomax) {
                        this.undoStack.remove(0);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static Cell[] getClipboard() {
        String string = "";
        Cell[] clipboard = null;
        Cell[] result = null;
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null) {
                if (t.isDataFlavorSupported(ClipboardWrapper.sequenceArrayFlavour)) {
                    clipboard = (Cell[])t.getTransferData(ClipboardWrapper.sequenceArrayFlavour);
                } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    string = (String)t.getTransferData(DataFlavor.stringFlavor);
                    result = DataFormat.auto(new BufferedReader(new StringReader(string)));
                }
            }
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return result;
    }

    public static void setClipboard(Cell[] copy) {
        Cell[] result = new Cell[copy.length];
        for (int count = 0; count < copy.length; ++count) {
            result[count] = new Cell(copy[count]);
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new ClipboardWrapper(result), null);
    }

    public GDEModel getDataModel() {
        return this.datamodel;
    }

    public Cell[] getData() {
        Cell[] result = null;
        if (this.currentPane != null) {
            result = this.currentPane.getData();
        }
        return result != null ? result : new Cell[]{};
    }

    public void readFile(String format, File currentFile) {
        DataFormat formatUsed = DataFormat.getFormat(format);
        try {
            if (formatUsed != null) {
                this.datamodel.addSequences(formatUsed.readFile(currentFile));
            } else if (format == null || "".equals(format)) {
                this.datamodel.addSequences(DataFormat.auto(currentFile));
            } else {
                BLMain.error((String)"Unsupported file format", (String)"GDECanvas");
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public void writeFile(String format, File currentFile) {
        DataFormat formatUsed = DataFormat.getFormat(format);
        try {
            if (formatUsed != null) {
                formatUsed.writeFile(currentFile, this.getData());
            } else {
                BLMain.error((String)"Unsupported file format", (String)"GDECanvas");
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }
}

