/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.colourmap;

import java.awt.Color;
import java.awt.Graphics;
import org.biolegato.gdesupport.canvas.data.Cell;
import org.biolegato.gdesupport.canvas.textarea.BLTextArea;

public abstract class ColourMap {
    protected Color foreground = Color.BLACK;
    protected Color background = Color.WHITE;
    protected final Color SELECTFG = Color.WHITE;
    protected final Color SELECTBG = Color.BLUE;
    private String name = "";

    public abstract void regularDrawString(BLTextArea var1, Graphics var2, int var3, int var4, Cell var5, char[] var6, int var7, int var8);

    public void selectDrawString(BLTextArea ta, Graphics gfx, int xstart, int ystart, Cell seq, char[] drawArray, int pstart, int pend) {
        this.drawChars(ta, gfx, xstart, ystart, drawArray, pstart, pend, this.SELECTFG, this.SELECTBG);
    }

    protected void drawChars(BLTextArea ta, Graphics gfx, int xstart, int ystart, char[] array, int index, int end, Color foreground, Color background) {
        int xstartMod = 0;
        int length = Math.max(0, end - index);
        end = Math.min(end, array.length);
        gfx.setColor(background);
        gfx.fillRect(xstart, ystart, length * ta.columnSize(), ta.rowSize());
        gfx.setFont(ta.getFont());
        gfx.setColor(foreground);
        for (int column = index; column < end; ++column) {
            xstartMod = (ta.columnSize() - ta.getFontMetrics(ta.getFont()).charWidth(array[column])) / 2;
            gfx.drawChars(array, column, 1, xstart + xstartMod, ystart + ta.rowSize() - 5);
            xstart += ta.columnSize();
        }
    }

    public String safesubstring(Cell seq, int pstart, int pend) {
        String sequencetxt = seq.get("sequence").toString();
        pstart = Math.max(0, Math.min(sequencetxt.length(), pstart));
        pend = Math.max(pstart, Math.min(sequencetxt.length(), pend));
        return sequencetxt.substring(pstart, pend);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }
}

