/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.colourmask;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;
import org.biolegato.core.main.BLMain;
import org.biolegato.gdesupport.canvas.colourmap.CharacterColourMap;
import org.biolegato.gdesupport.canvas.colourmap.ColourMap;
import org.biolegato.gdesupport.canvas.colourmask.ColourMaskReader;

public class CharacterColourMaskReader
extends ColourMaskReader {
    public ColourMap[] readColourMapFile(File file) {
        int tabIndex = 0;
        char[] characterArray = null;
        String line = "";
        String maskname = null;
        Color colour = Color.BLACK;
        BufferedReader reader = null;
        CharacterColourMap mask = null;
        Hashtable<Character, Color> hash = new Hashtable<Character, Color>();
        if (file != null && file.exists() && file.isFile()) {
            try {
                reader = new BufferedReader(new FileReader(file.getPath()));
                do {
                    if ((line = reader.readLine()) == null || "aa\tcolour".equals(line = line.trim().toLowerCase()) && "aa\tcolor".equals(line) || (tabIndex = line.indexOf(9)) < 0) continue;
                    characterArray = line.substring(0, tabIndex).trim().toCharArray();
                    colour = this.string2Colour(line.substring(tabIndex + 1).trim().toCharArray());
                    for (char character : characterArray) {
                        hash.put(Character.valueOf(Character.toLowerCase(character)), colour);
                    }
                } while (line != null);
                maskname = file.getName().toLowerCase();
                if (maskname.endsWith(".csv")) {
                    maskname = maskname.substring(0, maskname.lastIndexOf(".csv"));
                }
                mask = new CharacterColourMap(maskname, hash);
            }
            catch (Throwable exception) {
                exception.printStackTrace();
            }
        } else {
            BLMain.error((String)"Invalid colour map file", (String)"GDEColourMaskColourMap");
        }
        return new ColourMap[]{mask};
    }

    public boolean accept(File f) {
        return true;
    }

    public String getDescription() {
        return "Character-based colour mask file";
    }

    private Color string2Colour(char[] array) {
        int count = array.length >= 1 && array[0] == '#' ? 1 : 0;
        Color result = Color.BLACK;
        if (array.length - count >= 6) {
            int red = this.hex2dec(array[count + 0]) * 16 + this.hex2dec(array[count + 1]);
            int green = this.hex2dec(array[count + 2]) * 16 + this.hex2dec(array[count + 3]);
            int blue = this.hex2dec(array[count + 4]) * 16 + this.hex2dec(array[count + 5]);
            result = new Color(red, green, blue);
        }
        return result;
    }

    private int hex2dec(char c) {
        int result = 0;
        if (c >= '1' && c <= '9') {
            result = 1 + (c - 49);
        } else if (c >= 'A' && c <= 'F') {
            result = 10 + (c - 65);
        } else if (c >= 'a' && c <= 'f') {
            result = 10 + (c - 97);
        }
        return result;
    }
}

