/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.list;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.biolegato.core.main.BLMain;
import org.biolegato.gdesupport.canvas.GDECanvas;
import org.biolegato.gdesupport.canvas.GDECanvasObject;
import org.biolegato.gdesupport.canvas.data.Cell;
import org.biolegato.gdesupport.canvas.data.GDEModel;
import org.biolegato.gdesupport.canvas.list.GDESequenceWindow;
import org.biolegato.gdesupport.canvas.list.SelectByNameWindow;
import org.biolegato.gdesupport.canvas.list.SequenceListModel;
import org.biolegato.gdesupport.canvas.undo.UndoMulti;
import org.biolegato.gdesupport.canvas.undo.UndoRowDeletion;

public class GDEList
extends JList
implements MouseListener,
GDECanvasObject {
    private long lastClickTime = -1000L;
    private int lastClickEntry = -1;
    private final GDEList listSelf = this;
    private GDECanvas canvas = null;
    protected JPopupMenu popup = new JPopupMenu();
    protected GDEModel datamodel;
    public final AbstractAction selectGroupAction = new AbstractAction("Select group"){
        private static final long serialVersionUID = 7526472295622776157L;
        {
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.selectGroup();
        }
    };
    public final AbstractAction getInfoAction = new AbstractAction("Get info..."){
        private static final long serialVersionUID = 7526472295622776157L;
        {
            this.putValue("MnemonicKey", new Integer(71));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.getInfo();
        }
    };
    private final JMenuItem deleteMenuItem = new JMenuItem(new AbstractAction("Delete"){
        private static final long serialVersionUID = 7526472295622776157L;
        {
            this.putValue("MnemonicKey", new Integer(68));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.delete();
        }
    });
    private final JMenuItem cutMenuItem = new JMenuItem(new AbstractAction("Cut"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.listSelf.cut();
        }
    });
    private final JMenuItem copyMenuItem = new JMenuItem(new AbstractAction("Copy"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(89));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.listSelf.copy();
        }
    });
    private final JMenuItem pasteMenuItem = new JMenuItem(new AbstractAction("Paste"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(80));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.listSelf.paste();
        }
    });
    public final AbstractAction selectAllAction = new AbstractAction("Select All"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(65));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.listSelf.selectAll();
            GDEList.this.listSelf.requestFocus();
        }
    };
    public final AbstractAction selectByNameAction = new AbstractAction("Select sequence by name"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.listSelf.requestFocus();
            GDEList.this.listSelf.requestFocusInWindow();
            new SelectByNameWindow(BLMain.getJFrame(), GDEList.this.listSelf);
        }
    };
    public final AbstractAction groupAction = new AbstractAction("Group"){
        private static final long serialVersionUID = 7526472295622777032L;

        public void actionPerformed(ActionEvent e) {
            GDEList.this.datamodel.group(GDEList.this.getSelectedIndices());
        }
    };
    public final AbstractAction ungroupAction = new AbstractAction("Ungroup"){
        private static final long serialVersionUID = 7526472295622777032L;

        public void actionPerformed(ActionEvent e) {
            GDEList.this.datamodel.ungroup(GDEList.this.getSelectedIndices());
        }
    };
    private static final long serialVersionUID = 7526472295622777009L;

    public GDEList(GDECanvas canvas) {
        super(new SequenceListModel(canvas.getDataModel()));
        this.canvas = canvas;
        this.datamodel = canvas.getDataModel();
        this.addMouseListener(this);
        this.addPopupMenuItem(this.cutMenuItem);
        this.addPopupMenuItem(this.copyMenuItem);
        this.addPopupMenuItem(this.pasteMenuItem);
        this.addPopupMenuItem(this.deleteMenuItem);
        this.addPopupMenuItem(new JMenuItem(this.groupAction));
        this.addPopupMenuItem(new JMenuItem(this.ungroupAction));
        this.addPopupMenuItem(new JMenuItem(this.selectAllAction));
        this.addPopupMenuItem(new JMenuItem(this.selectGroupAction));
        this.addPopupMenuItem(new JMenuItem(this.selectByNameAction));
        this.addPopupMenuItem(new JMenuItem(this.getInfoAction));
        this.setForeground(Color.BLACK);
        this.setBackground(new Color(255, 255, 240));
        this.setSize(this.getPreferredSize());
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() > 2 || this.getSelectedIndex() == this.lastClickEntry && event.getWhen() - this.lastClickTime < 300L) {
            this.selectGroup();
        }
        this.lastClickTime = event.getWhen();
        this.lastClickEntry = this.getSelectedIndex();
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.popup.show(event.getComponent(), event.getX() - this.getX(), event.getY() - this.getY());
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.popup.show(event.getComponent(), event.getX() - this.getX(), event.getY() - this.getY());
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public int row2Y(int r) {
        return r * this.getFontMetrics(this.getFont()).getHeight();
    }

    public int column2X(int c) {
        return c * this.getFontMetrics(this.getFont()).charWidth('a');
    }

    public int Y2Row(int Y) {
        return Y / this.getFontMetrics(this.getFont()).getHeight();
    }

    public int X2Column(int X) {
        return X / this.getFontMetrics(this.getFont()).charWidth('a');
    }

    public void copy() {
        GDECanvas.setClipboard(this.getData());
    }

    public void cut() {
        this.copy();
        this.delete();
    }

    public void paste() {
        int row = this.datamodel.getLineCount();
        Cell[] clipboard = GDECanvas.getClipboard();
        if (this.getSelectedIndex() >= 0) {
            row = this.getSelectedIndex() + 1;
        }
        for (Cell seq : clipboard) {
            this.canvas.getDataModel().addSequence(row, seq);
            ++row;
        }
    }

    public void selectAll() {
        this.setSelectionInterval(0, this.getModel().getSize() - 1);
    }

    public void changeCase() {
        String data = null;
        Cell seq = null;
        for (int sequenceNumber : this.getSelectedIndices()) {
            seq = this.datamodel.get(sequenceNumber);
            data = (String)seq.get("sequence");
            if (data.length() < 0) continue;
            if (Character.isUpperCase(data.charAt(0))) {
                seq.put("sequence", (Object)data.toLowerCase());
                continue;
            }
            seq.put("sequence", (Object)data.toUpperCase());
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setFixedCellHeight(this.getFontMetrics(font).getHeight());
        this.repaint();
    }

    public void addPopupMenuItem(JMenuItem item) {
        this.popup.add(item);
    }

    public void getInfo() {
        Cell[] sequences = this.getData();
        if (sequences.length > 0) {
            new GDESequenceWindow(this.datamodel, BLMain.getJFrame(), sequences);
        }
    }

    public void delete() {
        int[] deletionZone = this.getSelectedIndices();
        if ("true".equalsIgnoreCase(BLMain.getProperty((String)"undo"))) {
            UndoMulti undoResult = new UndoMulti();
            for (int lineNum : deletionZone) {
                undoResult.addUndo(new UndoRowDeletion(this.datamodel, lineNum, this.datamodel.get(lineNum)));
            }
        }
        this.datamodel.removeSequences(deletionZone);
    }

    public SequenceListModel getListModel() {
        return (SequenceListModel)super.getModel();
    }

    public Cell[] getData() {
        Cell seqAdd = null;
        int count = 0;
        int countseq = 0;
        int[] indexlist = this.getSelectedIndices();
        Cell[] sequencelist = new Cell[indexlist.length];
        for (count = 0; count < indexlist.length; ++count) {
            seqAdd = this.datamodel.get(indexlist[count]);
            if (seqAdd == null) continue;
            sequencelist[countseq] = seqAdd;
            ++countseq;
        }
        if (countseq < indexlist.length) {
            Cell[] temp = new Cell[countseq];
            System.arraycopy(sequencelist, 0, temp, 0, countseq);
            sequencelist = temp;
        }
        return sequencelist;
    }

    public void selectGroup() {
        int[] groupint = null;
        Cell current = null;
        List<Integer> group = null;
        for (int index : this.getSelectedIndices()) {
            current = this.datamodel.get(index);
            if (!current.containsKey("group") || !(current.get("group") instanceof Integer) || (group = this.datamodel.getgroup((Integer)current.get("group"))) == null) continue;
            groupint = new int[group.size()];
            for (int count = 0; count < group.size(); ++count) {
                groupint[count] = group.get(count);
            }
            this.setSelectedIndices(groupint);
        }
    }
}

