/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.list;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListModel;

public class SelectByNameWindow
extends JDialog
implements ActionListener {
    private JList list;
    private JTextField nameSelector = new JTextField();
    private JButton selectButton = new JButton("Select");
    private JButton deselectButton = new JButton("Deselect");
    private JButton closeButton = new JButton("Close");
    private static final long serialVersionUID = 7526472295622776150L;

    public SelectByNameWindow(JFrame window, JList list) {
        super((Frame)window, "Select by name");
        this.list = list;
        Box mainPanel = new Box(3);
        Box entryPanel = new Box(2);
        entryPanel.add(new JLabel("Name:"));
        entryPanel.add(this.nameSelector);
        mainPanel.add(entryPanel);
        Box buttonPanel = new Box(2);
        buttonPanel.add(this.selectButton);
        buttonPanel.add(this.deselectButton);
        buttonPanel.add(this.closeButton);
        mainPanel.add(buttonPanel);
        this.selectButton.addActionListener(this);
        this.selectButton.setActionCommand("select");
        this.deselectButton.addActionListener(this);
        this.deselectButton.setActionCommand("deselect");
        this.closeButton.addActionListener(this);
        this.closeButton.setActionCommand("close");
        this.nameSelector.addActionListener(this);
        this.nameSelector.setActionCommand("select");
        this.add(mainPanel);
        this.pack();
        this.setLocationRelativeTo(window);
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    public void actionPerformed(ActionEvent e) {
        String test = this.nameSelector.getText().toLowerCase();
        ListModel model = this.list.getModel();
        if ("select".equals(e.getActionCommand())) {
            for (int count = 0; count < model.getSize(); ++count) {
                if (!model.getElementAt(count).toString().toLowerCase().contains(test)) continue;
                this.list.addSelectionInterval(count, count);
            }
        } else if ("deselect".equals(e.getActionCommand())) {
            for (int count = 0; count < model.getSize(); ++count) {
                if (!model.getElementAt(count).toString().toLowerCase().contains(test)) continue;
                this.list.removeSelectionInterval(count, count);
            }
        } else if ("close".equals(e.getActionCommand())) {
            this.dispose();
        }
    }
}

