/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.textarea;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.biolegato.core.main.BLMain;
import org.biolegato.gdesupport.canvas.GDECanvas;
import org.biolegato.gdesupport.canvas.colourmap.ColourMap;
import org.biolegato.gdesupport.canvas.colourmap.MonochromeColourMap;
import org.biolegato.gdesupport.canvas.data.Cell;
import org.biolegato.gdesupport.canvas.data.GDEModel;
import org.biolegato.gdesupport.canvas.data.GDEModelListener;
import org.biolegato.gdesupport.canvas.listeners.CursorListener;
import org.biolegato.gdesupport.canvas.listeners.ModeListener;
import org.biolegato.gdesupport.canvas.textarea.BLComponent;

public class BLTextArea
extends BLComponent
implements GDEModelListener,
KeyListener,
MouseMotionListener,
MouseListener {
    protected boolean insertMode = false;
    protected boolean selectionMove = false;
    protected boolean selectionMouse = false;
    protected int row = 0;
    protected int column = 0;
    private int sx = -1;
    private int sy = -1;
    protected ColourMap currentMap = new MonochromeColourMap(Color.BLACK, Color.WHITE);
    protected JPopupMenu popup = new JPopupMenu();
    protected List<CursorListener> cursorListeners = new LinkedList<CursorListener>();
    protected List<ModeListener> modeListeners = new LinkedList<ModeListener>();
    private boolean active = false;
    protected GDEModel datamodel;
    protected final Color invalidzone = Color.RED;
    public final BLTextArea blTextAreaSelf = this;
    public static final long serialVersionUID = 7526472295622777004L;

    public BLTextArea(GDEModel datamodel) {
        this.datamodel = datamodel;
        this.getDataModel().addListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addPopupMenuItem(new JMenuItem(new AbstractAction("Cut"){
            private static final long serialVersionUID = 7526472295622777029L;

            public void actionPerformed(ActionEvent e) {
                BLTextArea.this.blTextAreaSelf.cut();
            }
        }));
        this.addPopupMenuItem(new JMenuItem(new AbstractAction("Copy"){
            private static final long serialVersionUID = 7526472295622777030L;

            public void actionPerformed(ActionEvent e) {
                BLTextArea.this.blTextAreaSelf.copy();
            }
        }));
        this.addPopupMenuItem(new JMenuItem(new AbstractAction("Paste"){
            private static final long serialVersionUID = 7526472295622777031L;

            public void actionPerformed(ActionEvent e) {
                BLTextArea.this.blTextAreaSelf.paste();
            }
        }));
        this.setFont(BLMain.DEFAULT_FONT);
        this.setForeground(Color.BLACK);
        this.setBackground(Color.WHITE);
        this.setFocusTraversalKeysEnabled(false);
        this.refreshSize();
        this.setDoubleBuffered(true);
        this.repaint();
    }

    public void addCursorListener(CursorListener listener) {
        this.cursorListeners.add(listener);
    }

    public void addModeListener(ModeListener listener) {
        this.modeListeners.add(listener);
    }

    public GDEModel getDataModel() {
        return this.datamodel;
    }

    public void setColourMap(ColourMap newMap) {
        this.currentMap = newMap;
        this.repaint();
    }

    public Cell[] getData() {
        String currentSequence = "";
        Cell current = null;
        int countseq = 0;
        int length = this.getMaxSY() - this.getMinSY() + 1;
        Cell[] result = null;
        if (!this.isSelectionEmpty()) {
            result = new Cell[length];
            for (int count = this.getMinSY(); count <= this.getMaxSY(); ++count) {
                int lineLength = this.getDataModel().getLineLength(count);
                if (this.getMinSX() >= lineLength || (current = this.getDataModel().get(count)) == null) continue;
                current = (Cell)current.clone();
                currentSequence = (String)current.get("sequence");
                if (this.getMaxSX() < lineLength) {
                    currentSequence = currentSequence.substring(0, this.getMaxSX());
                }
                if (this.getMinSX() > 0) {
                    currentSequence = currentSequence.substring(this.getMinSX());
                }
                if (!currentSequence.equals((String)current.get("sequence"))) {
                    current.put("sequence", (Object)currentSequence);
                }
                result[countseq] = current;
                ++countseq;
            }
            if (countseq < length) {
                Cell[] temp = new Cell[countseq];
                System.arraycopy(result, 0, temp, 0, countseq);
                result = temp;
            }
        } else {
            result = new Cell[]{};
        }
        return result;
    }

    public void paintComponent(Graphics gfx) {
        try {
            Rectangle area = gfx.getClipBounds();
            int startcol = Math.max(0, this.X2Column(area.x) - 1);
            int startrow = Math.max(0, this.Y2Row(area.y) - 1);
            int endcol = startcol + this.X2Column(area.width) + 2;
            int endrow = Math.min(this.getDataModel().getLineCount(), startrow + this.Y2Row(area.height) + 2);
            int xstart = this.column2X(startcol);
            int ystart = this.row2Y(startcol);
            int xend = this.column2X(endcol + 1);
            int yend = this.row2Y(startcol + 1);
            int startSelect = Math.max(startcol, Math.min(this.sx, this.column));
            int endSelect = Math.max(startcol, Math.max(this.sx, this.column));
            int startSelectX = xstart + Math.round(this.columnSize() * Math.max(0, startSelect - startcol));
            int endSelectX = xstart + Math.round(this.columnSize() * Math.max(0, endSelect - startcol));
            char[] print = null;
            ColourMap useMap = this.currentMap;
            if (gfx != null) {
                gfx.setColor(this.getBackground());
                gfx.fillRect(xstart, ystart, xend - xstart, yend - ystart);
                for (int count = startrow; count < endrow; ++count) {
                    int currenty = this.row2Y(count);
                    Cell currentLine = this.getDataModel().get(count);
                    print = ((String)currentLine.get("sequence")).toCharArray();
                    useMap = this.currentMap;
                    if (currentLine.containsKey("mask") && currentLine.get("mask") instanceof ColourMap) {
                        useMap = (ColourMap)currentLine.get("mask");
                    }
                    if (this.isSelectedLine(count) && startcol < endSelect && endSelect >= 0 && startSelect >= 0 && endSelect - startSelect > 0) {
                        useMap.regularDrawString(this, gfx, xstart, currenty, currentLine, print, startcol, startSelect);
                        useMap.selectDrawString(this, gfx, startSelectX, currenty, currentLine, print, startSelect, endSelect);
                        useMap.regularDrawString(this, gfx, endSelectX, currenty, currentLine, print, endSelect, endcol);
                        continue;
                    }
                    useMap.regularDrawString(this, gfx, xstart, currenty, currentLine, print, startcol, endcol);
                }
                if (this.hasFocus()) {
                    gfx.setColor(this.getForeground());
                    gfx.drawLine(this.column2X(this.column), this.row2Y(this.row), this.column2X(this.column), this.row2Y(this.row + 1));
                }
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.refreshSize();
        this.repaint();
    }

    public void keyTyped(KeyEvent event) {
        boolean canInsert = true;
        try {
            switch (event.getKeyChar()) {
                case '\b': 
                case '\u007f': {
                    break;
                }
                case '\n': {
                    if (this.row + 1 < this.getDataModel().getLineCount()) {
                        this.changePosition(false, Math.min(this.getDataModel().getLineLength(this.row + 1), this.column), this.row + 1);
                    }
                    break;
                }
                case '\uffff': {
                    break;
                }
                default: {
                    if (!this.isSelectionEmpty()) {
                        this.deleteSelection();
                    } else if (this.insertMode && this.getDataModel().getLineCount() > 0 && this.getDataModel().getLineLength(0) > 0) {
                        canInsert = this.delete(this.column, this.row, 1, 0);
                    }
                    if (this.isSelectionEmpty() || !this.insertMode || canInsert) {
                        this.insert(this.column, this.row, String.valueOf(event.getKeyChar()));
                        this.changePosition(false, this.column + 1, this.row);
                    }
                    break;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        event.consume();
    }

    public void keyPressed(KeyEvent event) {
        int backspacecol = 0;
        try {
            switch (event.getKeyChar()) {
                case '\b': {
                    if (!this.isSelectionEmpty()) {
                        this.deleteSelection();
                        break;
                    }
                    if (this.row > 0 || this.column > 0) {
                        if (this.column <= 0 && this.row > 0) {
                            backspacecol = this.getDataModel().getLineLength(this.row - 1);
                        }
                        if (this.column - 1 >= 0 && this.delete(this.column - 1, this.row, 1, 0)) {
                            if (this.column <= 0 && this.row > 0) {
                                this.changePosition(false, backspacecol, this.row - 1);
                                break;
                            }
                            this.changePosition(false, this.column - 1, this.row);
                        }
                    }
                    break;
                }
                case '\u007f': {
                    if (!this.isSelectionEmpty()) {
                        this.deleteSelection();
                        break;
                    }
                    if (this.getDataModel().getLineCount() > 0 && this.getDataModel().getLineLength(0) > 0) {
                        this.delete(this.column, this.row, 1, 0);
                    }
                    break;
                }
                case '\uffff': {
                    switch (event.getKeyCode()) {
                        case 16: {
                            this.selectionMove = true;
                            break;
                        }
                        case 37: {
                            if (this.column > 0) {
                                this.changePosition(this.selectionMove, this.column - 1, this.row);
                                break;
                            }
                            if (this.row <= 0) break;
                            this.changePosition(this.selectionMove, this.getDataModel().getLineLength(this.row), this.row - 1);
                            break;
                        }
                        case 39: {
                            if (this.column + 1 <= this.getDataModel().getLineLength(this.row)) {
                                this.changePosition(this.selectionMove, this.column + 1, this.row);
                                break;
                            }
                            if (this.row + 1 >= this.getDataModel().getLineCount()) break;
                            this.changePosition(this.selectionMove, 0, this.row + 1);
                            break;
                        }
                        case 38: {
                            if (this.row <= 0) break;
                            this.changePosition(this.selectionMove, Math.min(this.getDataModel().getLineLength(this.row - 1), this.column), this.row - 1);
                            break;
                        }
                        case 40: {
                            if (this.row + 1 >= this.getDataModel().getLineCount()) break;
                            this.changePosition(this.selectionMove, Math.min(this.getDataModel().getLineLength(this.row + 1), this.column), this.row + 1);
                            break;
                        }
                        case 36: {
                            this.changePosition(this.selectionMove, 0, this.row);
                            break;
                        }
                        case 35: {
                            this.changePosition(this.selectionMove, this.getDataModel().getLineLength(this.row), this.row);
                            break;
                        }
                        case 65485: {
                            this.copy();
                            break;
                        }
                        case 65489: {
                            this.cut();
                            break;
                        }
                        case 65487: {
                            this.paste();
                            break;
                        }
                        case 155: {
                            this.insertMode = !this.insertMode;
                            for (ModeListener listener : this.modeListeners) {
                                listener.insertionMode(this.insertMode);
                            }
                            break;
                        }
                        default: {
                            if (!BLMain.debug) break;
                            BLMain.warning((String)("Unhandled key pressed --- getKeyChar() = " + event.getKeyChar() + "\tgetKeyCode() = " + event.getKeyCode()), (String)"BLTextArea");
                        }
                    }
                    if (this.column >= this.getDataModel().getLineLength(this.row)) {
                        this.changePosition(this.selectionMove, this.getDataModel().getLineLength(this.row), this.row);
                    }
                    break;
                }
                default: {
                    this.deleteSelection();
                    break;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        event.consume();
    }

    public void keyReleased(KeyEvent event) {
        try {
            block1 : switch (event.getKeyChar()) {
                case '\uffff': {
                    switch (event.getKeyCode()) {
                        case 16: {
                            this.selectionMove = false;
                            break block1;
                        }
                    }
                    break;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        event.consume();
    }

    public void mouseClicked(MouseEvent event) {
        if (!event.isPopupTrigger()) {
            this.changePosition(this.selectionMove, this.X2Column(event.getX()), this.Y2Row(event.getY()));
            this.requestFocus();
            this.requestFocusInWindow();
        }
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.popup.show(this, event.getX(), event.getY());
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.popup.show(event.getComponent(), event.getX(), event.getY());
        } else {
            this.selectionMouse = false;
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mouseDragged(MouseEvent event) {
        if (!event.isPopupTrigger() || !this.isSelectionEmpty()) {
            this.changePosition(this.selectionMouse || this.selectionMove, this.X2Column(event.getX()), this.Y2Row(event.getY()));
            this.selectionMouse = true;
            this.requestFocus();
            this.requestFocusInWindow();
        }
    }

    public void mouseMoved(MouseEvent event) {
    }

    protected void refreshSize() {
        int width = (this.getDataModel().getLongestLine() + 1) * this.columnSize();
        int height = this.rowSize() * this.getDataModel().getLineCount();
        Dimension size = new Dimension(width, height);
        this.setSize(size);
        this.setPreferredSize(size);
        this.revalidate();
    }

    public void addPopupMenuItem(JMenuItem act) {
        this.popup.add(act);
    }

    public void removePopupMenuItem(JMenuItem act) {
        this.popup.remove(act);
    }

    public void copy() {
        if (!this.isSelectionEmpty()) {
            GDECanvas.setClipboard(this.getData());
        }
    }

    public void cut() {
        if (!this.isSelectionEmpty()) {
            this.copy();
            this.deleteSelection();
        }
    }

    public void paste() {
        this.deleteSelection();
        this.insert(this.column, this.row, GDECanvas.getClipboard());
    }

    public boolean insert(int col, int y, String data) {
        return this.getDataModel().insert(col, y, data);
    }

    public boolean insert(int col, int y, Cell[] data) {
        boolean result = true;
        for (int count = 0; count < data.length; ++count) {
            if (y + count < this.getDataModel().getLineCount()) {
                result &= this.insert(col, y + count, (String)data[count].get("sequence"));
                continue;
            }
            result &= this.getDataModel().addSequence(y + count, data[count]);
        }
        return result;
    }

    public boolean delete(int x, int y, int w, int h) {
        return this.getDataModel().delete(x, y, w, h);
    }

    public boolean deleteSelection() {
        int x = this.getMinSX();
        int y = this.getMinSY();
        int w = this.getMaxSX() - x;
        int h = this.getMaxSY() - y;
        boolean result = false;
        if (!this.isSelectionEmpty() && this.delete(x, y, w, h)) {
            this.changePosition(false, x, y);
            result = true;
        }
        return result;
    }

    public boolean getInsertMode() {
        return this.insertMode;
    }

    public void sequenceAdded(GDEModel source, int index, Cell sequence) {
        boolean x = false;
        int w = (int)this.getSize().getWidth();
        int y = this.row2Y(index);
        int h = (int)this.getSize().getHeight() - y;
        this.refreshSize();
        this.repaint(0, y, w, h);
    }

    public void sequenceChanged(GDEModel source, int index, Cell sequence, String key) {
        boolean x = false;
        int w = (int)this.getSize().getWidth();
        int y = this.row2Y(index);
        int h = this.rowSize();
        this.refreshSize();
        this.repaint(0, y, w, h);
    }

    public void sequenceRemoved(GDEModel source, int index, Cell sequence) {
        boolean x = false;
        int w = (int)this.getSize().getWidth();
        int y = this.row2Y(index);
        int h = (int)this.getSize().getHeight() - y;
        this.refreshSize();
        this.repaint(0, y, w, h);
    }

    protected void changePosition(boolean select, int newx, int newy) {
        int maxlines = this.getDataModel().getLineCount() - 1;
        newy = Math.max(0, Math.min(newy, maxlines));
        newx = Math.max(0, Math.min(newx, this.getDataModel().getLineLength(newy)));
        int startc = Math.min(newx, Math.min(this.column, this.sx));
        int startr = Math.min(newy, Math.min(this.row, this.sy));
        int endc = Math.max(newx, Math.max(this.column, this.sx)) + 1;
        int endr = Math.max(newy, Math.max(this.row, this.sy)) + 1;
        int x = this.column2X(startc);
        int y = this.row2Y(startr);
        int w = this.column2X(endc);
        int h = this.row2Y(endr);
        this.row = newy;
        this.column = newx;
        if (!select) {
            this.sx = this.column;
            this.sy = this.row;
        }
        this.repaint(x, y, w, h);
        for (CursorListener listener : this.cursorListeners) {
            listener.cursorChange(this, this.column, this.row);
        }
        this.scrollRectToVisible(new Rectangle(this.column2X(this.column), this.row2Y(this.row), 1, 1));
    }

    public void clearSelection() {
        this.changePosition(false, this.column, this.row);
    }

    public boolean isSelectionEmpty() {
        return this.sx == this.column || this.sx < 0;
    }

    protected int getMinSX() {
        return Math.min(this.sx, this.column);
    }

    protected int getMaxSX() {
        return Math.max(this.sx, this.column);
    }

    protected int getMinSY() {
        return Math.min(this.sy, this.row);
    }

    protected int getMaxSY() {
        return Math.max(this.sy, this.row);
    }

    protected boolean isSelectedLine(int y) {
        return y >= this.getMinSY() && y <= this.getMaxSY();
    }
}

