/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.textarea;

import java.util.List;
import java.util.regex.Pattern;
import org.biolegato.core.main.BLMain;
import org.biolegato.gdesupport.canvas.GDECanvas;
import org.biolegato.gdesupport.canvas.GDECanvasObject;
import org.biolegato.gdesupport.canvas.colourmask.ImportFileAction;
import org.biolegato.gdesupport.canvas.data.Cell;
import org.biolegato.gdesupport.canvas.textarea.BLTextArea;

public class GDETextArea
extends BLTextArea
implements GDECanvasObject {
    private static final long serialVersionUID = 7526472295622777017L;
    private GDECanvas canvas = null;

    public GDETextArea(GDECanvas canvas) {
        super(canvas.getDataModel());
        this.canvas = canvas;
        this.setColourMap(ImportFileAction.getDefaultMap());
    }

    public void changeCase() {
        String data = null;
        Cell[] seqList = null;
        if (!this.isSelectionEmpty()) {
            for (Cell seq : seqList = this.getData()) {
                data = seq.get("sequence").toString();
                if (data.length() < 0) continue;
                if (Character.isUpperCase(data.charAt(0))) {
                    seq.put("sequence", (Object)data.toLowerCase());
                    continue;
                }
                seq.put("sequence", (Object)data.toUpperCase());
            }
            this.deleteSelection();
            this.insert(this.column, this.row, seqList);
        }
    }

    public void cut() {
        if (!this.isSelectionEmpty()) {
            this.copy();
            this.pdeleteSelection();
        }
    }

    public void paste() {
        this.pdeleteSelection();
        this.insert(this.column, this.row, GDECanvas.getClipboard());
    }

    public boolean pdeleteSelection() {
        int x = this.getMinSX();
        int y = this.getMinSY();
        int w = this.getMaxSX() - x;
        int h = this.getMaxSY() - y;
        boolean result = false;
        if (!this.isSelectionEmpty() && this.pdelete(x, y, w, h)) {
            this.changePosition(false, x, y);
            result = true;
        }
        return result;
    }

    public boolean isSelectedLine(int y) {
        boolean result = super.isSelectedLine(y);
        Cell current = null;
        List<Integer> group = null;
        if (!result && (current = this.getDataModel().get(y)).get("group") instanceof Integer && (group = this.datamodel.getgroup((Integer)current.get("group"))) != null) {
            for (int gln : group) {
                if (!super.isSelectedLine(gln)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean isProtectionsOn(Cell seq, String text) {
        return this.getProtectAlignment(seq, text) || this.getProtectAmbiguous(seq, text) || this.getProtectUnambiguous(seq, text);
    }

    public boolean getProtectAlignment(Cell seq, String text) {
        boolean protect = false;
        if (Boolean.TRUE.equals(seq.get("protect_align"))) {
            if (Cell.Type.DNA.equals(seq.get("type")) || Cell.Type.RNA.equals(seq.get("type"))) {
                char[] test = text.toLowerCase().toCharArray();
                for (int count = 0; !protect && count < test.length; ++count) {
                    protect = protect || test[count] != 'a' && test[count] != 'c' && test[count] != 't' && test[count] != 'g' && test[count] != 'u' && test[count] != 'r' && test[count] != 'y' && test[count] != 'w' && test[count] != 's' && test[count] != 'm' && test[count] != 'k' && test[count] != 'h' && test[count] != 'b' && test[count] != 'v' && test[count] != 'i' && test[count] != 'd' && test[count] != 'n';
                }
            } else if (Cell.Type.PROTEIN.equals(seq.get("type"))) {
                char[] test = text.toLowerCase().toCharArray();
                for (int count = 0; !protect && count < test.length; ++count) {
                    protect = protect || test[count] == ' ' || test[count] == '\n' || test[count] == '\t' || test[count] == '\r' || test[count] == '-';
                }
                protect = Pattern.matches("[\\s-]", text);
            }
        }
        return protect;
    }

    public boolean getProtectAmbiguous(Cell seq, String text) {
        boolean protect;
        block2: {
            block3: {
                protect = false;
                if (!Boolean.TRUE.equals(seq.get("protect_ambig"))) break block2;
                if (!Cell.Type.DNA.equals(seq.get("type")) && !Cell.Type.RNA.equals(seq.get("type"))) break block3;
                char[] test = text.toLowerCase().toCharArray();
                for (int count = 0; !protect && count < test.length; ++count) {
                    protect = protect || test[count] == 'r' || test[count] == 'y' || test[count] == 'w' || test[count] == 's' || test[count] == 'm' || test[count] == 'k' || test[count] == 'h' || test[count] == 'b' || test[count] == 'v' || test[count] == 'i' || test[count] == 'd' || test[count] == 'n';
                }
                break block2;
            }
            if (!Cell.Type.PROTEIN.equals(seq.get("type"))) break block2;
            char[] test = text.toLowerCase().toCharArray();
            for (int count = 0; !protect && count < test.length; ++count) {
                protect = protect || test[count] == 'b' || test[count] == '*' || test[count] == 'z' || test[count] == 'x';
            }
        }
        return protect;
    }

    public boolean getProtectUnambiguous(Cell seq, String text) {
        boolean protect;
        block2: {
            block3: {
                protect = false;
                if (!Boolean.TRUE.equals(seq.get("protect_unambig"))) break block2;
                if (!Cell.Type.DNA.equals(seq.get("type")) && !Cell.Type.RNA.equals(seq.get("type"))) break block3;
                char[] test = text.toLowerCase().toCharArray();
                for (int count = 0; !protect && count < test.length; ++count) {
                    protect = protect || test[count] == 'a' || test[count] == 'c' || test[count] == 't' || test[count] == 'g' || test[count] == 'u';
                }
                break block2;
            }
            if (!Cell.Type.PROTEIN.equals(seq.get("type"))) break block2;
            char[] test = text.toLowerCase().toCharArray();
            for (int count = 0; !protect && count < test.length; ++count) {
                protect = protect || test[count] != 'b' && test[count] != '*' && test[count] != 'z' && test[count] != 'x' && test[count] != ' ' && test[count] != '\n' && test[count] != '\t' && test[count] != '\r' && test[count] != '-';
            }
        }
        return protect;
    }

    public boolean insert(int x, int y, String text) {
        List<Integer> group;
        boolean result = true;
        Cell current = this.getDataModel().get(y);
        if (current.get("group") instanceof Integer && (group = this.datamodel.getgroup((Integer)current.get("group"))) != null) {
            for (int number : group) {
                if (this.isProtectionsOn(this.datamodel.get(number), text)) continue;
                result &= super.insert(x, number, text);
            }
        } else if (!this.isProtectionsOn(current, text)) {
            result = super.insert(x, y, text);
        }
        return result;
    }

    public boolean delete(int x, int y, int w, int h) {
        boolean result = false;
        Cell current = null;
        for (int count = y; count <= y + h; ++count) {
            List<Integer> group;
            current = this.getDataModel().get(count);
            if (current.get("group") instanceof Integer && (group = this.datamodel.getgroup((Integer)current.get("group"))) != null) {
                for (int gln : group) {
                    if ((gln < y || gln > y + h) && gln < this.getDataModel().getLineCount()) {
                        result &= this.pdelete(x, gln, w, 0);
                        continue;
                    }
                    if (gln < this.getDataModel().getLineCount()) continue;
                    BLMain.error((String)("Invalid row number: " + gln), (String)"boolean GDETextArea.insert (char)");
                }
            }
            result = this.pdelete(x, count, w, 0);
        }
        return result;
    }

    public boolean pdelete(int x, int y, int w, int h) {
        Cell current = null;
        String text = null;
        boolean result = false;
        for (int count = y; count <= y + h; ++count) {
            current = this.getDataModel().get(count);
            text = current.get("sequence").toString();
            if (x > 0 && x < text.length()) {
                text = text.substring(x);
            } else if (x > text.length()) {
                text = "";
            }
            if (w > 0 && w < text.length()) {
                text = text.substring(0, w);
            } else if (w < 0) {
                text = "";
            }
            if (this.isProtectionsOn(current, text)) continue;
            result = super.delete(x, count, w, 0);
        }
        return result;
    }

    public void linkCanvas(GDECanvas canvas) {
        this.canvas = canvas;
    }

    protected void changePosition(boolean select, int newx, int newy) {
        super.changePosition(select, newx, newy);
        if (select && this.canvas != null) {
            this.canvas.selectionMade(this);
        }
    }
}

