/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.formats;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.biolegato.core.main.BLMain;
import org.biolegato.gdesupport.canvas.data.Cell;
import org.biolegato.gdesupport.formats.FastAFile;
import org.biolegato.gdesupport.formats.GDEFile;
import org.biolegato.gdesupport.formats.GDEFlatfile;
import org.biolegato.gdesupport.formats.GenBankFile2008;

public abstract class DataFormat
extends FileFilter {
    private static final DataFormat[] formatList = new DataFormat[]{new GenBankFile2008(), new GDEFile(), new GDEFlatfile(), new FastAFile()};

    public static void addFormats(JFileChooser filechooser, String defaultFormat) {
        DataFormat selected = null;
        for (DataFormat currentFormat : formatList) {
            filechooser.addChoosableFileFilter(currentFormat);
            if (!currentFormat.getName().equals(defaultFormat)) continue;
            selected = currentFormat;
        }
        if (selected != null) {
            filechooser.setFileFilter(selected);
        }
    }

    public Cell[] readFile(File file) throws IOException {
        Cell[] result = new Cell[]{};
        Object stream = null;
        if (file != null && file.exists() && file.isFile() && file.length() > 0L) {
            result = this.translateFrom(new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(file)))));
        }
        return result;
    }

    public void writeFile(File file, Cell[] rows) throws IOException {
        FileWriter writer = new FileWriter(file);
        for (Cell line : rows) {
            writer.write(this.translateTo(line));
        }
        writer.flush();
        writer.close();
    }

    public String getName() {
        return "";
    }

    public abstract String translateTo(Cell var1);

    public abstract Cell[] translateFrom(BufferedReader var1) throws IOException;

    public abstract boolean isFormat(Reader var1);

    public static DataFormat getFormat(String hashname) {
        DataFormat found = null;
        if (hashname != null) {
            for (DataFormat currentFormat : formatList) {
                if (currentFormat == null || !hashname.equalsIgnoreCase(currentFormat.getName())) continue;
                found = currentFormat;
                break;
            }
        }
        return found;
    }

    public static Cell[] auto(File file) {
        Cell[] result = new Cell[]{};
        try {
            result = DataFormat.auto(new FileInputStream(file));
        }
        catch (IOException ioe) {
            BLMain.error((String)("Bad file: " + file.getAbsolutePath()), (String)"DataFormat.auto");
        }
        return result;
    }

    public static Cell[] auto(InputStream stream) {
        return DataFormat.auto(new BufferedReader(new InputStreamReader(new BufferedInputStream(stream))));
    }

    public static Cell[] auto(BufferedReader data) {
        LinkedList<Cell> makeSeq = null;
        Cell[] result = null;
        if (data != null) {
            for (DataFormat currentFormat : formatList) {
                try {
                    if (!currentFormat.isFormat(data)) continue;
                    result = currentFormat.translateFrom(data);
                    break;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (result == null) {
            makeSeq = new LinkedList<Cell>();
            try {
                String line = data.readLine();
                while (line != null) {
                    makeSeq.add(new Cell(line));
                    line = data.readLine();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            result = makeSeq.toArray(new Cell[0]);
        }
        return result;
    }
}

