/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.formats;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.biolegato.core.main.BLMain;
import org.biolegato.gdesupport.canvas.data.Cell;
import org.biolegato.gdesupport.formats.DataFormat;

public class GenBankFile2008
extends DataFormat {
    public String translateTo(Cell seq) {
        StringBuffer result = new StringBuffer();
        String sequence = "";
        Object sequenceData = null;
        if (seq != null) {
            sequence = (String)seq.get("sequence");
            if (Boolean.TRUE.equals(seq.get("modified")) || "".equals(seq.get("originalgb"))) {
                result.append("LOCUS       ").append(((String)seq.get("name") + "                ").substring(0, 16)).append(" ");
                String sequenceLength = "           " + sequence.length();
                result.append(sequenceLength.substring(Math.max(0, sequenceLength.length() - 11)));
                if (!Cell.Type.PROTEIN.equals(seq.get("type"))) {
                    result.append(" bp ");
                    if (seq.get("strandedness") != null && seq.get("strandedness") instanceof Cell.Strandedness) {
                        result.append(GenBankFile2008.getGBStrandedness((Cell.Strandedness)((Object)seq.get("strandedness")))).append("-");
                        result.append(!Cell.Type.RNA.equals(seq.get("type")) ? "DNA     " : "RNA     ");
                    } else {
                        result.append(!Cell.Type.RNA.equals(seq.get("type")) ? "DNA        " : "RNA        ");
                    }
                } else {
                    result.append(" aa            ");
                }
                result.append(!Cell.Topology.CIRCULAR.equals(seq.get("topology")) ? "linear   " : "circular ");
                if (seq.containsKey("classification")) {
                    result.append(seq.get("classification")).append(" ");
                } else {
                    result.append("CON ");
                }
                if (seq.containsKey("creation-date")) {
                    result.append(seq.get("creation-date"));
                } else {
                    result.append(new SimpleDateFormat("dd-MMM-yyyy").format(new Date()).toUpperCase());
                }
                result.append("\n");
                if (!"".equals(seq.get("accession"))) {
                    result.append("ACCESSION   ").append((String)seq.get("accession")).append("\n");
                }
                if (!"".equals(seq.get("description"))) {
                    result.append("DESCRIPTION ").append((String)seq.get("description")).append("\n");
                }
                if (!"".equals(seq.get("GI"))) {
                    result.append("VERSION     ").append((!"".equals(seq.get("accession")) ? (String)seq.get("accession") + ".1" : "A00001.1") + " GI:" + (String)seq.get("GI") + "\n");
                }
            } else {
                result.append(seq.get("originalgb"));
            }
            result.append("ORIGIN");
            for (int count = 0; count < sequence.length(); count += 60) {
                result.append("\n").append(GenBankFile2008.GBRightJustify("" + (count + 1)));
                for (int spaceCount = count; spaceCount < count + 60 && spaceCount < sequence.length(); spaceCount += 10) {
                    result.append(" ").append(sequence.substring(spaceCount, Math.min(sequence.length(), spaceCount + 10)));
                }
            }
            result.append("\n//\n");
        }
        return result.toString();
    }

    public Cell[] translateFrom(BufferedReader data) throws IOException {
        String name = "";
        String value = "";
        StringBuffer valueBuffer = new StringBuffer();
        String line = "";
        String temp = "";
        StringBuffer original = new StringBuffer();
        int index = 0;
        int tabIndex = 0;
        int spaceIndex = 0;
        LinkedList<Cell> result = new LinkedList<Cell>();
        StringTokenizer tokenz = null;
        Hashtable<String, Object> sequence = new Hashtable<String, Object>();
        while ((line = data.readLine()) != null) {
            spaceIndex = line.indexOf(32);
            tabIndex = line.indexOf(9);
            index = tabIndex <= 0 || tabIndex <= 0 ? Math.max(tabIndex, spaceIndex) : Math.min(tabIndex, spaceIndex);
            if (index == 0 && name != null && !"".equals(name)) {
                valueBuffer.append(line.trim());
            } else if (!"".equals(line) && index != 0) {
                if (!"".equals(name)) {
                    value = valueBuffer.toString();
                    if ("sequence".equals(name)) {
                        value = value.replaceAll("[\\d\\s]", "");
                    }
                    sequence.put(name, value);
                    name = "";
                }
                if ("//".equals(line.trim())) {
                    sequence.put("originalgb", original);
                    result.add(new Cell((Map<String, Object>)sequence));
                    sequence.clear();
                    original = new StringBuffer();
                } else {
                    valueBuffer = new StringBuffer();
                    if (index > 0) {
                        name = line.substring(0, index).trim().toLowerCase();
                        valueBuffer.append(line.substring(index + 1).trim());
                        value = line.substring(index + 1).trim();
                    } else {
                        name = line.trim().toLowerCase();
                    }
                    if ("locus".equals(name)) {
                        if (!sequence.isEmpty()) {
                            sequence.put("originalgb", original);
                            result.add(new Cell((Map<String, Object>)sequence));
                            sequence.clear();
                            original = new StringBuffer();
                            BLMain.warning((String)"Genbank entry missing // terminator", (String)"GenBankFile2008.class");
                        }
                        if ((tokenz = new StringTokenizer(value)).hasMoreTokens()) {
                            sequence.put("name", tokenz.nextToken());
                        }
                        if (tokenz.hasMoreTokens()) {
                            tokenz.nextToken();
                        }
                        if (tokenz.hasMoreTokens()) {
                            temp = tokenz.nextToken();
                            if ("aa".equals(temp)) {
                                sequence.put("type", (Object)Cell.Type.PROTEIN);
                            } else if ("bp".equals(temp) && tokenz.hasMoreTokens()) {
                                temp = tokenz.nextToken();
                                if (temp.contains("-")) {
                                    sequence.put("strandedness", (Object)GenBankFile2008.toStrandedness(temp.substring(0, temp.indexOf("-"))));
                                    sequence.put("type", (Object)GenBankFile2008.toType(temp.substring(temp.indexOf("-") + 1)));
                                } else {
                                    sequence.put("type", (Object)GenBankFile2008.toType(temp));
                                }
                            }
                        }
                        if (tokenz.hasMoreTokens()) {
                            temp = tokenz.nextToken();
                            if ("circular".equals(temp.toLowerCase())) {
                                sequence.put("topology", (Object)Cell.Topology.CIRCULAR);
                            } else {
                                if (!"linear".equals(temp.toLowerCase())) {
                                    sequence.put("classification", temp);
                                } else if (tokenz.hasMoreTokens()) {
                                    sequence.put("classification", tokenz.nextToken());
                                }
                                sequence.put("topology", (Object)Cell.Topology.LINEAR);
                            }
                        }
                        if (tokenz.hasMoreTokens()) {
                            sequence.put("creation-date", tokenz.nextToken());
                        }
                        name = "";
                    } else if ("version".equals(name) && value.contains("GI:")) {
                        sequence.put("GI", value.substring(value.indexOf("GI:") + 3).trim());
                    } else if ("origin".equals(name)) {
                        name = "sequence";
                        valueBuffer = new StringBuffer();
                    }
                }
            }
            if ("sequence".equals(name) || line.startsWith("//")) continue;
            original.append(line).append("\n");
        }
        if (!sequence.isEmpty()) {
            sequence.put("originalgb", original);
            result.add(new Cell((Map<String, Object>)sequence));
            sequence.clear();
            BLMain.warning((String)"Genbank entry missing // terminator", (String)"GenBankFile2008.class");
        }
        return result.toArray(new Cell[0]);
    }

    public boolean accept(File file) {
        return file.isDirectory() || file.getAbsolutePath().toLowerCase().endsWith(".gen") || file.getAbsolutePath().toLowerCase().endsWith(".gp") || file.getAbsolutePath().toLowerCase().endsWith(".gb");
    }

    public String getName() {
        return "genbank";
    }

    public String getDescription() {
        return "GenBank file (*.gb,*.gp,*.gen)";
    }

    private static String getGBStrandedness(Cell.Strandedness value) {
        String result = "ss";
        switch (value) {
            case DOUBLE: {
                result = "ds";
                break;
            }
            case MIXED: {
                result = "ms";
            }
        }
        return result;
    }

    private static Cell.Strandedness toStrandedness(String string) {
        Cell.Strandedness result = Cell.Strandedness.MIXED;
        if ("ss".equalsIgnoreCase(string)) {
            result = Cell.Strandedness.SINGLE;
        } else if ("ds".equalsIgnoreCase(string)) {
            result = Cell.Strandedness.DOUBLE;
        }
        return result;
    }

    private static Cell.Type toType(String string) {
        Cell.Type result = Cell.Type.DNA;
        if (string.toLowerCase().contains("rna")) {
            result = Cell.Type.RNA;
        }
        return result;
    }

    private static String GBRightJustify(String string) {
        return (9 - string.length() > 0 ? "            ".substring(0, 9 - string.length()) : "") + string;
    }

    public boolean isFormat(Reader test) {
        int check = 32;
        boolean result = false;
        try {
            while (check == 32 || check == 9 || check == 10 || check == 13) {
                test.mark(10);
                check = test.read();
            }
            if (!(check != 76 && check != 108 || (check = test.read()) != 79 && check != 111 || (check = test.read()) != 67 && check != 99 || (check = test.read()) != 85 && check != 117 || (check = test.read()) != 83 && check != 115)) {
                result = true;
            }
            test.reset();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return result;
    }
}

